/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.portForwarding.utils.WindowsProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] a;
    private static final String[] b;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 42599466077125L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.a(1980467700 - 19011, 1980467700 - 5439, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.a(1980467700 - 19012, -1980467700 - -11693, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 84481557356985L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.n();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 == 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.a(-449307960 + -((char)-15111), -449307960 + -((char)-3631), (int)l2) + string + WindowsNamedPipeAgentIpc.a(-449307960 + -((char)-15110), 449307960 + (char)-11986, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.a(-449307960 + -((char)-15105), 449307960 + (char)-23808, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 140414315982215L;
                Object object = this.lock;
                n2 = SshAgentIpcService.n();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.a(-1049870700 - -((char)-25758), 1049870700 - (char)-17191, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-1049870700 - -((char)-25759), -1049870700 - -24953, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (n2 == 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.a(-1049870700 - -((char)-25760), -1049870700 - -29744, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-1049870700 - -((char)-25753), -1049870700 - -((char)-29287), (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(-1049870700 - -((char)-25754), 1049870700 - (char)-18816, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.a(-1049870700 - -((char)-25760), -1049870700 - -29744, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-1049870700 - -((char)-25755), -1049870700 - -((char)-26241), (int)l2));
            if (ActionTimestamp.n() != 0) {
                SshAgentIpcService.n(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 65081959622012L;
                    n3 = SshAgentIpcService.n();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 == 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 == 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        Object object;
        Object object2;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 138760536274210L;
                int n3 = SshAgentIpcService.n();
                this.assertConnectionThread();
                n2 = n3;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 == 0) break block23;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18987), 1267053690 + (char)-6857, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18999), -1267053690 + -((char)-7899), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18990), -1267184760 - -((char)-9458), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18999), -1267053690 + -((char)-7899), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18989), 1267184760 - (char)-3195, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18987), 1267053690 + (char)-6857, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18999), -1267053690 + -((char)-7899), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18992), -1267184760 - -((char)-13098), (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (n2 == 0) break block25;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n4 = Kernel32.INSTANCE.GetLastError();
                if (n4 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18987), 1267053690 + (char)-6857, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18999), -1267053690 + -((char)-7899), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18991), -1267184760 - -((char)-15729), (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18999), -1267053690 + -((char)-7899), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-19010), 1267184760 - (char)-4371, (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n4)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block27: {
                block28: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (n2 == 0) break block27;
                    try {
                        block29: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block28;
                            break block29;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18999), -1267053690 + -((char)-7899), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18989), 1267184760 - (char)-3195, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18987), 1267053690 + (char)-6857, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-18999), -1267053690 + -((char)-7899), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(-1267184760 - -((char)-19009), -1267184760 - -((char)-16622), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        SshAgentIpc.Streams streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
            final /* synthetic */ PipeReadableByteChannel $read;
            final /* synthetic */ PipeWritableByteChannel $write;
            final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
            private static final String[] a;
            private static final String[] b;
            {
                this.$read = $read;
                this.$write = $write;
                this.this$0 = $receiver;
            }

            public InputStream getInputStream() {
                long l2 = 78181685087060L;
                InputStream inputStream = Channels.newInputStream(this.$read);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(395438190 - (char)-6699, 395438190 - (char)-9380, (int)l2));
                return inputStream;
            }

            public OutputStream getOutputStream() {
                long l2 = 86314859204635L;
                OutputStream outputStream = Channels.newOutputStream(this.$write);
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1098497670 + -26531, 1098497670 + (char)-22152, (int)l2));
                return outputStream;
            }

            public void close() {
                WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var5 = new String[2];
                    var3_1 = 0;
                    var2_2 = "\u0006\u0014Zc\u00d9\u0083\u00ceIp\u00e9$\u00c7&\u007f\u0092 \u001f\u00a0D\u0014\u00e4\u0000\u0006\u00e7I\u00d1\u00a1\u0086\u001f\u0016\f\u00ec\u00e1\u00e3\u00ab8\u00d5e\u001a\u0091";
                    var4_3 = "\u0006\u0014Zc\u00d9\u0083\u00ceIp\u00e9$\u00c7&\u007f\u0092 \u001f\u00a0D\u0014\u00e4\u0000\u0006\u00e7I\u00d1\u00a1\u0086\u001f\u0016\f\u00ec\u00e1\u00e3\u00ab8\u00d5e\u001a\u0091".length();
                    var1_4 = 19;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl9:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = new String(v0).intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                    v3 = v2.length;
                    var6_6 = 0;
                    v4 = 19;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl67
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_6;
                        while (true) {
                            switch (var6_6 % 7) {
                                case 0: {
                                    v11 = 106;
                                    break;
                                }
                                case 1: {
                                    v11 = 115;
                                    break;
                                }
                                case 2: {
                                    v11 = 114;
                                    break;
                                }
                                case 3: {
                                    v11 = 126;
                                    break;
                                }
                                case 4: {
                                    v11 = 90;
                                    break;
                                }
                                case 5: {
                                    v11 = 65;
                                    break;
                                }
                                default: {
                                    v11 = 25;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_6;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl67:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_6);
                    ** while (true)
                }
                accept.3.a = var5;
                accept.3.b = new String[2];
            }

            private static String a(int n2, int n3, int n4) {
                int n5 = (n2 ^ n4 ^ 0x49CD) & 0xFFFF;
                if (b[n5] == null) {
                    int n6;
                    char[] cArray = a[n5].toCharArray();
                    int n7 = switch (cArray[0] & 0xFF) {
                        case 0 -> 188;
                        case 1 -> 197;
                        case 2 -> 49;
                        case 3 -> 200;
                        case 4 -> 165;
                        case 5 -> 122;
                        case 6 -> 215;
                        case 7 -> 211;
                        case 8 -> 182;
                        case 9 -> 144;
                        case 10 -> 172;
                        case 11 -> 30;
                        case 12 -> 120;
                        case 13 -> 153;
                        case 14 -> 36;
                        case 15 -> 40;
                        case 16 -> 123;
                        case 17 -> 223;
                        case 18 -> 155;
                        case 19 -> 43;
                        case 20 -> 176;
                        case 21 -> 88;
                        case 22 -> 194;
                        case 23 -> 198;
                        case 24 -> 85;
                        case 25 -> 55;
                        case 26 -> 174;
                        case 27 -> 141;
                        case 28 -> 206;
                        case 29 -> 251;
                        case 30 -> 212;
                        case 31 -> 202;
                        case 32 -> 112;
                        case 33 -> 216;
                        case 34 -> 195;
                        case 35 -> 135;
                        case 36 -> 46;
                        case 37 -> 63;
                        case 38 -> 114;
                        case 39 -> 57;
                        case 40 -> 98;
                        case 41 -> 192;
                        case 42 -> 89;
                        case 43 -> 106;
                        case 44 -> 171;
                        case 45 -> 68;
                        case 46 -> 140;
                        case 47 -> 235;
                        case 48 -> 249;
                        case 49 -> 209;
                        case 50 -> 181;
                        case 51 -> 253;
                        case 52 -> 94;
                        case 53 -> 250;
                        case 54 -> 6;
                        case 55 -> 93;
                        case 56 -> 226;
                        case 57 -> 47;
                        case 58 -> 227;
                        case 59 -> 164;
                        case 60 -> 59;
                        case 61 -> 111;
                        case 62 -> 83;
                        case 63 -> 131;
                        case 64 -> 219;
                        case 65 -> 177;
                        case 66 -> 170;
                        case 67 -> 163;
                        case 68 -> 8;
                        case 69 -> 252;
                        case 70 -> 175;
                        case 71 -> 225;
                        case 72 -> 151;
                        case 73 -> 156;
                        case 74 -> 178;
                        case 75 -> 67;
                        case 76 -> 222;
                        case 77 -> 48;
                        case 78 -> 126;
                        case 79 -> 22;
                        case 80 -> 229;
                        case 81 -> 76;
                        case 82 -> 147;
                        case 83 -> 127;
                        case 84 -> 125;
                        case 85 -> 113;
                        case 86 -> 238;
                        case 87 -> 203;
                        case 88 -> 231;
                        case 89 -> 23;
                        case 90 -> 136;
                        case 91 -> 138;
                        case 92 -> 185;
                        case 93 -> 26;
                        case 94 -> 17;
                        case 95 -> 34;
                        case 96 -> 102;
                        case 97 -> 207;
                        case 98 -> 236;
                        case 99 -> 191;
                        case 100 -> 66;
                        case 101 -> 124;
                        case 102 -> 18;
                        case 103 -> 159;
                        case 104 -> 230;
                        case 105 -> 240;
                        case 106 -> 228;
                        case 107 -> 243;
                        case 108 -> 61;
                        case 109 -> 208;
                        case 110 -> 205;
                        case 111 -> 96;
                        case 112 -> 91;
                        case 113 -> 145;
                        case 114 -> 72;
                        case 115 -> 186;
                        case 116 -> 190;
                        case 117 -> 169;
                        case 118 -> 196;
                        case 119 -> 41;
                        case 120 -> 103;
                        case 121 -> 187;
                        case 122 -> 245;
                        case 123 -> 39;
                        case 124 -> 60;
                        case 125 -> 27;
                        case 126 -> 9;
                        case 127 -> 53;
                        case 128 -> 162;
                        case 129 -> 152;
                        case 130 -> 184;
                        case 131 -> 246;
                        case 132 -> 70;
                        case 133 -> 108;
                        case 134 -> 107;
                        case 135 -> 133;
                        case 136 -> 237;
                        case 137 -> 1;
                        case 138 -> 239;
                        case 139 -> 97;
                        case 140 -> 129;
                        case 141 -> 160;
                        case 142 -> 25;
                        case 143 -> 118;
                        case 144 -> 116;
                        case 145 -> 214;
                        case 146 -> 16;
                        case 147 -> 75;
                        case 148 -> 82;
                        case 149 -> 44;
                        case 150 -> 248;
                        case 151 -> 69;
                        case 152 -> 11;
                        case 153 -> 254;
                        case 154 -> 255;
                        case 155 -> 95;
                        case 156 -> 35;
                        case 157 -> 242;
                        case 158 -> 73;
                        case 159 -> 58;
                        case 160 -> 78;
                        case 161 -> 81;
                        case 162 -> 173;
                        case 163 -> 180;
                        case 164 -> 233;
                        case 165 -> 117;
                        case 166 -> 87;
                        case 167 -> 166;
                        case 168 -> 167;
                        case 169 -> 119;
                        case 170 -> 157;
                        case 171 -> 10;
                        case 172 -> 14;
                        case 173 -> 234;
                        case 174 -> 3;
                        case 175 -> 37;
                        case 176 -> 4;
                        case 177 -> 221;
                        case 178 -> 38;
                        case 179 -> 62;
                        case 180 -> 28;
                        case 181 -> 92;
                        case 182 -> 217;
                        case 183 -> 21;
                        case 184 -> 244;
                        case 185 -> 104;
                        case 186 -> 161;
                        case 187 -> 52;
                        case 188 -> 79;
                        case 189 -> 54;
                        case 190 -> 247;
                        case 191 -> 110;
                        case 192 -> 32;
                        case 193 -> 15;
                        case 194 -> 241;
                        case 195 -> 213;
                        case 196 -> 0;
                        case 197 -> 183;
                        case 198 -> 210;
                        case 199 -> 168;
                        case 200 -> 199;
                        case 201 -> 121;
                        case 202 -> 51;
                        case 203 -> 201;
                        case 204 -> 13;
                        case 205 -> 105;
                        case 206 -> 86;
                        case 207 -> 137;
                        case 208 -> 101;
                        case 209 -> 24;
                        case 210 -> 115;
                        case 211 -> 100;
                        case 212 -> 84;
                        case 213 -> 189;
                        case 214 -> 33;
                        case 215 -> 29;
                        case 216 -> 150;
                        case 217 -> 71;
                        case 218 -> 19;
                        case 219 -> 134;
                        case 220 -> 224;
                        case 221 -> 31;
                        case 222 -> 154;
                        case 223 -> 204;
                        case 224 -> 12;
                        case 225 -> 130;
                        case 226 -> 109;
                        case 227 -> 50;
                        case 228 -> 218;
                        case 229 -> 64;
                        case 230 -> 2;
                        case 231 -> 56;
                        case 232 -> 80;
                        case 233 -> 128;
                        case 234 -> 42;
                        case 235 -> 148;
                        case 236 -> 5;
                        case 237 -> 158;
                        case 238 -> 20;
                        case 239 -> 220;
                        case 240 -> 139;
                        case 241 -> 65;
                        case 242 -> 146;
                        case 243 -> 179;
                        case 244 -> 232;
                        case 245 -> 7;
                        case 246 -> 74;
                        case 247 -> 143;
                        case 248 -> 132;
                        case 249 -> 99;
                        case 250 -> 77;
                        case 251 -> 193;
                        case 252 -> 142;
                        case 253 -> 90;
                        case 254 -> 149;
                        default -> 45;
                    };
                    int n8 = ((n3 ^= n4) & 0xFF) - n7;
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                        n6 += 256;
                    }
                    int n9 = 0;
                    while (n9 < cArray.length) {
                        int n10 = n9 % 2;
                        int n11 = n9;
                        char[] cArray2 = cArray;
                        char c2 = cArray[n11];
                        if (n10 == 0) {
                            cArray2[n11] = (char)(c2 ^ n8);
                            n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                        } else {
                            cArray2[n11] = (char)(c2 ^ n6);
                            n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                        }
                        ++n9;
                    }
                    accept.3.b[n5] = new String(cArray).intern();
                }
                return b[n5];
            }
        };
        if (n2 == 0) {
            int n5 = ActionTimestamp.y();
            ActionTimestamp.n(++n5);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 14878968017062L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.n();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 == 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(1201256550 + (char)-29581, -1201256550 + -27493, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.a(1201256550 + (char)-29585, 1201256550 + 30591, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.a(1201256550 + (char)-29606, 1201256550 + 31669, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(1201256550 + (char)-29581, -1201256550 + -27493, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.a(1201256550 + (char)-29585, 1201256550 + 30591, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.a(1201256550 + (char)-29605, -1201256550 + -29824, (int)l3) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 130289237810586L;
                        int n3 = SshAgentIpcService.n();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.a(1404939330 - (char)-15800, 1404939330 - (char)-5655, (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 == 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 == 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.a(1404939330 - (char)-15801, 1404939330 - (char)-20057, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 == 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 18288419092558L;
                int n3 = SshAgentIpcService.y();
                this.assertConnectionThread();
                n2 = n3;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 != 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 != 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(448390470 - (char)-9963, -448390470 - -31267, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.a(448390470 - (char)-9975, 448390470 - 32313, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(448390470 - (char)-9958, -448390470 - -((char)-29304), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.a(448390470 - (char)-9975, 448390470 - 32313, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(448390470 - (char)-9969, -448390470 - -((char)-19739), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(448390470 - (char)-9963, -448390470 - -31267, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.a(448390470 - (char)-9975, 448390470 - 32313, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(448390470 - (char)-9959, -448390470 - -((char)-23750), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 != 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(448390470 - (char)-9963, -448390470 - -31267, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.a(448390470 - (char)-9975, 448390470 - 32313, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(448390470 - (char)-9948, -448390470 - -((char)-11967), (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 != 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(448390470 - (char)-9963, -448390470 - -31267, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.a(448390470 - (char)-9975, 448390470 - 32313, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(448390470 - (char)-9949, 448390470 - 26210, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 2014754984425L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                n3 = SshAgentIpcService.y();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 != 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(415360830 - (char)-32344, -415360830 - -((char)-6984), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.a(415360830 - (char)-32348, 415360830 - (char)-10092, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(415360830 - (char)-32329, 415360830 - (char)-11300, (int)l2) + this.state + WindowsNamedPipeAgentIpc.a(415360830 - (char)-32328, -415360830 - -((char)-7811), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(415360830 - (char)-32344, -415360830 - -((char)-6984), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.a(415360830 - (char)-32348, 415360830 - (char)-10092, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(415360830 - (char)-32323, 415360830 - (char)-23402, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 != 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 != 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(415360830 - (char)-32344, -415360830 - -((char)-6984), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.a(415360830 - (char)-32348, 415360830 - (char)-10092, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(415360830 - (char)-32322, -415360830 - -27716, (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(415360830 - (char)-32344, -415360830 - -((char)-6984), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.a(415360830 - (char)-32348, 415360830 - (char)-10092, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(415360830 - (char)-32325, -415360830 - -((char)-12574), (int)l2));
                    if (n3 != 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.a(415360830 - (char)-32344, -415360830 - -((char)-6984), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.a(415360830 - (char)-32348, 415360830 - (char)-10092, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.a(415360830 - (char)-32324, 415360830 - (char)-32250, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u0086\u00a0\u00e3}\u00e9\u000f\u00bd\u00a3\u0014\u00bb\u0098|\u009d\u00e4\u009b\u00b3+y\u00adh#\u00ceC$XL\u0093\u000e\u00fa\u0006\u00b5\u00e1\u0085UOK\u0018\u00b4\u00b3\u00fd\u00c8V\u00f4\u00e7\u0006;u/H@\u00d1\u00a7\u0088\u0095\u00e0\u001b\tp,\u001bL\t\u001c\u00f0v\u0011LP\u00bc\u00dal\u0005\u00b35E\u00cfM\b9.\u0014\u00ddE=.\u0007\u0005\u0012_q\u0082\u00cb\u001e\u00cf\u0004\u00df\u008d\u0083\u0098\u00ff\u00f1\u009d\u009f\u00b0\u0092\u00ff\u00aa\u00f2\u0083\u00de\u0010\u00a0\u00e3\u00ab^l\u00cf\u009d\u00ca$\u00a4\u00ad\u00a0\u0010\u00f4\"\\\u008c\u00a4\u008a\u00edJ\u00a2Z\u00da\u00d7\u00b4W4\u00a3\t\u00b5D\u0095\u0096c\u0087\u007f\u00bf\u00fa\u0010b\u000f\u008e)\u00fe>\u00a6\u00dc\u00cb\u0088\u00f7\u008d\u0011\u001c\u0080\u00ca?\u00e8\u00c53\u00b5\u0013\u0096h\\\u001e\u00fb\u0085\u00e5\u00e6\u00b2\u00ec\u00b9\u00d82\u001db\u0092<0\u00e5\u0006gZ\u00a5U\u00d6\u0010\u00c4\u001b\u00cf\u0085\u00fe\u00a9\t\u000e\u00b9F2e\u0088\u00f0zi\u0090!\u00ee\u00e8\u00ce?\u001dR]\u00f7\u00b8\u0093#GD\u0081\b'\u00a9\u00d7-=#!\u00c4\f8\u00db$x^\u00eb\u00a3\u00daB\u0000\u0094\u0098F\u0090\u00c41\u009b\u00fc\u0097\u00f7U\u00c8\u00fd\u00cf\u00e39z\b\u0086\u00b8\u00b2\u0011\u00dd\u0001\u0099Ac\u001e\u009c\u00aa\u00d1\u00f4q\u001e\f\u00e6`\u00f8*\u00dc\u00de\u000b\u0087u\u00e0\u0088)\u0093\u00cbQ\u00db\u00c1\u007f\u0092V\u009f\u0098P\u00f6(\u00b9\u00fe\u00bf\u00d9\u00be\u000eZb\u00d2\u009d`\u0091\u0083\u001f}f\u0089\u00c1I\u0011\u00a6\u00c0\u00b6\u00b9\u00d5VS/l\u0082v\u00d8\u00c80m\u00a4c;\u001d\u0084#\u00a1P\u00f1\u0088\u000b\u00ca\u0013za\u0095\u00c8\u00da\u00bem\u0080{\u0015B\u00ebk}\u00b0#\u0092\u00beZ`U\u00a6\u00fd\u009d\u00a4\u0082\u0094LI\u00dbk)\u0099\u00e2\u0015Q\u00da\u0003\u00d4\u0082\u00f8\u00f1\u001c_n\u0004U\u00e2\u000e\\\u001c\u0007\u0007:\u00e8\u00f0\u0003\u00b47\u00df\u00fd\u00ca\u00bfE,\u00ec\u00c76%@\u00bf\u00fd@\u0007\u008bm]\u00ba\u00f7#\u00ea\u0007\u00caX\u0011p\u0099\u00951(\u00b7:\u009ck[.\u0012\u0000Pv#\u0099\u00aa]\u008fJR\u00e49S\u00c2\u008e?\u00adi\u00a3\u00ccF\u00b5\u0099m6\u008d\u00e9m;\u00ca\u009c\u00d1\u0095\u000fI\u00d6\r\u00df\u0081\u00d4\u00ec\u009c\u00fah\u00d7\u000b\u0094[\u00d6\"\u00e2\u0092z_7\u00c2i\u00baO\u00f6\u00ea\u00bf\u00b3\u0014\u008a.\u001e\u00ec\u0094S\u00fc\u00b07\u00f1k\u00c0\u00f7\u008f\u00c1\u00f2\u009aE\u00a6\u001f\u000e\u00cfy\u00dd*\u009bj\u00afK\u0092\u0092\u00daT9\u00ba\u001b\u00eb`^\f\u0010\u001bK9Y[.l\u00f7\u008b$\u00cbc\u00fa\u0086\r\u0085Ok\u00a8\u00ab\u0086\u00ba\n\u00ee\u007f:\u00e8\u0088c\u008b\u001c\u00ea\u009d\u0018\u0088\u00e82\u0010\u009c$\u00fb\u0080Q\u00a5\u00ed,6\u00d0\u00e0\u0081\u008c\u00b2\u00ac}\u00b8\n\u0097S)\u00a5\u00e8\u0092\u0010*+\u00ca\u0087;QdKe\u008f\u00ab\u00e8\u00afh\u00f7D@BI\u00f3BF\u0082m\u0018\u00c0\u00b8\u0095\u00e9(\u00aa:V\u00e5\u00d1I\u008d";
                var4_3 = "\u0086\u00a0\u00e3}\u00e9\u000f\u00bd\u00a3\u0014\u00bb\u0098|\u009d\u00e4\u009b\u00b3+y\u00adh#\u00ceC$XL\u0093\u000e\u00fa\u0006\u00b5\u00e1\u0085UOK\u0018\u00b4\u00b3\u00fd\u00c8V\u00f4\u00e7\u0006;u/H@\u00d1\u00a7\u0088\u0095\u00e0\u001b\tp,\u001bL\t\u001c\u00f0v\u0011LP\u00bc\u00dal\u0005\u00b35E\u00cfM\b9.\u0014\u00ddE=.\u0007\u0005\u0012_q\u0082\u00cb\u001e\u00cf\u0004\u00df\u008d\u0083\u0098\u00ff\u00f1\u009d\u009f\u00b0\u0092\u00ff\u00aa\u00f2\u0083\u00de\u0010\u00a0\u00e3\u00ab^l\u00cf\u009d\u00ca$\u00a4\u00ad\u00a0\u0010\u00f4\"\\\u008c\u00a4\u008a\u00edJ\u00a2Z\u00da\u00d7\u00b4W4\u00a3\t\u00b5D\u0095\u0096c\u0087\u007f\u00bf\u00fa\u0010b\u000f\u008e)\u00fe>\u00a6\u00dc\u00cb\u0088\u00f7\u008d\u0011\u001c\u0080\u00ca?\u00e8\u00c53\u00b5\u0013\u0096h\\\u001e\u00fb\u0085\u00e5\u00e6\u00b2\u00ec\u00b9\u00d82\u001db\u0092<0\u00e5\u0006gZ\u00a5U\u00d6\u0010\u00c4\u001b\u00cf\u0085\u00fe\u00a9\t\u000e\u00b9F2e\u0088\u00f0zi\u0090!\u00ee\u00e8\u00ce?\u001dR]\u00f7\u00b8\u0093#GD\u0081\b'\u00a9\u00d7-=#!\u00c4\f8\u00db$x^\u00eb\u00a3\u00daB\u0000\u0094\u0098F\u0090\u00c41\u009b\u00fc\u0097\u00f7U\u00c8\u00fd\u00cf\u00e39z\b\u0086\u00b8\u00b2\u0011\u00dd\u0001\u0099Ac\u001e\u009c\u00aa\u00d1\u00f4q\u001e\f\u00e6`\u00f8*\u00dc\u00de\u000b\u0087u\u00e0\u0088)\u0093\u00cbQ\u00db\u00c1\u007f\u0092V\u009f\u0098P\u00f6(\u00b9\u00fe\u00bf\u00d9\u00be\u000eZb\u00d2\u009d`\u0091\u0083\u001f}f\u0089\u00c1I\u0011\u00a6\u00c0\u00b6\u00b9\u00d5VS/l\u0082v\u00d8\u00c80m\u00a4c;\u001d\u0084#\u00a1P\u00f1\u0088\u000b\u00ca\u0013za\u0095\u00c8\u00da\u00bem\u0080{\u0015B\u00ebk}\u00b0#\u0092\u00beZ`U\u00a6\u00fd\u009d\u00a4\u0082\u0094LI\u00dbk)\u0099\u00e2\u0015Q\u00da\u0003\u00d4\u0082\u00f8\u00f1\u001c_n\u0004U\u00e2\u000e\\\u001c\u0007\u0007:\u00e8\u00f0\u0003\u00b47\u00df\u00fd\u00ca\u00bfE,\u00ec\u00c76%@\u00bf\u00fd@\u0007\u008bm]\u00ba\u00f7#\u00ea\u0007\u00caX\u0011p\u0099\u00951(\u00b7:\u009ck[.\u0012\u0000Pv#\u0099\u00aa]\u008fJR\u00e49S\u00c2\u008e?\u00adi\u00a3\u00ccF\u00b5\u0099m6\u008d\u00e9m;\u00ca\u009c\u00d1\u0095\u000fI\u00d6\r\u00df\u0081\u00d4\u00ec\u009c\u00fah\u00d7\u000b\u0094[\u00d6\"\u00e2\u0092z_7\u00c2i\u00baO\u00f6\u00ea\u00bf\u00b3\u0014\u008a.\u001e\u00ec\u0094S\u00fc\u00b07\u00f1k\u00c0\u00f7\u008f\u00c1\u00f2\u009aE\u00a6\u001f\u000e\u00cfy\u00dd*\u009bj\u00afK\u0092\u0092\u00daT9\u00ba\u001b\u00eb`^\f\u0010\u001bK9Y[.l\u00f7\u008b$\u00cbc\u00fa\u0086\r\u0085Ok\u00a8\u00ab\u0086\u00ba\n\u00ee\u007f:\u00e8\u0088c\u008b\u001c\u00ea\u009d\u0018\u0088\u00e82\u0010\u009c$\u00fb\u0080Q\u00a5\u00ed,6\u00d0\u00e0\u0081\u008c\u00b2\u00ac}\u00b8\n\u0097S)\u00a5\u00e8\u0092\u0010*+\u00ca\u0087;QdKe\u008f\u00ab\u00e8\u00afh\u00f7D@BI\u00f3BF\u0082m\u0018\u00c0\u00b8\u0095\u00e9(\u00aa:V\u00e5\u00d1I\u008d".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 110;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "q\u009a\u00ce\u0090\u00c1K\u00be\u00be\u00bc\u001d\u0000\u00cf\u00e57\u0007\f\u00ac\u00a04vFl\u00e2\u00a8\u0098\u00cf\nC\u00d0f2\u00fa7\u00f9\u00e5\u00d8$8\u009f";
                    var4_3 = "q\u009a\u00ce\u0090\u00c1K\u00be\u00be\u00bc\u001d\u0000\u00cf\u00e57\u0007\f\u00ac\u00a04vFl\u00e2\u00a8\u0098\u00cf\nC\u00d0f2\u00fa7\u00f9\u00e5\u00d8$8\u009f".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 73;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 44;
                            break;
                        }
                        case 1: {
                            v15 = 100;
                            break;
                        }
                        case 2: {
                            v15 = 27;
                            break;
                        }
                        case 3: {
                            v15 = 103;
                            break;
                        }
                        case 4: {
                            v15 = 123;
                            break;
                        }
                        case 5: {
                            v15 = 71;
                            break;
                        }
                        default: {
                            v15 = 98;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.a = var5;
        WindowsNamedPipeAgentIpc.b = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String a(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x3474) & 0xFFFF;
        if (b[n5] == null) {
            int n6;
            char[] cArray = a[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 131;
                case 1 -> 209;
                case 2 -> 212;
                case 3 -> 45;
                case 4 -> 181;
                case 5 -> 247;
                case 6 -> 88;
                case 7 -> 221;
                case 8 -> 145;
                case 9 -> 54;
                case 10 -> 84;
                case 11 -> 137;
                case 12 -> 238;
                case 13 -> 25;
                case 14 -> 91;
                case 15 -> 157;
                case 16 -> 3;
                case 17 -> 61;
                case 18 -> 109;
                case 19 -> 246;
                case 20 -> 31;
                case 21 -> 118;
                case 22 -> 186;
                case 23 -> 211;
                case 24 -> 207;
                case 25 -> 183;
                case 26 -> 1;
                case 27 -> 112;
                case 28 -> 125;
                case 29 -> 5;
                case 30 -> 194;
                case 31 -> 144;
                case 32 -> 76;
                case 33 -> 165;
                case 34 -> 64;
                case 35 -> 232;
                case 36 -> 42;
                case 37 -> 150;
                case 38 -> 24;
                case 39 -> 237;
                case 40 -> 189;
                case 41 -> 135;
                case 42 -> 37;
                case 43 -> 180;
                case 44 -> 162;
                case 45 -> 16;
                case 46 -> 172;
                case 47 -> 214;
                case 48 -> 146;
                case 49 -> 49;
                case 50 -> 197;
                case 51 -> 120;
                case 52 -> 100;
                case 53 -> 69;
                case 54 -> 132;
                case 55 -> 75;
                case 56 -> 80;
                case 57 -> 41;
                case 58 -> 39;
                case 59 -> 56;
                case 60 -> 161;
                case 61 -> 34;
                case 62 -> 224;
                case 63 -> 164;
                case 64 -> 179;
                case 65 -> 202;
                case 66 -> 107;
                case 67 -> 220;
                case 68 -> 30;
                case 69 -> 123;
                case 70 -> 82;
                case 71 -> 169;
                case 72 -> 79;
                case 73 -> 117;
                case 74 -> 14;
                case 75 -> 71;
                case 76 -> 244;
                case 77 -> 99;
                case 78 -> 153;
                case 79 -> 106;
                case 80 -> 35;
                case 81 -> 158;
                case 82 -> 201;
                case 83 -> 93;
                case 84 -> 68;
                case 85 -> 254;
                case 86 -> 108;
                case 87 -> 160;
                case 88 -> 124;
                case 89 -> 170;
                case 90 -> 187;
                case 91 -> 11;
                case 92 -> 17;
                case 93 -> 196;
                case 94 -> 15;
                case 95 -> 206;
                case 96 -> 148;
                case 97 -> 7;
                case 98 -> 176;
                case 99 -> 67;
                case 100 -> 8;
                case 101 -> 114;
                case 102 -> 12;
                case 103 -> 19;
                case 104 -> 29;
                case 105 -> 230;
                case 106 -> 231;
                case 107 -> 50;
                case 108 -> 213;
                case 109 -> 116;
                case 110 -> 126;
                case 111 -> 149;
                case 112 -> 128;
                case 113 -> 217;
                case 114 -> 223;
                case 115 -> 40;
                case 116 -> 72;
                case 117 -> 174;
                case 118 -> 58;
                case 119 -> 104;
                case 120 -> 59;
                case 121 -> 156;
                case 122 -> 60;
                case 123 -> 73;
                case 124 -> 38;
                case 125 -> 251;
                case 126 -> 200;
                case 127 -> 87;
                case 128 -> 205;
                case 129 -> 190;
                case 130 -> 20;
                case 131 -> 141;
                case 132 -> 236;
                case 133 -> 252;
                case 134 -> 110;
                case 135 -> 53;
                case 136 -> 6;
                case 137 -> 96;
                case 138 -> 95;
                case 139 -> 94;
                case 140 -> 119;
                case 141 -> 243;
                case 142 -> 83;
                case 143 -> 33;
                case 144 -> 134;
                case 145 -> 105;
                case 146 -> 192;
                case 147 -> 101;
                case 148 -> 139;
                case 149 -> 177;
                case 150 -> 92;
                case 151 -> 151;
                case 152 -> 250;
                case 153 -> 65;
                case 154 -> 23;
                case 155 -> 70;
                case 156 -> 111;
                case 157 -> 26;
                case 158 -> 22;
                case 159 -> 225;
                case 160 -> 27;
                case 161 -> 143;
                case 162 -> 51;
                case 163 -> 89;
                case 164 -> 175;
                case 165 -> 208;
                case 166 -> 216;
                case 167 -> 152;
                case 168 -> 4;
                case 169 -> 248;
                case 170 -> 36;
                case 171 -> 98;
                case 172 -> 86;
                case 173 -> 121;
                case 174 -> 241;
                case 175 -> 63;
                case 176 -> 122;
                case 177 -> 44;
                case 178 -> 136;
                case 179 -> 138;
                case 180 -> 253;
                case 181 -> 227;
                case 182 -> 154;
                case 183 -> 133;
                case 184 -> 2;
                case 185 -> 215;
                case 186 -> 255;
                case 187 -> 129;
                case 188 -> 85;
                case 189 -> 245;
                case 190 -> 178;
                case 191 -> 234;
                case 192 -> 233;
                case 193 -> 166;
                case 194 -> 113;
                case 195 -> 28;
                case 196 -> 188;
                case 197 -> 163;
                case 198 -> 218;
                case 199 -> 185;
                case 200 -> 198;
                case 201 -> 10;
                case 202 -> 81;
                case 203 -> 103;
                case 204 -> 195;
                case 205 -> 127;
                case 206 -> 13;
                case 207 -> 193;
                case 208 -> 62;
                case 209 -> 32;
                case 210 -> 77;
                case 211 -> 130;
                case 212 -> 47;
                case 213 -> 239;
                case 214 -> 52;
                case 215 -> 191;
                case 216 -> 66;
                case 217 -> 168;
                case 218 -> 222;
                case 219 -> 219;
                case 220 -> 0;
                case 221 -> 102;
                case 222 -> 228;
                case 223 -> 203;
                case 224 -> 78;
                case 225 -> 48;
                case 226 -> 57;
                case 227 -> 242;
                case 228 -> 21;
                case 229 -> 43;
                case 230 -> 235;
                case 231 -> 18;
                case 232 -> 226;
                case 233 -> 229;
                case 234 -> 140;
                case 235 -> 184;
                case 236 -> 90;
                case 237 -> 171;
                case 238 -> 167;
                case 239 -> 115;
                case 240 -> 155;
                case 241 -> 147;
                case 242 -> 173;
                case 243 -> 182;
                case 244 -> 249;
                case 245 -> 55;
                case 246 -> 9;
                case 247 -> 199;
                case 248 -> 74;
                case 249 -> 204;
                case 250 -> 210;
                case 251 -> 159;
                case 252 -> 240;
                case 253 -> 142;
                case 254 -> 46;
                default -> 97;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.b[n5] = new String(cArray).intern();
        }
        return b[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 59965616919053L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(716428620 + 28578, 716428620 + (char)-22551, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 39611561683691L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.n();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 == 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 == 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(921684240 + 13049, 921684240 - 3499, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(921684240 + 13050, 921684240 - 18172, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(921684240 + 13051, -921684240 - -13621, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "1\u00aa{t\u0014pf0\u0010\u00a1\u00d7\u0098z\u00d2\nG&O\u00b9/ETaT\u00dd";
                    var4_3 = "1\u00aa{t\u0014pf0\u0010\u00a1\u00d7\u0098z\u00d2\nG&O\u00b9/ETaT\u00dd".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 59;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "OJ\u00afs\u00e55\u0096O\u0083\u00bf\u00b2\u0090H\u00c5\u00c2e\u0017\u0005\u00bf\u00987s\u00c8\u00f1}\u00ce\u00fdK\u00d2*h\u00c4\u00cd\u0084Pa\u0014&\u0092j\u00cfl\u0086\u0004\u00fc\u0086\u00ed\u0085\u00e05`u|\u00a6H\u00b9ut\u009a";
                        var4_3 = "OJ\u00afs\u00e55\u0096O\u0083\u00bf\u00b2\u0090H\u00c5\u00c2e\u0017\u0005\u00bf\u00987s\u00c8\u00f1}\u00ce\u00fdK\u00d2*h\u00c4\u00cd\u0084Pa\u0014&\u0092j\u00cfl\u0086\u0004\u00fc\u0086\u00ed\u0085\u00e05`u|\u00a6H\u00b9ut\u009a".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 35;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 99;
                                break;
                            }
                            case 1: {
                                v15 = 40;
                                break;
                            }
                            case 2: {
                                v15 = 99;
                                break;
                            }
                            case 3: {
                                v15 = 89;
                                break;
                            }
                            case 4: {
                                v15 = 101;
                                break;
                            }
                            case 5: {
                                v15 = 33;
                                break;
                            }
                            default: {
                                v15 = 58;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFD6E3) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 42;
                    case 1 -> 179;
                    case 2 -> 188;
                    case 3 -> 249;
                    case 4 -> 159;
                    case 5 -> 68;
                    case 6 -> 168;
                    case 7 -> 144;
                    case 8 -> 225;
                    case 9 -> 54;
                    case 10 -> 227;
                    case 11 -> 209;
                    case 12 -> 152;
                    case 13 -> 134;
                    case 14 -> 213;
                    case 15 -> 128;
                    case 16 -> 206;
                    case 17 -> 15;
                    case 18 -> 56;
                    case 19 -> 203;
                    case 20 -> 103;
                    case 21 -> 77;
                    case 22 -> 215;
                    case 23 -> 217;
                    case 24 -> 230;
                    case 25 -> 176;
                    case 26 -> 139;
                    case 27 -> 194;
                    case 28 -> 60;
                    case 29 -> 2;
                    case 30 -> 72;
                    case 31 -> 7;
                    case 32 -> 99;
                    case 33 -> 27;
                    case 34 -> 123;
                    case 35 -> 48;
                    case 36 -> 196;
                    case 37 -> 50;
                    case 38 -> 126;
                    case 39 -> 211;
                    case 40 -> 62;
                    case 41 -> 111;
                    case 42 -> 122;
                    case 43 -> 201;
                    case 44 -> 1;
                    case 45 -> 113;
                    case 46 -> 160;
                    case 47 -> 8;
                    case 48 -> 151;
                    case 49 -> 129;
                    case 50 -> 250;
                    case 51 -> 228;
                    case 52 -> 93;
                    case 53 -> 49;
                    case 54 -> 244;
                    case 55 -> 51;
                    case 56 -> 66;
                    case 57 -> 70;
                    case 58 -> 199;
                    case 59 -> 137;
                    case 60 -> 141;
                    case 61 -> 157;
                    case 62 -> 25;
                    case 63 -> 19;
                    case 64 -> 140;
                    case 65 -> 63;
                    case 66 -> 67;
                    case 67 -> 234;
                    case 68 -> 198;
                    case 69 -> 208;
                    case 70 -> 155;
                    case 71 -> 222;
                    case 72 -> 84;
                    case 73 -> 124;
                    case 74 -> 163;
                    case 75 -> 38;
                    case 76 -> 118;
                    case 77 -> 0;
                    case 78 -> 75;
                    case 79 -> 13;
                    case 80 -> 166;
                    case 81 -> 212;
                    case 82 -> 242;
                    case 83 -> 239;
                    case 84 -> 85;
                    case 85 -> 45;
                    case 86 -> 39;
                    case 87 -> 20;
                    case 88 -> 202;
                    case 89 -> 114;
                    case 90 -> 175;
                    case 91 -> 224;
                    case 92 -> 200;
                    case 93 -> 183;
                    case 94 -> 6;
                    case 95 -> 33;
                    case 96 -> 14;
                    case 97 -> 109;
                    case 98 -> 205;
                    case 99 -> 79;
                    case 100 -> 73;
                    case 101 -> 24;
                    case 102 -> 69;
                    case 103 -> 235;
                    case 104 -> 65;
                    case 105 -> 31;
                    case 106 -> 177;
                    case 107 -> 214;
                    case 108 -> 59;
                    case 109 -> 246;
                    case 110 -> 120;
                    case 111 -> 143;
                    case 112 -> 101;
                    case 113 -> 130;
                    case 114 -> 81;
                    case 115 -> 35;
                    case 116 -> 186;
                    case 117 -> 100;
                    case 118 -> 233;
                    case 119 -> 76;
                    case 120 -> 44;
                    case 121 -> 180;
                    case 122 -> 89;
                    case 123 -> 252;
                    case 124 -> 9;
                    case 125 -> 189;
                    case 126 -> 218;
                    case 127 -> 37;
                    case 128 -> 192;
                    case 129 -> 21;
                    case 130 -> 156;
                    case 131 -> 110;
                    case 132 -> 17;
                    case 133 -> 162;
                    case 134 -> 142;
                    case 135 -> 34;
                    case 136 -> 10;
                    case 137 -> 116;
                    case 138 -> 161;
                    case 139 -> 223;
                    case 140 -> 107;
                    case 141 -> 248;
                    case 142 -> 187;
                    case 143 -> 97;
                    case 144 -> 181;
                    case 145 -> 245;
                    case 146 -> 121;
                    case 147 -> 237;
                    case 148 -> 40;
                    case 149 -> 229;
                    case 150 -> 150;
                    case 151 -> 243;
                    case 152 -> 158;
                    case 153 -> 112;
                    case 154 -> 167;
                    case 155 -> 78;
                    case 156 -> 23;
                    case 157 -> 132;
                    case 158 -> 52;
                    case 159 -> 251;
                    case 160 -> 41;
                    case 161 -> 32;
                    case 162 -> 204;
                    case 163 -> 86;
                    case 164 -> 207;
                    case 165 -> 184;
                    case 166 -> 220;
                    case 167 -> 136;
                    case 168 -> 29;
                    case 169 -> 193;
                    case 170 -> 104;
                    case 171 -> 91;
                    case 172 -> 26;
                    case 173 -> 115;
                    case 174 -> 164;
                    case 175 -> 190;
                    case 176 -> 221;
                    case 177 -> 165;
                    case 178 -> 146;
                    case 179 -> 185;
                    case 180 -> 58;
                    case 181 -> 22;
                    case 182 -> 145;
                    case 183 -> 232;
                    case 184 -> 172;
                    case 185 -> 106;
                    case 186 -> 12;
                    case 187 -> 43;
                    case 188 -> 3;
                    case 189 -> 90;
                    case 190 -> 57;
                    case 191 -> 154;
                    case 192 -> 138;
                    case 193 -> 92;
                    case 194 -> 108;
                    case 195 -> 71;
                    case 196 -> 135;
                    case 197 -> 80;
                    case 198 -> 64;
                    case 199 -> 171;
                    case 200 -> 82;
                    case 201 -> 170;
                    case 202 -> 5;
                    case 203 -> 148;
                    case 204 -> 125;
                    case 205 -> 105;
                    case 206 -> 98;
                    case 207 -> 253;
                    case 208 -> 61;
                    case 209 -> 254;
                    case 210 -> 36;
                    case 211 -> 46;
                    case 212 -> 238;
                    case 213 -> 182;
                    case 214 -> 226;
                    case 215 -> 11;
                    case 216 -> 236;
                    case 217 -> 127;
                    case 218 -> 47;
                    case 219 -> 178;
                    case 220 -> 153;
                    case 221 -> 174;
                    case 222 -> 241;
                    case 223 -> 87;
                    case 224 -> 94;
                    case 225 -> 219;
                    case 226 -> 133;
                    case 227 -> 210;
                    case 228 -> 147;
                    case 229 -> 149;
                    case 230 -> 102;
                    case 231 -> 119;
                    case 232 -> 95;
                    case 233 -> 74;
                    case 234 -> 18;
                    case 235 -> 169;
                    case 236 -> 83;
                    case 237 -> 53;
                    case 238 -> 191;
                    case 239 -> 16;
                    case 240 -> 255;
                    case 241 -> 131;
                    case 242 -> 173;
                    case 243 -> 247;
                    case 244 -> 117;
                    case 245 -> 195;
                    case 246 -> 4;
                    case 247 -> 30;
                    case 248 -> 216;
                    case 249 -> 240;
                    case 250 -> 88;
                    case 251 -> 96;
                    case 252 -> 55;
                    case 253 -> 197;
                    case 254 -> 28;
                    default -> 231;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 101436073536992L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u0003k\ba\u0017\u0010\u0017Z\t\u0004a\u001bkZR\nF'";
                    var5_4 = "\u0003k\ba\u0017\u0010\u0017Z\t\u0004a\u001bkZR\nF'".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 70;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 46;
                                    break;
                                }
                                case 1: {
                                    v11 = 72;
                                    break;
                                }
                                case 2: {
                                    v11 = 60;
                                    break;
                                }
                                case 3: {
                                    v11 = 73;
                                    break;
                                }
                                case 4: {
                                    v11 = 52;
                                    break;
                                }
                                case 5: {
                                    v11 = 58;
                                    break;
                                }
                                default: {
                                    v11 = 98;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 20011917804979L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "l}\u001bjVS[\u0004jc\u0017p\nf|\u001cpZQCL}\u0015\tf|\u001cpZQC@w\raz\u0001}P\\Y@p\u0006wQU";
                    var5_4 = "l}\u001bjVS[\u0004jc\u0017p\nf|\u001cpZQCL}\u0015\tf|\u001cpZQC@w\raz\u0001}P\\Y@p\u0006wQU".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 74;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "<%G7\f\u0006\n\u0006<%G7\u0000\f";
                        var5_4 = "<%G7\f\u0006\n\u0006<%G7\u0000\f".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 16;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 111;
                                break;
                            }
                            case 1: {
                                v15 = 89;
                                break;
                            }
                            case 2: {
                                v15 = 56;
                                break;
                            }
                            case 3: {
                                v15 = 84;
                                break;
                            }
                            case 4: {
                                v15 = 117;
                                break;
                            }
                            case 5: {
                                v15 = 120;
                                break;
                            }
                            default: {
                                v15 = 125;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 115595483817559L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-733992000 + -27335, -733992000 + -((char)-29584), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 95995907551458L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u0013\u00da(\u00c3\u0006\u0003P\u0014\u00f4\u0005\u00c1\u000bT=j\ru\u00e3\u00f4j\u008bQ\u00e65\u00a1nl\u0019\u0016\u0010\u001b\u00bd\u00feJ\u00f5\u00c0\u0002:\u00f4\u000b%\u00f8\u00d9w\u00a0\f\u0005VH\u00a6U43\u00eep\u00a0%\u00ebi\u00f1\u001b\u00f7\u00d2\u00ce\u00eabd\u00fbqK\u00cc\u008a\u00be\u001e\u001d\u00c0B\u0087\u00a6\u000e$\u00c8\u00c9\u0012\bc\u00de\u00ab\u00cf\u00f8\u0018\u00e5\u00ff\u0084J\u0082\u00f6w\u0019\u0000\u00d6\u00f4\u00d9\u001a";
                    var4_3 = "\u0013\u00da(\u00c3\u0006\u0003P\u0014\u00f4\u0005\u00c1\u000bT=j\ru\u00e3\u00f4j\u008bQ\u00e65\u00a1nl\u0019\u0016\u0010\u001b\u00bd\u00feJ\u00f5\u00c0\u0002:\u00f4\u000b%\u00f8\u00d9w\u00a0\f\u0005VH\u00a6U43\u00eep\u00a0%\u00ebi\u00f1\u001b\u00f7\u00d2\u00ce\u00eabd\u00fbqK\u00cc\u008a\u00be\u001e\u001d\u00c0B\u0087\u00a6\u000e$\u00c8\u00c9\u0012\bc\u00de\u00ab\u00cf\u00f8\u0018\u00e5\u00ff\u0084J\u0082\u00f6w\u0019\u0000\u00d6\u00f4\u00d9\u001a".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 76;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "]\u0006V]\u0080B\u00cc\nMmrTS\u0082\u0091\u00d2L\u0019b)\u001bEB\u001ad\u001e3\u00b4&\u0085B\u00d8\u00b3J%5\u0015\u00e1lu\u00aer\u00b0\u00f5@-l!\u00b3u'x\u008c\u00d0\u00ce\u00ba#9L\u009a+\u0001\u001ce.\u00ca\u0092U\u00cf\u00f2\u0081\u00e6\u0099<?\u001a\u00bf']\u0080\n\r\u00e7\u00df\u00c2\u0082%n\u008fs\u009d\u001f\u0095";
                        var4_3 = "]\u0006V]\u0080B\u00cc\nMmrTS\u0082\u0091\u00d2L\u0019b)\u001bEB\u001ad\u001e3\u00b4&\u0085B\u00d8\u00b3J%5\u0015\u00e1lu\u00aer\u00b0\u00f5@-l!\u00b3u'x\u008c\u00d0\u00ce\u00ba#9L\u009a+\u0001\u001ce.\u00ca\u0092U\u00cf\u00f2\u0081\u00e6\u0099<?\u001a\u00bf']\u0080\n\r\u00e7\u00df\u00c2\u0082%n\u008fs\u009d\u001f\u0095".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 5;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 52;
                                break;
                            }
                            case 1: {
                                v15 = 77;
                                break;
                            }
                            case 2: {
                                v15 = 33;
                                break;
                            }
                            case 3: {
                                v15 = 17;
                                break;
                            }
                            case 4: {
                                v15 = 95;
                                break;
                            }
                            case 5: {
                                v15 = 125;
                                break;
                            }
                            default: {
                                v15 = 69;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFE6AE) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 7;
                    case 1 -> 235;
                    case 2 -> 165;
                    case 3 -> 118;
                    case 4 -> 106;
                    case 5 -> 215;
                    case 6 -> 101;
                    case 7 -> 136;
                    case 8 -> 122;
                    case 9 -> 247;
                    case 10 -> 61;
                    case 11 -> 183;
                    case 12 -> 36;
                    case 13 -> 57;
                    case 14 -> 37;
                    case 15 -> 194;
                    case 16 -> 160;
                    case 17 -> 185;
                    case 18 -> 108;
                    case 19 -> 130;
                    case 20 -> 87;
                    case 21 -> 181;
                    case 22 -> 184;
                    case 23 -> 15;
                    case 24 -> 31;
                    case 25 -> 126;
                    case 26 -> 65;
                    case 27 -> 245;
                    case 28 -> 83;
                    case 29 -> 214;
                    case 30 -> 39;
                    case 31 -> 93;
                    case 32 -> 45;
                    case 33 -> 33;
                    case 34 -> 199;
                    case 35 -> 182;
                    case 36 -> 38;
                    case 37 -> 60;
                    case 38 -> 207;
                    case 39 -> 162;
                    case 40 -> 216;
                    case 41 -> 8;
                    case 42 -> 191;
                    case 43 -> 72;
                    case 44 -> 211;
                    case 45 -> 230;
                    case 46 -> 190;
                    case 47 -> 177;
                    case 48 -> 246;
                    case 49 -> 64;
                    case 50 -> 234;
                    case 51 -> 217;
                    case 52 -> 137;
                    case 53 -> 5;
                    case 54 -> 44;
                    case 55 -> 228;
                    case 56 -> 195;
                    case 57 -> 134;
                    case 58 -> 212;
                    case 59 -> 124;
                    case 60 -> 251;
                    case 61 -> 155;
                    case 62 -> 223;
                    case 63 -> 94;
                    case 64 -> 43;
                    case 65 -> 193;
                    case 66 -> 85;
                    case 67 -> 17;
                    case 68 -> 53;
                    case 69 -> 13;
                    case 70 -> 98;
                    case 71 -> 146;
                    case 72 -> 221;
                    case 73 -> 58;
                    case 74 -> 170;
                    case 75 -> 227;
                    case 76 -> 142;
                    case 77 -> 254;
                    case 78 -> 20;
                    case 79 -> 140;
                    case 80 -> 81;
                    case 81 -> 147;
                    case 82 -> 133;
                    case 83 -> 90;
                    case 84 -> 138;
                    case 85 -> 178;
                    case 86 -> 47;
                    case 87 -> 1;
                    case 88 -> 116;
                    case 89 -> 145;
                    case 90 -> 224;
                    case 91 -> 25;
                    case 92 -> 201;
                    case 93 -> 41;
                    case 94 -> 173;
                    case 95 -> 74;
                    case 96 -> 69;
                    case 97 -> 198;
                    case 98 -> 11;
                    case 99 -> 3;
                    case 100 -> 213;
                    case 101 -> 28;
                    case 102 -> 168;
                    case 103 -> 143;
                    case 104 -> 237;
                    case 105 -> 84;
                    case 106 -> 226;
                    case 107 -> 253;
                    case 108 -> 26;
                    case 109 -> 105;
                    case 110 -> 180;
                    case 111 -> 54;
                    case 112 -> 129;
                    case 113 -> 67;
                    case 114 -> 156;
                    case 115 -> 29;
                    case 116 -> 96;
                    case 117 -> 19;
                    case 118 -> 103;
                    case 119 -> 188;
                    case 120 -> 75;
                    case 121 -> 242;
                    case 122 -> 0;
                    case 123 -> 49;
                    case 124 -> 189;
                    case 125 -> 149;
                    case 126 -> 244;
                    case 127 -> 232;
                    case 128 -> 141;
                    case 129 -> 219;
                    case 130 -> 10;
                    case 131 -> 62;
                    case 132 -> 70;
                    case 133 -> 150;
                    case 134 -> 209;
                    case 135 -> 176;
                    case 136 -> 119;
                    case 137 -> 144;
                    case 138 -> 175;
                    case 139 -> 30;
                    case 140 -> 111;
                    case 141 -> 99;
                    case 142 -> 196;
                    case 143 -> 172;
                    case 144 -> 32;
                    case 145 -> 152;
                    case 146 -> 88;
                    case 147 -> 59;
                    case 148 -> 225;
                    case 149 -> 115;
                    case 150 -> 236;
                    case 151 -> 197;
                    case 152 -> 77;
                    case 153 -> 148;
                    case 154 -> 231;
                    case 155 -> 210;
                    case 156 -> 22;
                    case 157 -> 139;
                    case 158 -> 73;
                    case 159 -> 2;
                    case 160 -> 218;
                    case 161 -> 112;
                    case 162 -> 206;
                    case 163 -> 27;
                    case 164 -> 248;
                    case 165 -> 68;
                    case 166 -> 135;
                    case 167 -> 9;
                    case 168 -> 128;
                    case 169 -> 250;
                    case 170 -> 50;
                    case 171 -> 158;
                    case 172 -> 166;
                    case 173 -> 48;
                    case 174 -> 16;
                    case 175 -> 229;
                    case 176 -> 12;
                    case 177 -> 91;
                    case 178 -> 35;
                    case 179 -> 89;
                    case 180 -> 46;
                    case 181 -> 243;
                    case 182 -> 186;
                    case 183 -> 66;
                    case 184 -> 163;
                    case 185 -> 56;
                    case 186 -> 86;
                    case 187 -> 113;
                    case 188 -> 220;
                    case 189 -> 55;
                    case 190 -> 241;
                    case 191 -> 151;
                    case 192 -> 187;
                    case 193 -> 238;
                    case 194 -> 104;
                    case 195 -> 153;
                    case 196 -> 14;
                    case 197 -> 24;
                    case 198 -> 174;
                    case 199 -> 167;
                    case 200 -> 179;
                    case 201 -> 4;
                    case 202 -> 202;
                    case 203 -> 123;
                    case 204 -> 203;
                    case 205 -> 21;
                    case 206 -> 117;
                    case 207 -> 120;
                    case 208 -> 80;
                    case 209 -> 18;
                    case 210 -> 76;
                    case 211 -> 127;
                    case 212 -> 125;
                    case 213 -> 169;
                    case 214 -> 71;
                    case 215 -> 171;
                    case 216 -> 52;
                    case 217 -> 200;
                    case 218 -> 107;
                    case 219 -> 252;
                    case 220 -> 255;
                    case 221 -> 204;
                    case 222 -> 208;
                    case 223 -> 34;
                    case 224 -> 42;
                    case 225 -> 159;
                    case 226 -> 131;
                    case 227 -> 157;
                    case 228 -> 205;
                    case 229 -> 233;
                    case 230 -> 121;
                    case 231 -> 82;
                    case 232 -> 222;
                    case 233 -> 51;
                    case 234 -> 97;
                    case 235 -> 109;
                    case 236 -> 154;
                    case 237 -> 63;
                    case 238 -> 240;
                    case 239 -> 161;
                    case 240 -> 6;
                    case 241 -> 249;
                    case 242 -> 40;
                    case 243 -> 100;
                    case 244 -> 23;
                    case 245 -> 110;
                    case 246 -> 78;
                    case 247 -> 95;
                    case 248 -> 92;
                    case 249 -> 164;
                    case 250 -> 102;
                    case 251 -> 79;
                    case 252 -> 239;
                    case 253 -> 132;
                    case 254 -> 114;
                    default -> 192;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 46597541244237L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1440983580 + (char)-4768, -1441114650 - -((char)-2381), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 131456063779642L;
                    int n3 = SshAgentIpcService.y();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-262140 - -2310, -262140 - -1192, (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 != 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 61624863113039L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00ba\u00ac\u009a7\u0090\u0003\u008fHj";
                var4_3 = "\u00ba\u00ac\u009a7\u0090\u0003\u008fHj".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 90;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 63;
                                break;
                            }
                            case 1: {
                                v11 = 90;
                                break;
                            }
                            case 2: {
                                v11 = 19;
                                break;
                            }
                            case 3: {
                                v11 = 29;
                                break;
                            }
                            case 4: {
                                v11 = 13;
                                break;
                            }
                            case 5: {
                                v11 = 61;
                                break;
                            }
                            default: {
                                v11 = 23;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x3A31) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 130;
                    case 1 -> 193;
                    case 2 -> 51;
                    case 3 -> 203;
                    case 4 -> 209;
                    case 5 -> 39;
                    case 6 -> 116;
                    case 7 -> 165;
                    case 8 -> 152;
                    case 9 -> 123;
                    case 10 -> 237;
                    case 11 -> 250;
                    case 12 -> 236;
                    case 13 -> 100;
                    case 14 -> 208;
                    case 15 -> 78;
                    case 16 -> 60;
                    case 17 -> 48;
                    case 18 -> 249;
                    case 19 -> 27;
                    case 20 -> 139;
                    case 21 -> 105;
                    case 22 -> 141;
                    case 23 -> 88;
                    case 24 -> 106;
                    case 25 -> 42;
                    case 26 -> 224;
                    case 27 -> 61;
                    case 28 -> 120;
                    case 29 -> 50;
                    case 30 -> 21;
                    case 31 -> 24;
                    case 32 -> 198;
                    case 33 -> 160;
                    case 34 -> 114;
                    case 35 -> 6;
                    case 36 -> 134;
                    case 37 -> 235;
                    case 38 -> 183;
                    case 39 -> 142;
                    case 40 -> 94;
                    case 41 -> 227;
                    case 42 -> 127;
                    case 43 -> 11;
                    case 44 -> 58;
                    case 45 -> 247;
                    case 46 -> 34;
                    case 47 -> 248;
                    case 48 -> 136;
                    case 49 -> 9;
                    case 50 -> 169;
                    case 51 -> 101;
                    case 52 -> 153;
                    case 53 -> 77;
                    case 54 -> 181;
                    case 55 -> 107;
                    case 56 -> 87;
                    case 57 -> 64;
                    case 58 -> 215;
                    case 59 -> 20;
                    case 60 -> 3;
                    case 61 -> 254;
                    case 62 -> 218;
                    case 63 -> 43;
                    case 64 -> 156;
                    case 65 -> 18;
                    case 66 -> 90;
                    case 67 -> 68;
                    case 68 -> 161;
                    case 69 -> 188;
                    case 70 -> 214;
                    case 71 -> 59;
                    case 72 -> 194;
                    case 73 -> 71;
                    case 74 -> 133;
                    case 75 -> 19;
                    case 76 -> 243;
                    case 77 -> 93;
                    case 78 -> 158;
                    case 79 -> 14;
                    case 80 -> 239;
                    case 81 -> 190;
                    case 82 -> 119;
                    case 83 -> 137;
                    case 84 -> 157;
                    case 85 -> 91;
                    case 86 -> 166;
                    case 87 -> 175;
                    case 88 -> 132;
                    case 89 -> 118;
                    case 90 -> 98;
                    case 91 -> 145;
                    case 92 -> 173;
                    case 93 -> 112;
                    case 94 -> 56;
                    case 95 -> 148;
                    case 96 -> 25;
                    case 97 -> 110;
                    case 98 -> 35;
                    case 99 -> 191;
                    case 100 -> 252;
                    case 101 -> 206;
                    case 102 -> 97;
                    case 103 -> 30;
                    case 104 -> 74;
                    case 105 -> 176;
                    case 106 -> 70;
                    case 107 -> 182;
                    case 108 -> 131;
                    case 109 -> 28;
                    case 110 -> 241;
                    case 111 -> 213;
                    case 112 -> 33;
                    case 113 -> 46;
                    case 114 -> 86;
                    case 115 -> 229;
                    case 116 -> 81;
                    case 117 -> 163;
                    case 118 -> 233;
                    case 119 -> 102;
                    case 120 -> 52;
                    case 121 -> 23;
                    case 122 -> 167;
                    case 123 -> 111;
                    case 124 -> 75;
                    case 125 -> 199;
                    case 126 -> 179;
                    case 127 -> 8;
                    case 128 -> 129;
                    case 129 -> 44;
                    case 130 -> 234;
                    case 131 -> 226;
                    case 132 -> 222;
                    case 133 -> 205;
                    case 134 -> 201;
                    case 135 -> 162;
                    case 136 -> 121;
                    case 137 -> 31;
                    case 138 -> 92;
                    case 139 -> 204;
                    case 140 -> 195;
                    case 141 -> 63;
                    case 142 -> 1;
                    case 143 -> 187;
                    case 144 -> 82;
                    case 145 -> 69;
                    case 146 -> 95;
                    case 147 -> 103;
                    case 148 -> 7;
                    case 149 -> 211;
                    case 150 -> 55;
                    case 151 -> 245;
                    case 152 -> 242;
                    case 153 -> 4;
                    case 154 -> 225;
                    case 155 -> 180;
                    case 156 -> 232;
                    case 157 -> 13;
                    case 158 -> 125;
                    case 159 -> 219;
                    case 160 -> 244;
                    case 161 -> 85;
                    case 162 -> 109;
                    case 163 -> 230;
                    case 164 -> 62;
                    case 165 -> 124;
                    case 166 -> 122;
                    case 167 -> 45;
                    case 168 -> 49;
                    case 169 -> 143;
                    case 170 -> 67;
                    case 171 -> 202;
                    case 172 -> 73;
                    case 173 -> 172;
                    case 174 -> 231;
                    case 175 -> 138;
                    case 176 -> 154;
                    case 177 -> 104;
                    case 178 -> 53;
                    case 179 -> 126;
                    case 180 -> 108;
                    case 181 -> 47;
                    case 182 -> 246;
                    case 183 -> 149;
                    case 184 -> 80;
                    case 185 -> 212;
                    case 186 -> 38;
                    case 187 -> 171;
                    case 188 -> 26;
                    case 189 -> 16;
                    case 190 -> 115;
                    case 191 -> 72;
                    case 192 -> 128;
                    case 193 -> 65;
                    case 194 -> 170;
                    case 195 -> 255;
                    case 196 -> 159;
                    case 197 -> 140;
                    case 198 -> 178;
                    case 199 -> 185;
                    case 200 -> 223;
                    case 201 -> 76;
                    case 202 -> 192;
                    case 203 -> 96;
                    case 204 -> 32;
                    case 205 -> 217;
                    case 206 -> 117;
                    case 207 -> 0;
                    case 208 -> 135;
                    case 209 -> 184;
                    case 210 -> 197;
                    case 211 -> 36;
                    case 212 -> 186;
                    case 213 -> 37;
                    case 214 -> 240;
                    case 215 -> 150;
                    case 216 -> 40;
                    case 217 -> 207;
                    case 218 -> 146;
                    case 219 -> 99;
                    case 220 -> 84;
                    case 221 -> 83;
                    case 222 -> 79;
                    case 223 -> 22;
                    case 224 -> 10;
                    case 225 -> 151;
                    case 226 -> 164;
                    case 227 -> 144;
                    case 228 -> 17;
                    case 229 -> 177;
                    case 230 -> 251;
                    case 231 -> 54;
                    case 232 -> 57;
                    case 233 -> 5;
                    case 234 -> 253;
                    case 235 -> 238;
                    case 236 -> 210;
                    case 237 -> 220;
                    case 238 -> 216;
                    case 239 -> 221;
                    case 240 -> 41;
                    case 241 -> 89;
                    case 242 -> 29;
                    case 243 -> 200;
                    case 244 -> 228;
                    case 245 -> 174;
                    case 246 -> 196;
                    case 247 -> 189;
                    case 248 -> 15;
                    case 249 -> 168;
                    case 250 -> 113;
                    case 251 -> 2;
                    case 252 -> 12;
                    case 253 -> 66;
                    case 254 -> 147;
                    default -> 155;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

