/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action.executor;

import de.rub.nds.tlsattacker.core.protocol.message.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class MessageActionResult {
    private final List<AbstractRecord> recordList;
    private final List<ProtocolMessage> messageList;
    private final List<DtlsHandshakeMessageFragment> messageFragmentList;

    public MessageActionResult(List<AbstractRecord> recordList, List<ProtocolMessage> messageList, List<DtlsHandshakeMessageFragment> messageFragmentList) {
        this.recordList = recordList;
        this.messageList = messageList;
        this.messageFragmentList = messageFragmentList;
    }

    public MessageActionResult() {
        this(new LinkedList<AbstractRecord>(), new LinkedList<ProtocolMessage>(), new LinkedList<DtlsHandshakeMessageFragment>());
    }

    public List<AbstractRecord> getRecordList() {
        return this.recordList;
    }

    public List<ProtocolMessage> getMessageList() {
        return this.messageList;
    }

    public List<DtlsHandshakeMessageFragment> getMessageFragmentList() {
        return this.messageFragmentList;
    }

    public MessageActionResult merge(MessageActionResult ... other) {
        LinkedList<MessageActionResult> results = new LinkedList<MessageActionResult>(Arrays.asList(other));
        results.add(0, this);
        LinkedList<AbstractRecord> recordList = new LinkedList<AbstractRecord>();
        LinkedList<DtlsHandshakeMessageFragment> messageFragmentList = null;
        LinkedList<ProtocolMessage> messageList = new LinkedList<ProtocolMessage>();
        for (MessageActionResult result : results) {
            recordList.addAll(result.getRecordList());
            if (result.getMessageFragmentList() != null) {
                if (messageFragmentList == null) {
                    messageFragmentList = new LinkedList<DtlsHandshakeMessageFragment>();
                }
                messageFragmentList.addAll(result.getMessageFragmentList());
            }
            messageList.addAll(result.getMessageList());
        }
        return new MessageActionResult(recordList, messageList, messageFragmentList);
    }
}

