/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.config.Keys;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class EsealProtocolDecoder
extends BaseProtocolDecoder {
    private String config;
    private static final Pattern PATTERN = new PatternBuilder().text("##S,").expression("[^,]+,").number("(d+),").number("d+,").expression("[^,]+,").expression("([^,]+),").number("(d+),").number("(dddd)-(dd)-(dd),").number("(dd):(dd):(dd),").number("d+,").expression("([AV]),").number("(d+.d+)([NS]) ").number("(d+.d+)([EW]),").number("(d+),").number("(d+),").expression("([^,]+),").number("(d+.d+),").expression("([^,]+),").number("(d+.d+),").number("(-?d+),").text("E##").compile();

    public EsealProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected void init() {
        this.config = this.getConfig().getString(Keys.PROTOCOL_CONFIG.withPrefix(this.getProtocolName()));
    }

    private void sendResponse(Channel channel, String prefix, String type, String payload) {
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(prefix + type + "," + payload + ",E##\r\n", channel.remoteAddress()));
        }
    }

    private String decodeAlarm(String type) {
        return switch (type) {
            case "Event-Door" -> "door";
            case "Event-Shock" -> "vibration";
            case "Event-Drop" -> "fallDown";
            case "Event-Lock" -> "lock";
            case "Event-RC-Unlock" -> "unlock";
            default -> null;
        };
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        String type = parser.next();
        String prefix = sentence.substring(0, sentence.indexOf(type));
        int index = parser.nextInt();
        position.set("index", index);
        position.addAlarm(this.decodeAlarm(type));
        switch (type) {
            case "Startup": {
                this.sendResponse(channel, prefix, type + " ACK", index + "," + this.config);
                break;
            }
            case "Normal": 
            case "Button-Normal": 
            case "Termination": 
            case "Event-Door": 
            case "Event-Shock": 
            case "Event-Drop": 
            case "Event-Lock": 
            case "Event-RC-Unlock": {
                this.sendResponse(channel, prefix, type + " ACK", String.valueOf(index));
                break;
            }
        }
        position.setTime(parser.nextDateTime());
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setCourse(parser.nextInt().intValue());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        switch (parser.next()) {
            case "Open": {
                position.set("door", true);
                break;
            }
            case "Close": {
                position.set("door", false);
            }
        }
        position.set("acceleration", parser.nextDouble());
        position.set("nfc", parser.next());
        position.set("battery", parser.nextDouble());
        position.set("rssi", parser.nextInt());
        return position;
    }
}

