/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ProfileGraphPanel;
import ca.sqlpower.architect.swingui.table.ProfileTableModel;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLTable;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.Logger;

public class ProfilePanel
extends JPanel {
    static Logger logger = Logger.getLogger(ProfilePanel.class);
    private final ProfileTableModel profileTableModel;
    private JComboBox tableSelector;
    private JList columnSelector;
    private JPanel controlsArea;
    private ProfileGraphPanel displayPanel;
    private final ProfileManager pm;
    private final JProgressBar progressBar = new JProgressBar();
    private JTabbedPane tabPane;
    private ProfileTableModel tableModel;
    private TableModelListener listener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            ProfilePanel.this.resetTableSelectorModel();
        }
    };

    public ProfilePanel(ProfileTableModel profileTableModel, ProfileManager pm) {
        this.profileTableModel = profileTableModel;
        this.pm = pm;
        this.displayPanel = new ProfileGraphPanel(this, 0);
        this.setup();
    }

    private void setup() {
        this.progressBar.setVisible(false);
        FormLayout controlsLayout = new FormLayout("4dlu,fill:min(150dlu;default):grow, 4dlu", "default, 4dlu, fill:min(200dlu;default):grow,4dlu,default");
        CellConstraints cc = new CellConstraints();
        this.setLayout(new BorderLayout());
        this.controlsArea = logger.isDebugEnabled() ? new FormDebugPanel(controlsLayout) : new JPanel((LayoutManager)controlsLayout);
        this.controlsArea.setLayout(new BoxLayout(this.controlsArea, 1));
        this.tableSelector = new JComboBox();
        this.tableSelector.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                TableProfileResult tpr = (TableProfileResult)value;
                StringBuffer buf = new StringBuffer();
                if (tpr != null) {
                    buf.append(((SQLTable)tpr.getProfiledObject()).getName());
                    buf.append(" (");
                    DateFormat df = DateFormat.getDateTimeInstance();
                    buf.append(df.format(new Date(tpr.getCreateStartTime())));
                    buf.append(")");
                } else {
                    buf.append("All");
                }
                return super.getListCellRendererComponent((JList<?>)list, buf.toString(), index, isSelected, cellHasFocus);
            }
        });
        this.tableSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableProfileResult tpr = (TableProfileResult)ProfilePanel.this.tableSelector.getSelectedItem();
                try {
                    ArrayList<Object> columns = new ArrayList<Object>();
                    if (tpr == null) {
                        for (TableProfileResult tableProfile : ProfilePanel.this.tableModel.getTableResultsToScan()) {
                            for (ColumnProfileResult cpr : tableProfile.getColumnProfileResults()) {
                                columns.add(cpr.getProfiledObject());
                            }
                        }
                    } else {
                        for (ColumnProfileResult cpr : tpr.getColumnProfileResults()) {
                            SQLColumn column = (SQLColumn)cpr.getProfiledObject();
                            columns.add(column);
                        }
                    }
                    SQLColumn selectedColumn = null;
                    if (ProfilePanel.this.columnSelector.getSelectedIndex() >= 0) {
                        selectedColumn = (SQLColumn)ProfilePanel.this.columnSelector.getSelectedValues()[0];
                    }
                    ProfilePanel.this.columnSelector.setModel(new DefaultComboBoxModel<Object>(columns.toArray()));
                    if (columns.size() > 0) {
                        if (selectedColumn != null && columns.contains(selectedColumn)) {
                            ProfilePanel.this.columnSelector.setSelectedValue(selectedColumn, true);
                        } else {
                            ProfilePanel.this.columnSelector.setSelectedIndex(0);
                        }
                    }
                }
                catch (Exception ex) {
                    ASUtils.showExceptionDialogNoReport(ProfilePanel.this, "Error in profile", ex);
                }
            }
        });
        this.columnSelector = new JList();
        this.columnSelector.setSelectionMode(0);
        this.columnSelector.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SQLColumn col = (SQLColumn)ProfilePanel.this.columnSelector.getSelectedValue();
                if (col == null) {
                    logger.debug((Object)"Null selection in columnSelector.ListSelectionListener");
                    return;
                }
                for (ColumnProfileResult pr : ProfilePanel.this.tableModel.getResultList()) {
                    SQLColumn column = (SQLColumn)pr.getProfiledObject();
                    if (col != column) continue;
                    ProfilePanel.this.displayPanel.displayProfile(pr);
                    break;
                }
            }
        });
        PanelBuilder pb = new PanelBuilder(controlsLayout, this.controlsArea);
        pb.setDefaultDialogBorder();
        pb.add((Component)this.tableSelector, cc.xy(2, 1));
        pb.add((Component)new JScrollPane(this.columnSelector), cc.xy(2, 3));
        pb.add((Component)this.progressBar, cc.xy(2, 5));
        this.add((Component)this.controlsArea, "West");
        this.add((Component)this.displayPanel.getDisplayArea(), "Center");
    }

    public JList getColumnSelector() {
        return this.columnSelector;
    }

    public void setColumnSelector(JList columnSelector) {
        this.columnSelector = columnSelector;
    }

    public JComboBox getTableSelector() {
        return this.tableSelector;
    }

    public void setTableSelector(JComboBox tableSelector) {
        this.tableSelector = tableSelector;
    }

    public JTabbedPane getTabPane() {
        return this.tabPane;
    }

    public void setTabPane(JTabbedPane tabPane) {
        this.tabPane = tabPane;
    }

    public ProfileTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(ProfileTableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.listener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.listener);
        }
        this.resetTableSelectorModel();
    }

    public void resetTableSelectorModel() {
        ArrayList<TableProfileResult> tableResults = new ArrayList<TableProfileResult>();
        TableProfileResult selectedResult = null;
        if (this.tableSelector.getSelectedIndex() >= 0) {
            selectedResult = (TableProfileResult)this.tableSelector.getSelectedObjects()[0];
        }
        tableResults.add(null);
        for (TableProfileResult pr : this.profileTableModel.getTableResultsToScan()) {
            tableResults.add(pr);
        }
        this.tableSelector.setModel(new DefaultComboBoxModel<Object>(tableResults.toArray()));
        if (this.tableSelector.getModel().getSize() > 0) {
            if (selectedResult != null && tableResults.contains(selectedResult)) {
                this.tableSelector.setSelectedItem(selectedResult);
            } else {
                this.tableSelector.setSelectedIndex(0);
            }
        }
    }

    public ProfileManager getProfileManager() {
        return this.pm;
    }

    public void close() {
        this.displayPanel.close();
    }
}

