/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.constant;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.constant.ConstantData;
import org.pentaho.di.trans.steps.constant.ConstantMeta;
import org.pentaho.di.trans.steps.constant.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constant
extends BaseStep
implements StepInterface {
    private ConstantMeta meta = (ConstantMeta)this.getStepMeta().getStepMetaInterface();
    private ConstantData data;

    public Constant(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (ConstantData)stepDataInterface;
    }

    public static final RowMetaAndData buildRow(ConstantMeta meta, ConstantData data, List<CheckResultInterface> remarks) {
        RowMeta rowMeta = new RowMeta();
        Object[] rowData = new Object[meta.getFieldName().length];
        for (int i = 0; i < meta.getFieldName().length; ++i) {
            String message;
            int valtype = ValueMeta.getType((String)meta.getFieldType()[i]);
            if (meta.getFieldName()[i] == null) continue;
            ValueMeta value = new ValueMeta(meta.getFieldName()[i], valtype);
            value.setLength(meta.getFieldLength()[i]);
            value.setPrecision(meta.getFieldPrecision()[i]);
            String stringValue = meta.getValue()[i];
            if (stringValue == null || stringValue.length() == 0) {
                rowData[i] = null;
                if (value.getType() == 0) {
                    message = Messages.getString("Constant.CheckResult.SpecifyTypeError", value.getName(), stringValue);
                    remarks.add((CheckResultInterface)new CheckResult(4, message, null));
                }
            } else {
                switch (value.getType()) {
                    case 1: {
                        String message2;
                        try {
                            if (meta.getFieldFormat()[i] != null || meta.getDecimal()[i] != null || meta.getGroup()[i] != null || meta.getCurrency()[i] != null) {
                                if (meta.getFieldFormat()[i] != null && meta.getFieldFormat()[i].length() >= 1) {
                                    data.df.applyPattern(meta.getFieldFormat()[i]);
                                }
                                if (meta.getDecimal()[i] != null && meta.getDecimal()[i].length() >= 1) {
                                    data.dfs.setDecimalSeparator(meta.getDecimal()[i].charAt(0));
                                }
                                if (meta.getGroup()[i] != null && meta.getGroup()[i].length() >= 1) {
                                    data.dfs.setGroupingSeparator(meta.getGroup()[i].charAt(0));
                                }
                                if (meta.getCurrency()[i] != null && meta.getCurrency()[i].length() >= 1) {
                                    data.dfs.setCurrencySymbol(meta.getCurrency()[i]);
                                }
                                data.df.setDecimalFormatSymbols(data.dfs);
                            }
                            rowData[i] = new Double(data.nf.parse(stringValue).doubleValue());
                        }
                        catch (Exception e) {
                            message2 = Messages.getString("Constant.BuildRow.Error.Parsing.Number", value.getName(), stringValue, e.toString());
                            remarks.add((CheckResultInterface)new CheckResult(4, message2, null));
                        }
                        break;
                    }
                    case 2: {
                        rowData[i] = stringValue;
                        break;
                    }
                    case 3: {
                        String message2;
                        try {
                            if (meta.getFieldFormat()[i] != null) {
                                data.daf.applyPattern(meta.getFieldFormat()[i]);
                                data.daf.setDateFormatSymbols(data.dafs);
                            }
                            rowData[i] = data.daf.parse(stringValue);
                        }
                        catch (Exception e) {
                            message2 = Messages.getString("Constant.BuildRow.Error.Parsing.Date", value.getName(), stringValue, e.toString());
                            remarks.add((CheckResultInterface)new CheckResult(4, message2, null));
                        }
                        break;
                    }
                    case 5: {
                        String message2;
                        try {
                            rowData[i] = new Long(Long.parseLong(stringValue));
                        }
                        catch (Exception e) {
                            message2 = Messages.getString("Constant.BuildRow.Error.Parsing.Integer", value.getName(), stringValue, e.toString());
                            remarks.add((CheckResultInterface)new CheckResult(4, message2, null));
                        }
                        break;
                    }
                    case 6: {
                        String message2;
                        try {
                            rowData[i] = new BigDecimal(stringValue);
                        }
                        catch (Exception e) {
                            message2 = Messages.getString("Constant.BuildRow.Error.Parsing.BigNumber", value.getName(), stringValue, e.toString());
                            remarks.add((CheckResultInterface)new CheckResult(4, message2, null));
                        }
                        break;
                    }
                    case 4: {
                        rowData[i] = "Y".equalsIgnoreCase(stringValue) || "TRUE".equalsIgnoreCase(stringValue);
                        break;
                    }
                    case 8: {
                        rowData[i] = stringValue.getBytes();
                        break;
                    }
                    default: {
                        message = Messages.getString("Constant.CheckResult.SpecifyTypeError", value.getName(), stringValue);
                        remarks.add((CheckResultInterface)new CheckResult(4, message, null));
                    }
                }
            }
            rowMeta.addValueMeta((ValueMetaInterface)value);
        }
        return new RowMetaAndData((RowMetaInterface)rowMeta, rowData);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] r = null;
        r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.data.firstRow) {
            this.data.firstRow = false;
            this.data.outputMeta = this.getInputRowMeta().clone();
            RowMetaInterface constants = this.data.constants.getRowMeta();
            this.data.outputMeta.mergeRowMeta(constants);
        }
        r = RowDataUtil.addRowData((Object[])r, (int)this.getInputRowMeta().size(), (Object[])this.data.constants.getData());
        this.putRow(this.data.outputMeta, r);
        if (this.log.isRowLevel()) {
            this.log.logRowlevel(this.toString(), Messages.getString("Constant.Log.Wrote.Row", Long.toString(this.getLinesWritten()), this.getInputRowMeta().getString(r)), new Object[0]);
        }
        if (this.checkFeedback(this.getLinesWritten()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("Constant.Log.LineNr", Long.toString(this.getLinesWritten())));
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ConstantMeta)smi;
        this.data = (ConstantData)sdi;
        this.data.firstRow = true;
        if (super.init(smi, sdi)) {
            ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
            this.data.constants = Constant.buildRow(this.meta, this.data, remarks);
            if (remarks.isEmpty()) {
                return true;
            }
            for (int i = 0; i < remarks.size(); ++i) {
                CheckResultInterface cr = (CheckResultInterface)remarks.get(i);
                this.log.logError(this.getStepname(), cr.getText(), new Object[0]);
            }
        }
        return false;
    }

    @Override
    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

