/*	$OpenBSD: complex.h,v 1.2 2018/03/12 04:25:08 guenther Exp $	*/
/*
 * Copyright (c) 2016 Philip Guenther <guenther@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _LIBM_COMPLEX_H_
#define	_LIBM_COMPLEX_H_

#include_next <complex.h>

PROTO_NORMAL(cacos);
PROTO_NORMAL(casin);
PROTO_NORMAL(catan);
PROTO_NORMAL(ccos);
PROTO_NORMAL(csin);
PROTO_NORMAL(ctan);
PROTO_NORMAL(cacosh);
PROTO_NORMAL(casinh);
PROTO_NORMAL(catanh);
PROTO_NORMAL(ccosh);
PROTO_NORMAL(csinh);
PROTO_NORMAL(ctanh);
PROTO_NORMAL(cexp);
PROTO_NORMAL(clog);
PROTO_NORMAL(cabs);
PROTO_NORMAL(cpow);
PROTO_NORMAL(csqrt);
PROTO_NORMAL(carg);
PROTO_NORMAL(cimag);
PROTO_NORMAL(conj);
PROTO_NORMAL(cproj);
PROTO_NORMAL(creal);

PROTO_STD_DEPRECATED(cacosf);
PROTO_NORMAL(casinf);
PROTO_NORMAL(catanf);
PROTO_STD_DEPRECATED(ccosf);
PROTO_STD_DEPRECATED(csinf);
PROTO_STD_DEPRECATED(ctanf);
PROTO_STD_DEPRECATED(cacoshf);
PROTO_STD_DEPRECATED(casinhf);
PROTO_STD_DEPRECATED(catanhf);
PROTO_STD_DEPRECATED(ccoshf);
PROTO_STD_DEPRECATED(csinhf);
PROTO_STD_DEPRECATED(ctanhf);
PROTO_STD_DEPRECATED(cexpf);
PROTO_NORMAL(clogf);
PROTO_NORMAL(cabsf);
PROTO_STD_DEPRECATED(cpowf);
PROTO_NORMAL(csqrtf);
PROTO_NORMAL(cargf);
PROTO_NORMAL(cimagf);
PROTO_STD_DEPRECATED(conjf);
PROTO_STD_DEPRECATED(cprojf);
PROTO_NORMAL(crealf);

LDBL_PROTO_STD_DEPRECATED(cacosl);
LDBL_PROTO_NORMAL(casinl);
LDBL_PROTO_NORMAL(catanl);
LDBL_PROTO_STD_DEPRECATED(ccosl);
LDBL_PROTO_STD_DEPRECATED(csinl);
LDBL_PROTO_STD_DEPRECATED(ctanl);
LDBL_PROTO_STD_DEPRECATED(cacoshl);
LDBL_PROTO_STD_DEPRECATED(casinhl);
LDBL_PROTO_STD_DEPRECATED(catanhl);
LDBL_PROTO_STD_DEPRECATED(ccoshl);
LDBL_PROTO_STD_DEPRECATED(csinhl);
LDBL_PROTO_STD_DEPRECATED(ctanhl);
LDBL_PROTO_STD_DEPRECATED(cexpl);
LDBL_PROTO_NORMAL(clogl);
LDBL_PROTO_NORMAL(cabsl);
LDBL_PROTO_STD_DEPRECATED(cpowl);
LDBL_PROTO_NORMAL(csqrtl);
LDBL_PROTO_NORMAL(cargl);
LDBL_PROTO_NORMAL(cimagl);
LDBL_PROTO_STD_DEPRECATED(conjl);
LDBL_PROTO_STD_DEPRECATED(cprojl);
LDBL_PROTO_NORMAL(creall);

#endif /* _LIBM_COMPLEX_H_ */
