/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.debug;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.debug.BreakPointListener;
import org.pentaho.di.trans.debug.TransDebugMeta;
import org.pentaho.di.trans.step.StepMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepDebugMeta {
    public static final String XML_TAG = "step-debug-meta";
    private StepMeta stepMeta;
    private int rowCount;
    private boolean readingFirstRows = true;
    private boolean pausingOnBreakPoint;
    private Condition condition;
    private List<BreakPointListener> breakPointListers;
    private RowMetaInterface rowBufferMeta;
    private List<Object[]> rowBuffer = new ArrayList<Object[]>();
    private int numberOfHits = 0;

    public StepDebugMeta() {
        this.breakPointListers = new ArrayList<BreakPointListener>();
    }

    public StepDebugMeta(StepMeta stepMeta) {
        this();
        this.stepMeta = stepMeta;
    }

    public StepMeta getStepMeta() {
        return this.stepMeta;
    }

    public void setStepMeta(StepMeta stepMeta) {
        this.stepMeta = stepMeta;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void addBreakPointListener(BreakPointListener breakPointListener) {
        this.breakPointListers.add(breakPointListener);
    }

    public void removeBreakPointListener(BreakPointListener breakPointListener) {
        this.breakPointListers.remove(breakPointListener);
    }

    public void fireBreakPointListeners(TransDebugMeta transDebugMeta) {
        for (BreakPointListener listener : this.breakPointListers) {
            listener.breakPointHit(transDebugMeta, this, this.rowBufferMeta, this.rowBuffer);
        }
        ++this.numberOfHits;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public boolean isReadingFirstRows() {
        return this.readingFirstRows;
    }

    public void setReadingFirstRows(boolean readingFirstRows) {
        this.readingFirstRows = readingFirstRows;
    }

    public boolean isPausingOnBreakPoint() {
        return this.pausingOnBreakPoint;
    }

    public void setPausingOnBreakPoint(boolean pausingOnBreakPoint) {
        this.pausingOnBreakPoint = pausingOnBreakPoint;
    }

    public RowMetaInterface getRowBufferMeta() {
        return this.rowBufferMeta;
    }

    public void setRowBufferMeta(RowMetaInterface rowBufferMeta) {
        this.rowBufferMeta = rowBufferMeta;
    }

    public List<Object[]> getRowBuffer() {
        return this.rowBuffer;
    }

    public void setRowBuffer(List<Object[]> rowBuffer) {
        this.rowBuffer = rowBuffer;
    }

    public int getNumberOfHits() {
        return this.numberOfHits;
    }

    public void setNumberOfHits(int numberOfHits) {
        this.numberOfHits = numberOfHits;
    }
}

