/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.xml.dtd;

import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import io.sf.carte.doc.xml.dtd.DocumentTypeDeclaration;
import io.sf.carte.uparser.TokenControl;
import io.sf.carte.uparser.TokenHandler;
import io.sf.carte.uparser.TokenHandler2;
import io.sf.carte.uparser.TokenProducer;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class ContentModel {
    private static final Map<String, ContentModel> contentModelMap = new HashMap<String, ContentModel>();
    private final Set<String> emptyElements;
    private static final int DTD_SIZE_LIMIT = 0x100000;

    private ContentModel(Set<String> emptyElements) {
        this.emptyElements = emptyElements;
    }

    private static Set<String> emptyElementsFromDTD(DocumentType docType, EntityResolver2 resolver) throws SAXException, IOException {
        InputSource isrc = resolver.resolveEntity(docType.getName(), docType.getPublicId(), docType.getBaseURI(), docType.getSystemId());
        if (isrc == null) {
            throw new IllegalArgumentException("Unable to resolve declaration " + docType.toString());
        }
        Set<String> empty = ContentModel.parseDTD(isrc.getCharacterStream());
        HashSet<String> emptyElementSet = new HashSet<String>(empty);
        empty.clear();
        return emptyElementSet;
    }

    private static Set<String> emptyElementsFromDTD(DocumentTypeDeclaration dtDecl, EntityResolver2 resolver) throws SAXException, IOException {
        InputSource isrc = resolver.resolveEntity(dtDecl.getName(), dtDecl.getPublicId(), null, dtDecl.getSystemId());
        if (isrc == null) {
            throw new IllegalArgumentException("Unable to resolve declaration " + dtDecl.toString());
        }
        Set<String> empty = ContentModel.parseDTD(isrc.getCharacterStream());
        HashSet<String> emptyElementSet = new HashSet<String>(empty);
        empty.clear();
        return emptyElementSet;
    }

    private static Set<String> parseDTD(Reader reader) throws IOException {
        HashSet<String> emptyelmSet = new HashSet<String>(32);
        DTDTokenHandler handler = new DTDTokenHandler(emptyelmSet);
        int[] allowInWords = new int[]{60, 33};
        TokenProducer tp = new TokenProducer((TokenHandler2)handler, allowInWords, 0x100000);
        tp.parse(reader, "<!--", "-->");
        return emptyelmSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentModel getModel(DocumentType docType) throws SAXException, IOException {
        String id = docType.getPublicId();
        if (id == null && (id = docType.getSystemId()) == null) {
            id = docType.getName();
        }
        Map<String, ContentModel> map = contentModelMap;
        synchronized (map) {
            if (id != null && !contentModelMap.containsKey(id)) {
                ContentModel model;
                DefaultEntityResolver resolver = new DefaultEntityResolver();
                try {
                    model = new ContentModel(ContentModel.emptyElementsFromDTD(docType, (EntityResolver2)resolver));
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
                contentModelMap.put(id, model);
            }
        }
        return contentModelMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentModel getModel(String docTypeDecl) throws SAXException, IOException {
        DocumentTypeDeclaration dtd = DocumentTypeDeclaration.parse(docTypeDecl);
        String id = dtd.getPublicId();
        if (id == null && (id = dtd.getSystemId()) == null) {
            id = dtd.getName();
        }
        Map<String, ContentModel> map = contentModelMap;
        synchronized (map) {
            if (id != null && !contentModelMap.containsKey(id)) {
                ContentModel model;
                DefaultEntityResolver resolver = new DefaultEntityResolver();
                try {
                    model = new ContentModel(ContentModel.emptyElementsFromDTD(dtd, (EntityResolver2)resolver));
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
                contentModelMap.put(id, model);
            }
        }
        return contentModelMap.get(id);
    }

    public static ContentModel getXHTML1TransitionalModel() {
        try {
            return ContentModel.getModel("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        }
        catch (IOException | SAXException exception) {
            throw new IllegalStateException();
        }
    }

    public boolean isEmpty(String name) {
        return this.emptyElements.contains(name);
    }

    private static class DTDTokenHandler
    implements TokenHandler {
        private final Set<String> emptySet;
        private byte stage = 0;
        private String currentElement = null;

        DTDTokenHandler(Set<String> emptySet) {
            this.emptySet = emptySet;
        }

        public void tokenStart(TokenControl control) {
        }

        public void word(int index, CharSequence word) {
            if ("<!ELEMENT".contentEquals(word)) {
                this.stage = 1;
            } else if (this.stage == 1) {
                this.currentElement = word.toString();
                this.stage = (byte)2;
            } else {
                this.stage = this.stage == 2 && "EMPTY".contentEquals(word) ? (byte)3 : (byte)-1;
            }
        }

        public void separator(int index, int codePoint) {
        }

        public void quoted(int index, CharSequence quoted, int quote) {
            this.stage = (byte)-1;
        }

        public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
            this.stage = (byte)-1;
        }

        public void quotedNewlineChar(int index, int codePoint) {
            this.stage = (byte)-1;
        }

        public void openGroup(int index, int codePoint) {
            this.stage = (byte)-1;
        }

        public void closeGroup(int index, int codePoint) {
            this.stage = (byte)-1;
        }

        public void character(int index, int codePoint) {
            if (codePoint == 62) {
                if (this.stage == 3) {
                    this.emptySet.add(this.currentElement);
                }
                this.stage = 0;
            } else {
                this.stage = (byte)-1;
            }
        }

        public void escaped(int index, int codePoint) {
            this.stage = (byte)-1;
        }

        public void control(int index, int codePoint) {
        }

        public void commented(int index, int commentType, String comment) {
        }

        public void endOfStream(int len) {
        }

        public void error(int index, byte errCode, CharSequence context) {
        }
    }
}

