/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketAddress;
import net.i2p.client.streaming.impl.ConnectionOptions;
import net.i2p.client.streaming.impl.I2PServerSocketFull;
import net.i2p.client.streaming.impl.I2PSocketManagerFull;
import net.i2p.client.streaming.impl.StandardSocket;

class StandardServerSocket
extends ServerSocket {
    private final I2PServerSocketFull _socket;

    StandardServerSocket(I2PServerSocketFull socket) throws IOException {
        this._socket = socket;
    }

    @Override
    public Socket accept() throws IOException {
        try {
            I2PSocket sock = this._socket.accept();
            if (sock == null) {
                throw new IOException("No socket");
            }
            return new StandardSocket(sock);
        }
        catch (I2PException i2pe) {
            IOException ioe = new IOException("accept fail");
            ioe.initCause(i2pe);
            throw ioe;
        }
    }

    @Override
    public void bind(SocketAddress endpoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(SocketAddress endpoint, int backlog) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Already closed");
        }
        this._socket.close();
    }

    @Override
    public ServerSocketChannel getChannel() {
        return null;
    }

    @Override
    public InetAddress getInetAddress() {
        return null;
    }

    @Override
    public int getLocalPort() {
        return -1;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return new I2PSocketAddress(this._socket.getManager().getSession().getMyDestination(), 0);
    }

    @Override
    public int getReceiveBufferSize() {
        ConnectionOptions opts = (ConnectionOptions)((I2PSocketManagerFull)this._socket.getManager()).getDefaultOptions();
        if (opts == null) {
            return 65536;
        }
        return opts.getInboundBufferSize();
    }

    @Override
    public boolean getReuseAddress() {
        return false;
    }

    @Override
    public int getSoTimeout() {
        return (int)this._socket.getSoTimeout();
    }

    @Override
    public boolean isBound() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return !((I2PSocketManagerFull)this._socket.getManager()).getConnectionManager().getAllowIncomingConnections();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }

    @Override
    public void setReceiveBufferSize(int size) {
    }

    @Override
    public void setReuseAddress(boolean on) {
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this._socket.setSoTimeout(timeout);
    }

    @Override
    public String toString() {
        return this._socket.toString();
    }
}

