/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.http.simple;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.keycloak.common.util.Base64;
import org.keycloak.http.simple.SimpleHttpMethod;
import org.keycloak.http.simple.SimpleHttpResponse;

public class SimpleHttpRequest {
    private final HttpClient client;
    private final RequestConfig requestConfig;
    private final ObjectMapper objectMapper;
    private final String url;
    private final SimpleHttpMethod method;
    private Map<String, String> headers;
    private Map<String, String> params;
    private Object entity;
    private final long maxConsumedResponseSize;

    SimpleHttpRequest(String url, SimpleHttpMethod method, HttpClient client, RequestConfig requestConfig, long maxConsumedResponseSize, ObjectMapper objectMapper) {
        this.client = client;
        this.requestConfig = requestConfig;
        this.url = url;
        this.method = method;
        this.maxConsumedResponseSize = maxConsumedResponseSize;
        this.objectMapper = objectMapper;
    }

    public SimpleHttpRequest header(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
        return this;
    }

    public String getHeader(String name) {
        if (this.headers != null) {
            return this.headers.get(name);
        }
        return null;
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.headers);
    }

    public String getParam(String name) {
        if (this.params == null) {
            return null;
        }
        return this.params.get(name);
    }

    public Map<String, String> getParams() {
        if (this.params == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.params);
    }

    public Object getEntity() {
        return this.entity;
    }

    public SimpleHttpRequest json(Object entity) {
        this.entity = entity;
        return this;
    }

    public SimpleHttpRequest entity(HttpEntity entity) {
        this.entity = entity;
        return this;
    }

    public SimpleHttpRequest params(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public SimpleHttpRequest param(String name, String value) {
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        this.params.put(name, value);
        return this;
    }

    public SimpleHttpRequest auth(String token) {
        this.header("Authorization", "Bearer " + token);
        return this;
    }

    public SimpleHttpRequest authBasic(String username, String password) {
        String basicCredentials = String.format("%s:%s", username, password);
        this.header("Authorization", "Basic " + Base64.encodeBytes((byte[])basicCredentials.getBytes()));
        return this;
    }

    public SimpleHttpRequest acceptJson() {
        if (this.headers == null || !this.headers.containsKey("Accept")) {
            this.header("Accept", "application/json");
        }
        return this;
    }

    public JsonNode asJson() throws IOException {
        if (this.headers == null || !this.headers.containsKey("Accept")) {
            this.header("Accept", "application/json");
        }
        return this.objectMapper.readTree(this.asString());
    }

    public <T> T asJson(Class<T> type) throws IOException {
        if (this.headers == null || !this.headers.containsKey("Accept")) {
            this.header("Accept", "application/json");
        }
        return (T)this.objectMapper.readValue(this.asString(), type);
    }

    public <T> T asJson(TypeReference<T> type) throws IOException {
        if (this.headers == null || !this.headers.containsKey("Accept")) {
            this.header("Accept", "application/json");
        }
        return (T)this.objectMapper.readValue(this.asString(), type);
    }

    public String asString() throws IOException {
        return this.asResponse().asString();
    }

    public int asStatus() throws IOException {
        return this.asResponse().getStatus();
    }

    public SimpleHttpResponse asResponse() throws IOException {
        return this.makeRequest();
    }

    private HttpRequestBase createHttpRequest() {
        return switch (this.method) {
            default -> throw new IncompatibleClassChangeError();
            case SimpleHttpMethod.GET -> new HttpGet(this.appendParameterToUrl(this.url));
            case SimpleHttpMethod.DELETE -> new HttpDelete(this.appendParameterToUrl(this.url));
            case SimpleHttpMethod.HEAD -> new HttpHead(this.appendParameterToUrl(this.url));
            case SimpleHttpMethod.PUT -> new HttpPut(this.appendParameterToUrl(this.url));
            case SimpleHttpMethod.PATCH -> new HttpPatch(this.appendParameterToUrl(this.url));
            case SimpleHttpMethod.POST -> new HttpPost(this.url);
        };
    }

    public String getUrl() {
        return this.url;
    }

    private SimpleHttpResponse makeRequest() throws IOException {
        HttpRequestBase httpRequest = this.createHttpRequest();
        if (httpRequest instanceof HttpPost || httpRequest instanceof HttpPut || httpRequest instanceof HttpPatch) {
            if (this.params != null) {
                ((HttpEntityEnclosingRequestBase)httpRequest).setEntity((HttpEntity)this.getFormEntityFromParameter());
            } else if (this.entity instanceof HttpEntity) {
                ((HttpEntityEnclosingRequestBase)httpRequest).setEntity((HttpEntity)this.entity);
            } else if (this.entity != null) {
                if (this.headers == null || !this.headers.containsKey("Content-Type")) {
                    this.header("Content-Type", "application/json");
                }
                ((HttpEntityEnclosingRequestBase)httpRequest).setEntity((HttpEntity)this.getJsonEntity());
            } else {
                throw new IllegalStateException("No content set");
            }
        }
        if (this.headers != null) {
            for (Map.Entry<String, String> h : this.headers.entrySet()) {
                httpRequest.setHeader(h.getKey(), h.getValue());
            }
        }
        if (this.requestConfig != null) {
            httpRequest.setConfig(this.requestConfig);
        }
        return new SimpleHttpResponse(this.client.execute((HttpUriRequest)httpRequest), this.maxConsumedResponseSize, this.objectMapper);
    }

    private URI appendParameterToUrl(String url) {
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (this.params != null) {
                for (Map.Entry<String, String> p : this.params.entrySet()) {
                    uriBuilder.setParameter(p.getKey(), p.getValue());
                }
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException ignored) {
            return null;
        }
    }

    private StringEntity getJsonEntity() throws IOException {
        return new StringEntity(this.objectMapper.writeValueAsString(this.entity), ContentType.getByMimeType((String)this.headers.get("Content-Type")));
    }

    private UrlEncodedFormEntity getFormEntityFromParameter() {
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        if (this.params != null) {
            for (Map.Entry<String, String> p : this.params.entrySet()) {
                urlParameters.add(new BasicNameValuePair(p.getKey(), p.getValue()));
            }
        }
        return new UrlEncodedFormEntity(urlParameters, StandardCharsets.UTF_8);
    }
}

