/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.temptable;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.temptable.TemporaryTableColumn;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.temptable.TemporaryTableSessionUidColumn;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.generator.Generator;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Contributable;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.Association;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class TemporaryTable
implements Exportable,
Contributable {
    public static final String ID_TABLE_PREFIX = "HT_";
    public static final String ENTITY_TABLE_PREFIX = "HTE_";
    public static final String DEFAULT_ALIAS = "temptable_";
    public static final String ENTITY_TABLE_IDENTITY_COLUMN = "HTE_IDENTITY";
    public static final String ENTITY_ROW_NUMBER_COLUMN = "rn_";
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(TemporaryTable.class);
    private final String contributor;
    private final String qualifiedTableName;
    private final TemporaryTableKind temporaryTableKind;
    private final TemporaryTableSessionUidColumn sessionUidColumn;
    private final List<TemporaryTableColumn> columns;
    private final List<TemporaryTableColumn> columnsForExport;
    private final Dialect dialect;

    private TemporaryTable(PersistentClass persistentClass, Function<String, String> temporaryTableNameAdjuster, TemporaryTableKind temporaryTableKind, Dialect dialect, RuntimeModelCreationContext creationContext, Function<TemporaryTable, List<TemporaryTableColumn>> columnInitializer) {
        this.contributor = persistentClass.getContributor();
        Identifier tableNameIdentifier = persistentClass instanceof SingleTableSubclass ? new Identifier(persistentClass.getTable().getNameIdentifier().getText() + persistentClass.getSubclassId(), persistentClass.getTable().getNameIdentifier().isQuoted()) : persistentClass.getTable().getNameIdentifier();
        QualifiedNameParser.NameParts nameParts = QualifiedNameParser.INSTANCE.parse(temporaryTableNameAdjuster.apply(tableNameIdentifier.getText()));
        Identifier catalogIdentifier = nameParts.getCatalogName() != null ? nameParts.getCatalogName() : persistentClass.getTable().getCatalogIdentifier();
        Identifier schemaIdentifier = nameParts.getSchemaName() != null ? nameParts.getSchemaName() : persistentClass.getTable().getSchemaIdentifier();
        String adjustedName = nameParts.getObjectName().getText();
        Identifier temporaryTableNameIdentifier = new Identifier(adjustedName.substring(0, Math.min(dialect.getMaxIdentifierLength(), adjustedName.length())), tableNameIdentifier.isQuoted());
        this.qualifiedTableName = creationContext.getSqlStringGenerationContext().format(new QualifiedTableName(catalogIdentifier, schemaIdentifier, temporaryTableNameIdentifier));
        this.temporaryTableKind = temporaryTableKind;
        this.dialect = dialect;
        if (temporaryTableKind == TemporaryTableKind.PERSISTENT) {
            TypeConfiguration typeConfiguration = creationContext.getTypeConfiguration();
            BasicType<UUID> uuidType = typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.UUID_CHAR);
            Size size = dialect.getSizeStrategy().resolveSize(uuidType.getJdbcType(), uuidType.getJavaTypeDescriptor(), null, null, null);
            this.sessionUidColumn = new TemporaryTableSessionUidColumn(this, uuidType, typeConfiguration.getDdlTypeRegistry().getTypeName(uuidType.getJdbcType().getDdlTypeCode(), size, uuidType), size);
        } else {
            this.sessionUidColumn = null;
        }
        List<TemporaryTableColumn> columns = columnInitializer.apply(this);
        if (this.sessionUidColumn != null) {
            columns.add(this.sessionUidColumn);
        }
        this.columns = columns;
        if (columns.size() > 1) {
            ArrayList<TemporaryTableColumn> columnsForExport = new ArrayList<TemporaryTableColumn>(columns);
            creationContext.getBootModel().getMetadataBuildingOptions().getColumnOrderingStrategy().orderTemporaryTableColumns(columnsForExport, creationContext.getMetadata());
            this.columnsForExport = columnsForExport;
        } else {
            this.columnsForExport = columns;
        }
    }

    @Deprecated(forRemoval=true, since="7.1")
    public static TemporaryTable createIdTable(EntityMappingType entityDescriptor, Function<String, String> temporaryTableNameAdjuster, Dialect dialect, RuntimeModelCreationContext runtimeModelCreationContext) {
        return TemporaryTable.createIdTable(runtimeModelCreationContext.getBootModel().getEntityBinding(entityDescriptor.getEntityName()), temporaryTableNameAdjuster, dialect.getSupportedTemporaryTableKind(), dialect, runtimeModelCreationContext);
    }

    @Deprecated(forRemoval=true, since="7.1")
    public static TemporaryTable createEntityTable(EntityMappingType entityDescriptor, Function<String, String> temporaryTableNameAdjuster, Dialect dialect, RuntimeModelCreationContext runtimeModelCreationContext) {
        return TemporaryTable.createIdTable(runtimeModelCreationContext.getBootModel().getEntityBinding(entityDescriptor.getEntityName()), temporaryTableNameAdjuster, dialect.getSupportedTemporaryTableKind(), dialect, runtimeModelCreationContext);
    }

    public static TemporaryTable createIdTable(PersistentClass persistentClass, Function<String, String> temporaryTableNameAdjuster, TemporaryTableKind temporaryTableKind, Dialect dialect, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new TemporaryTable(persistentClass, temporaryTableNameAdjuster, temporaryTableKind, dialect, runtimeModelCreationContext, temporaryTable -> {
            MetadataImplementor metadata = runtimeModelCreationContext.getMetadata();
            ArrayList<TemporaryTableColumn> columns = new ArrayList<TemporaryTableColumn>();
            for (Column column : persistentClass.getKey().getColumns()) {
                columns.add(new TemporaryTableColumn((TemporaryTable)temporaryTable, column.getText(dialect), column.getType(), column.getSqlType(metadata), column.getColumnSize(dialect, metadata), column.isNullable(), true));
            }
            TemporaryTable.visitPluralAttributes(persistentClass.getPropertyClosure(), collection -> {
                if (collection.getCollectionTable() != null && collection.getReferencedPropertyName() != null) {
                    KeyValue collectionKey = collection.getKey();
                    for (Selectable selectable : collectionKey.getSelectables()) {
                        if (!(selectable instanceof Column)) continue;
                        Column column = (Column)selectable;
                        columns.add(new TemporaryTableColumn((TemporaryTable)temporaryTable, column.getText(dialect), column.getType(), column.getSqlType(metadata), column.getColumnSize(dialect, metadata), column.isNullable()));
                    }
                }
            });
            return columns;
        });
    }

    private static void visitPluralAttributes(List<Property> properties, Consumer<Collection> consumer) {
        for (Property property : properties) {
            Value value = property.getValue();
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                consumer.accept(collection);
                continue;
            }
            if (!(value instanceof Component)) continue;
            Component component = (Component)value;
            TemporaryTable.visitPluralAttributes(component.getProperties(), consumer);
        }
    }

    public static TemporaryTable createEntityTable(PersistentClass persistentClass, Function<String, String> temporaryTableNameAdjuster, TemporaryTableKind temporaryTableKind, Dialect dialect, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new TemporaryTable(persistentClass, temporaryTableNameAdjuster, temporaryTableKind, dialect, runtimeModelCreationContext, temporaryTable -> {
            boolean isExternallyGenerated;
            boolean identityColumn;
            MetadataImplementor metadata = runtimeModelCreationContext.getMetadata();
            ArrayList<TemporaryTableColumn> columns = new ArrayList<TemporaryTableColumn>();
            List<Column> rootKeyColumns = persistentClass.getRootClass().getKey().getColumns();
            boolean bl = identityColumn = rootKeyColumns.size() == 1 && rootKeyColumns.get(0).isIdentity();
            if (identityColumn) {
                isExternallyGenerated = false;
                for (Column column : persistentClass.getKey().getColumns()) {
                    Object sqlTypeName = "";
                    if (dialect.getIdentityColumnSupport().hasDataTypeInIdentityColumn()) {
                        sqlTypeName = column.getSqlType(metadata) + " ";
                    }
                    sqlTypeName = (String)sqlTypeName + dialect.getIdentityColumnSupport().getIdentityColumnString(column.getSqlTypeCode(metadata));
                    columns.add(new TemporaryTableColumn((TemporaryTable)temporaryTable, ENTITY_TABLE_IDENTITY_COLUMN, column.getType(), (String)sqlTypeName, column.getColumnSize(dialect, metadata), true, true));
                }
            } else {
                OnExecutionGenerator generator;
                Generator identifierGenerator = runtimeModelCreationContext.getGenerators().get(persistentClass.getRootClass().getEntityName());
                assert (identifierGenerator != null);
                isExternallyGenerated = !(identifierGenerator instanceof OnExecutionGenerator && (generator = (OnExecutionGenerator)identifierGenerator).generatedOnExecution());
            }
            Property identifierProperty = persistentClass.getIdentifierProperty();
            String idName = identifierProperty != null ? identifierProperty.getName() : "id";
            TemporaryTable.forEachTemporaryTableColumn(metadata, temporaryTable, idName, persistentClass.getIdentifier(), temporaryTableColumn -> columns.add(new TemporaryTableColumn(temporaryTableColumn.getContainingTable(), temporaryTableColumn.getColumnName(), temporaryTableColumn.getJdbcMapping(), temporaryTableColumn.getSqlTypeDefinition(), temporaryTableColumn.getSize(), identityColumn || isExternallyGenerated, !identityColumn && !isExternallyGenerated)));
            Value discriminator = persistentClass.getDiscriminator();
            if (discriminator != null && !discriminator.getSelectables().get(0).isFormula()) {
                TemporaryTable.forEachTemporaryTableColumn(metadata, temporaryTable, "class", discriminator, temporaryTableColumn -> columns.add(new TemporaryTableColumn(temporaryTableColumn.getContainingTable(), temporaryTableColumn.getColumnName(), temporaryTableColumn.getJdbcMapping(), temporaryTableColumn.getSqlTypeDefinition(), temporaryTableColumn.getSize(), discriminator.isNullable())));
            }
            for (Property property : persistentClass.getPropertyClosure()) {
                if (property.isSynthetic()) continue;
                TemporaryTable.forEachTemporaryTableColumn(metadata, temporaryTable, property.getName(), property.getValue(), columns::add);
            }
            if (isExternallyGenerated) {
                Object rowNumberType;
                TypeConfiguration typeConfiguration = metadata.getTypeConfiguration();
                BasicType<Integer> integerBasicType = typeConfiguration.getBasicTypeForJavaType(Integer.class);
                if (dialect.supportsWindowFunctions()) {
                    rowNumberType = typeConfiguration.getDdlTypeRegistry().getTypeName(integerBasicType.getJdbcType().getDdlTypeCode(), dialect.getSizeStrategy().resolveSize(integerBasicType.getJdbcType(), integerBasicType.getJavaTypeDescriptor(), null, null, null), integerBasicType);
                } else if (dialect.getIdentityColumnSupport().supportsIdentityColumns()) {
                    rowNumberType = typeConfiguration.getDdlTypeRegistry().getTypeName(integerBasicType.getJdbcType().getDdlTypeCode(), dialect.getSizeStrategy().resolveSize(integerBasicType.getJdbcType(), integerBasicType.getJavaTypeDescriptor(), null, null, null), integerBasicType) + " " + dialect.getIdentityColumnSupport().getIdentityColumnString(integerBasicType.getJdbcType().getDdlTypeCode());
                } else {
                    LOG.multiTableInsertNotAvailable(persistentClass.getEntityName());
                    rowNumberType = typeConfiguration.getDdlTypeRegistry().getTypeName(integerBasicType.getJdbcType().getDdlTypeCode(), dialect.getSizeStrategy().resolveSize(integerBasicType.getJdbcType(), integerBasicType.getJavaTypeDescriptor(), null, null, null), integerBasicType);
                }
                columns.add(new TemporaryTableColumn((TemporaryTable)temporaryTable, ENTITY_ROW_NUMBER_COLUMN, integerBasicType, (String)rowNumberType, Size.nil(), false, true));
            }
            return columns;
        });
    }

    private static void forEachTemporaryTableColumn(Metadata metadata, TemporaryTable temporaryTable, String prefix, Value value, Consumer<TemporaryTableColumn> consumer) {
        Dialect dialect = metadata.getDatabase().getDialect();
        SqmMutationStrategyHelper.forEachSelectableMapping(prefix, value, (columnName, selectable) -> consumer.accept(new TemporaryTableColumn(temporaryTable, (String)columnName, selectable.getType(), selectable.getSqlType(metadata), selectable.getColumnSize(dialect, metadata), true)));
    }

    public List<TemporaryTableColumn> findTemporaryTableColumns(EntityPersister entityDescriptor, ModelPart modelPart) {
        int offset = TemporaryTable.determineModelPartStartIndex(entityDescriptor, modelPart);
        if (offset == -1) {
            throw new IllegalStateException("Couldn't find matching temporary table columns for: " + String.valueOf(modelPart));
        }
        int end = offset + modelPart.getJdbcTypeCount();
        return this.getColumns().subList(offset, end);
    }

    private static int determineModelPartStartIndex(EntityPersister entityDescriptor, ModelPart modelPart) {
        boolean hasIdentity = entityDescriptor.getGenerator().generatedOnExecution();
        int offset = hasIdentity ? 1 : 0;
        int idResult = TemporaryTable.determineIdStartIndex(offset, entityDescriptor, modelPart);
        if (idResult <= 0) {
            return -idResult;
        }
        offset = idResult;
        EntityDiscriminatorMapping discriminatorMapping = entityDescriptor.getDiscriminatorMapping();
        if (discriminatorMapping != null && discriminatorMapping.hasPhysicalColumn() && !discriminatorMapping.isFormula()) {
            if (modelPart == discriminatorMapping) {
                return offset;
            }
            offset += discriminatorMapping.getJdbcTypeCount();
        }
        AttributeMappingsList attributeMappings = entityDescriptor.getAttributeMappings();
        for (int i = 0; i < attributeMappings.size(); ++i) {
            AttributeMapping attribute = attributeMappings.get(i);
            if (attribute instanceof PluralAttributeMapping) continue;
            int result = TemporaryTable.determineModelPartStartIndex(offset, attribute, modelPart);
            if (result <= 0) {
                return -result;
            }
            offset = result;
        }
        return -1;
    }

    private static int determineIdStartIndex(int offset, EntityPersister entityDescriptor, ModelPart modelPart) {
        int result;
        int originalOffset = offset;
        do {
            EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
            offset = result = TemporaryTable.determineModelPartStartIndex(originalOffset, identifierMapping, modelPart);
        } while (result > 0 && (entityDescriptor = (EntityPersister)entityDescriptor.getSuperMappingType()) != null);
        return offset;
    }

    private static int determineModelPartStartIndex(int offset, ModelPart modelPart, ModelPart modelPartToFind) {
        if (modelPart == modelPartToFind) {
            return -offset;
        }
        if (modelPart instanceof EntityValuedModelPart) {
            ValuedModelPart valuedModelPart;
            EntityValuedModelPart entityValuedModelPart = (EntityValuedModelPart)modelPart;
            if (modelPart instanceof Association) {
                Association association = (Association)modelPart;
                valuedModelPart = association.getForeignKeyDescriptor();
            } else {
                valuedModelPart = entityValuedModelPart.getEntityMappingType().getIdentifierMapping();
            }
            EntityIdentifierMapping keyPart = valuedModelPart;
            return TemporaryTable.determineModelPartStartIndex(offset, keyPart, modelPartToFind);
        }
        if (modelPart instanceof EmbeddableValuedModelPart) {
            EmbeddableValuedModelPart embeddablePart = (EmbeddableValuedModelPart)modelPart;
            AttributeMappingsList attributeMappings = embeddablePart.getEmbeddableTypeDescriptor().getAttributeMappings();
            for (int i = 0; i < attributeMappings.size(); ++i) {
                AttributeMapping mapping = attributeMappings.get(i);
                int result = TemporaryTable.determineModelPartStartIndex(offset, mapping, modelPartToFind);
                if (result <= 0) {
                    return result;
                }
                offset = result;
            }
            return offset;
        }
        if (modelPart instanceof BasicValuedModelPart) {
            BasicValuedModelPart basicModelPart = (BasicValuedModelPart)modelPart;
            return offset + (basicModelPart.isInsertable() ? modelPart.getJdbcTypeCount() : 0);
        }
        return offset + modelPart.getJdbcTypeCount();
    }

    public boolean isRowNumberGenerated() {
        return !this.dialect.supportsWindowFunctions() && this.dialect.getIdentityColumnSupport().supportsIdentityColumns();
    }

    public String getQualifiedTableName() {
        return this.qualifiedTableName;
    }

    public TemporaryTableKind getTemporaryTableKind() {
        return this.temporaryTableKind;
    }

    public List<TemporaryTableColumn> getColumns() {
        return this.columns;
    }

    public List<TemporaryTableColumn> getColumnsForExport() {
        return this.columnsForExport;
    }

    public TemporaryTableSessionUidColumn getSessionUidColumn() {
        return this.sessionUidColumn;
    }

    public String getTableExpression() {
        return this.qualifiedTableName;
    }

    @Override
    public String getContributor() {
        return this.contributor;
    }

    @Override
    public String getExportIdentifier() {
        return this.getQualifiedTableName();
    }

    public Dialect getDialect() {
        return this.dialect;
    }
}

