/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.tools;

import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.afm.AfmFontRegistry;
import org.pentaho.reporting.libraries.fonts.pfm.PfmFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontSource;

public class ListFonts {
    private ListFonts() {
    }

    private static void printRecord(FontRecord record) {
        if (record == null) {
            System.out.println("  - (there is no font defined for that style and family.)");
            return;
        }
        if (record instanceof FontSource) {
            FontSource fs = (FontSource)record;
            System.out.println("  " + record.getFamily().getFamilyName() + " italics:" + record.isItalic() + " oblique:" + record.isOblique() + " bold: " + record.isBold() + ' ' + fs.getFontSource());
        } else {
            System.out.println("  " + record.getFamily().getFamilyName() + " italics:" + record.isItalic() + " oblique:" + record.isOblique() + " bold: " + record.isBold());
        }
    }

    public static void main(String[] args) {
        LibFontBoot.getInstance().start();
        ListFonts.listFontS(new AfmFontRegistry());
        ListFonts.listFontS(new PfmFontRegistry());
    }

    private static void listFontS(FontRegistry registry) {
        registry.initialize();
        String[] fontFamilies = registry.getRegisteredFamilies();
        for (int i = 0; i < fontFamilies.length; ++i) {
            String fontFamily = fontFamilies[i];
            FontFamily family = registry.getFontFamily(fontFamily);
            ListFonts.printRecord(family.getFontRecord(false, false));
            ListFonts.printRecord(family.getFontRecord(true, false));
            ListFonts.printRecord(family.getFontRecord(false, true));
            ListFonts.printRecord(family.getFontRecord(true, true));
        }
    }
}

