/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrRect2Di;
import org.lwjgl.openxr.XrSwapchain;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSwapchainSubImage
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SWAPCHAIN;
    public static final int IMAGERECT;
    public static final int IMAGEARRAYINDEX;

    public XrSwapchainSubImage(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSwapchainSubImage.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSwapchain")
    public long swapchain() {
        return XrSwapchainSubImage.nswapchain(this.address());
    }

    public XrRect2Di imageRect() {
        return XrSwapchainSubImage.nimageRect(this.address());
    }

    @NativeType(value="uint32_t")
    public int imageArrayIndex() {
        return XrSwapchainSubImage.nimageArrayIndex(this.address());
    }

    public XrSwapchainSubImage swapchain(XrSwapchain value) {
        XrSwapchainSubImage.nswapchain(this.address(), value);
        return this;
    }

    public XrSwapchainSubImage imageRect(XrRect2Di value) {
        XrSwapchainSubImage.nimageRect(this.address(), value);
        return this;
    }

    public XrSwapchainSubImage imageRect(Consumer<XrRect2Di> consumer) {
        consumer.accept(this.imageRect());
        return this;
    }

    public XrSwapchainSubImage imageArrayIndex(@NativeType(value="uint32_t") int value) {
        XrSwapchainSubImage.nimageArrayIndex(this.address(), value);
        return this;
    }

    public XrSwapchainSubImage set(XrSwapchain swapchain, XrRect2Di imageRect, int imageArrayIndex) {
        this.swapchain(swapchain);
        this.imageRect(imageRect);
        this.imageArrayIndex(imageArrayIndex);
        return this;
    }

    public XrSwapchainSubImage set(XrSwapchainSubImage src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSwapchainSubImage malloc() {
        return (XrSwapchainSubImage)XrSwapchainSubImage.wrap(XrSwapchainSubImage.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSwapchainSubImage calloc() {
        return (XrSwapchainSubImage)XrSwapchainSubImage.wrap(XrSwapchainSubImage.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSwapchainSubImage create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSwapchainSubImage)XrSwapchainSubImage.wrap(XrSwapchainSubImage.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSwapchainSubImage create(long address) {
        return (XrSwapchainSubImage)XrSwapchainSubImage.wrap(XrSwapchainSubImage.class, (long)address);
    }

    @Nullable
    public static XrSwapchainSubImage createSafe(long address) {
        return address == 0L ? null : (XrSwapchainSubImage)XrSwapchainSubImage.wrap(XrSwapchainSubImage.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSwapchainSubImage.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSwapchainSubImage.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSwapchainSubImage.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSwapchainSubImage.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSwapchainSubImage.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSwapchainSubImage.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSwapchainSubImage.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSwapchainSubImage malloc(MemoryStack stack) {
        return (XrSwapchainSubImage)XrSwapchainSubImage.wrap(XrSwapchainSubImage.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSwapchainSubImage calloc(MemoryStack stack) {
        return (XrSwapchainSubImage)XrSwapchainSubImage.wrap(XrSwapchainSubImage.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSwapchainSubImage.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSwapchainSubImage.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nswapchain(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SWAPCHAIN));
    }

    public static XrRect2Di nimageRect(long struct) {
        return XrRect2Di.create(struct + (long)IMAGERECT);
    }

    public static int nimageArrayIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)IMAGEARRAYINDEX);
    }

    public static void nswapchain(long struct, XrSwapchain value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SWAPCHAIN), (long)value.address());
    }

    public static void nimageRect(long struct, XrRect2Di value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGERECT), (long)XrRect2Di.SIZEOF);
    }

    public static void nimageArrayIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)IMAGEARRAYINDEX, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SWAPCHAIN)));
    }

    static {
        Struct.Layout layout = XrSwapchainSubImage.__struct((Struct.Member[])new Struct.Member[]{XrSwapchainSubImage.__member((int)POINTER_SIZE), XrSwapchainSubImage.__member((int)XrRect2Di.SIZEOF, (int)XrRect2Di.ALIGNOF), XrSwapchainSubImage.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SWAPCHAIN = layout.offsetof(0);
        IMAGERECT = layout.offsetof(1);
        IMAGEARRAYINDEX = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSwapchainSubImage, Buffer>
    implements NativeResource {
        private static final XrSwapchainSubImage ELEMENT_FACTORY = XrSwapchainSubImage.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSwapchainSubImage getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSwapchain")
        public long swapchain() {
            return XrSwapchainSubImage.nswapchain(this.address());
        }

        public XrRect2Di imageRect() {
            return XrSwapchainSubImage.nimageRect(this.address());
        }

        @NativeType(value="uint32_t")
        public int imageArrayIndex() {
            return XrSwapchainSubImage.nimageArrayIndex(this.address());
        }

        public Buffer swapchain(XrSwapchain value) {
            XrSwapchainSubImage.nswapchain(this.address(), value);
            return this;
        }

        public Buffer imageRect(XrRect2Di value) {
            XrSwapchainSubImage.nimageRect(this.address(), value);
            return this;
        }

        public Buffer imageRect(Consumer<XrRect2Di> consumer) {
            consumer.accept(this.imageRect());
            return this;
        }

        public Buffer imageArrayIndex(@NativeType(value="uint32_t") int value) {
            XrSwapchainSubImage.nimageArrayIndex(this.address(), value);
            return this;
        }
    }
}

