/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.media.internal;

import java.io.File;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.OpenHAB;
import org.openhab.core.audio.AudioManager;
import org.openhab.core.automation.Visibility;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeProvider;
import org.openhab.core.common.registry.ProviderChangeListener;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.ConfigDescriptionParameterBuilder;
import org.openhab.core.config.core.ParameterOption;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(service={ModuleTypeProvider.class})
public class MediaActionTypeProvider
implements ModuleTypeProvider {
    private final AudioManager audioManager;

    @Activate
    public MediaActionTypeProvider(@Reference AudioManager audioManager) {
        this.audioManager = audioManager;
    }

    public @Nullable ModuleType getModuleType(String uid, @Nullable Locale locale) {
        return switch (uid) {
            case "media.PlayAction" -> this.getPlayActionType(locale);
            case "media.SayAction" -> this.getSayActionType(locale);
            case "media.SynthesizeAction" -> this.getSynthesizeActionType(locale);
            default -> null;
        };
    }

    public Collection<ModuleType> getModuleTypes(@Nullable Locale locale) {
        return List.of(this.getPlayActionType(locale), this.getSayActionType(locale));
    }

    private ModuleType getPlayActionType(@Nullable Locale locale) {
        return new ActionType("media.PlayAction", this.getConfigPlayDesc(locale), "play a sound", "Plays a sound file. Optionally sets the volume.", null, Visibility.VISIBLE, null, null);
    }

    private ModuleType getSayActionType(@Nullable Locale locale) {
        return new ActionType("media.SayAction", this.getConfigSayDesc(locale), "say something", "Speaks a given text through a natural voice. Optionally sets the volume.", null, Visibility.VISIBLE, null, null);
    }

    private ModuleType getSynthesizeActionType(@Nullable Locale locale) {
        return new ActionType("media.SynthesizeAction", this.getConfigSynthesizeDesc(locale), "synthesize a tone melody", "Synthesize the given melody text and play it. Optionally sets the volume.", null, Visibility.VISIBLE, null, null);
    }

    private List<ConfigDescriptionParameter> getConfigPlayDesc(@Nullable Locale locale) {
        return List.of(ConfigDescriptionParameterBuilder.create((String)"sound", (ConfigDescriptionParameter.Type)ConfigDescriptionParameter.Type.TEXT).withRequired(Boolean.valueOf(true)).withLabel("Sound").withDescription("the sound to play").withOptions(this.getSoundOptions()).withLimitToOptions(Boolean.valueOf(true)).build(), this.getAudioSinkConfigDescParam(locale), this.getVolumeConfigDescParam(locale));
    }

    private List<ConfigDescriptionParameter> getConfigSayDesc(@Nullable Locale locale) {
        return List.of(ConfigDescriptionParameterBuilder.create((String)"text", (ConfigDescriptionParameter.Type)ConfigDescriptionParameter.Type.TEXT).withRequired(Boolean.valueOf(true)).withLabel("Text").withDescription("the text to speak").build(), this.getAudioSinkConfigDescParam(locale), this.getVolumeConfigDescParam(locale));
    }

    private List<ConfigDescriptionParameter> getConfigSynthesizeDesc(@Nullable Locale locale) {
        return List.of(ConfigDescriptionParameterBuilder.create((String)"melody", (ConfigDescriptionParameter.Type)ConfigDescriptionParameter.Type.TEXT).withRequired(Boolean.valueOf(true)).withLabel("Melody").withDescription("the melody as spaced separated note names").build(), this.getAudioSinkConfigDescParam(locale), this.getVolumeConfigDescParam(locale));
    }

    private ConfigDescriptionParameter getAudioSinkConfigDescParam(@Nullable Locale locale) {
        return ConfigDescriptionParameterBuilder.create((String)"sink", (ConfigDescriptionParameter.Type)ConfigDescriptionParameter.Type.TEXT).withRequired(Boolean.valueOf(false)).withLabel("Sink").withDescription("the audio sink id").withOptions(this.getSinkOptions(locale)).withLimitToOptions(Boolean.valueOf(true)).build();
    }

    private ConfigDescriptionParameter getVolumeConfigDescParam(@Nullable Locale locale) {
        return ConfigDescriptionParameterBuilder.create((String)"volume", (ConfigDescriptionParameter.Type)ConfigDescriptionParameter.Type.INTEGER).withLabel("Volume").withDescription("the volume to use").withMinimum(BigDecimal.ZERO).withMaximum(BigDecimal.valueOf(100L)).withStepSize(BigDecimal.ONE).build();
    }

    private List<ParameterOption> getSoundOptions() {
        ArrayList<ParameterOption> options = new ArrayList<ParameterOption>();
        File soundsDir = Path.of(OpenHAB.getConfigFolder(), "sounds").toFile();
        if (soundsDir.isDirectory()) {
            String[] stringArray = soundsDir.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                if (fileName.contains(".") && !fileName.startsWith(".")) {
                    String soundName = fileName.substring(0, fileName.lastIndexOf("."));
                    String capitalizedSoundName = soundName.substring(0, 1).toUpperCase() + soundName.substring(1).toLowerCase();
                    options.add(new ParameterOption(fileName, capitalizedSoundName));
                }
                ++n2;
            }
            options.sort(Comparator.comparing(ParameterOption::getLabel));
        }
        return options;
    }

    private List<ParameterOption> getSinkOptions(@Nullable Locale locale) {
        Locale safeLocale = locale != null ? locale : Locale.getDefault();
        return this.audioManager.getAllSinks().stream().sorted(Comparator.comparing(s -> s.getLabel(safeLocale))).map(s -> new ParameterOption(s.getId(), s.getLabel(safeLocale))).toList();
    }

    public void addProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
    }

    public Collection<ModuleType> getAll() {
        return this.getModuleTypes(null);
    }

    public void removeProviderChangeListener(ProviderChangeListener<ModuleType> listener) {
    }
}

