/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.java;

import com.intellij.buildsystem.model.DeclaredDependency;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.dependencies.ArtifactDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ComponentDependencies;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.java.AbstractObjectGraphIterator;
import com.intellij.packageChecker.java.JavaLibraryDependency;
import com.intellij.packageChecker.java.JavaPackageUtilKt;
import com.intellij.packageChecker.model.LibraryDependency;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.PackageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u001a(\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e\u001a^\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000b\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\f2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u0002H\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00122\u001a\u0010\u0013\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u0001H\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\f0\u0012\u001a\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0003*\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0003*\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u0003*\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u0003*\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\f2\u0006\u0010\u001e\u001a\u00020\u001f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00150\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"loggerCategory", "", "toPackage", "Lcom/intellij/packageChecker/model/Package;", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "project", "Lcom/intellij/openapi/project/Project;", "toModelPackageDeclaration", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "Lcom/intellij/buildsystem/model/DeclaredDependency;", "rootDependencies", "", "", "projectDependencies", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/ProjectDependencies;", "T", "rootNodes", "pkgMapper", "Lkotlin/Function1;", "getChildren", "packageTypes", "Lcom/intellij/packageChecker/model/PackageType;", "createPackage", "Lcom/intellij/openapi/roots/libraries/Library;", "getPackageFromLibraryName", "getPackageFromLibraryDescriptor", "createMavenPackage", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/DependencyNode;", "javaLibraryDependencies", "Lcom/intellij/packageChecker/model/LibraryDependency;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.packageChecker.java"})
@SourceDebugExtension(value={"SMAP\njavaPackageUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 javaPackageUtil.kt\ncom/intellij/packageChecker/java/JavaPackageUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,199:1\n1374#2:200\n1460#2,5:201\n382#3,7:206\n*S KotlinDebug\n*F\n+ 1 javaPackageUtil.kt\ncom/intellij/packageChecker/java/JavaPackageUtilKt\n*L\n42#1:200\n42#1:201,5\n72#1:206,7\n*E\n"})
public final class JavaPackageUtilKt {
    @NotNull
    private static final String loggerCategory = "org.jetbrains.security.dependencies.calculator";
    @NotNull
    private static final Map<String, PackageType> packageTypes;

    @Nullable
    public static final Package toPackage(@NotNull UnifiedDependency $this$toPackage, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$toPackage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = $this$toPackage.getCoordinates().getArtifactId();
        if (string == null) {
            return null;
        }
        String name = string;
        String string2 = $this$toPackage.getCoordinates().getVersion();
        if (string2 == null) {
            return null;
        }
        String version = string2;
        return Package.Companion.create(project, PackageType.maven, $this$toPackage.getCoordinates().getGroupId(), name, version);
    }

    @Nullable
    public static final PackageDeclaration toModelPackageDeclaration(@NotNull DeclaredDependency $this$toModelPackageDeclaration, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$toModelPackageDeclaration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Package package_ = JavaPackageUtilKt.toPackage($this$toModelPackageDeclaration.getUnifiedDependency(), project);
        if (package_ == null) {
            return null;
        }
        Package pkg = package_;
        return new PackageDeclaration(pkg, $this$toModelPackageDeclaration.getPsiElement(), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<Package, List<Package>> rootDependencies(@NotNull Project project, @NotNull ProjectDependencies projectDependencies) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectDependencies, (String)"projectDependencies");
        List list = projectDependencies.getComponentsDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getComponentsDependencies(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ComponentDependencies it = (ComponentDependencies)element$iv$iv;
            boolean bl = false;
            List list2 = it.getCompileDependenciesGraph().getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDependencies(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return JavaPackageUtilKt.rootDependencies((List)destination$iv$iv, arg_0 -> JavaPackageUtilKt.rootDependencies$lambda$1(project, arg_0), JavaPackageUtilKt::rootDependencies$lambda$2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Map<Package, List<Package>> rootDependencies(@NotNull List<? extends T> rootNodes, @NotNull Function1<? super T, Package> pkgMapper, @NotNull Function1<? super T, ? extends List<? extends T>> getChildren) {
        Intrinsics.checkNotNullParameter(rootNodes, (String)"rootNodes");
        Intrinsics.checkNotNullParameter(pkgMapper, (String)"pkgMapper");
        Intrinsics.checkNotNullParameter(getChildren, (String)"getChildren");
        Logger logger = Logger.getInstance((String)loggerCategory);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        HashMap result = new HashMap();
        for (T dependency : rootNodes) {
            Package rootPackage = (Package)pkgMapper.invoke(dependency);
            if (rootPackage == null) {
                logger2.debug("Fail to parse package from " + dependency);
                continue;
            }
            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00072\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"com/intellij/packageChecker/java/JavaPackageUtilKt$rootDependencies$GraphIterator", "Lcom/intellij/packageChecker/java/AbstractObjectGraphIterator;", "dependencies", "", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/util/List;)V", "getChildren", "", "t", "(Ljava/lang/Object;)Ljava/util/Collection;", "intellij.packageChecker.java"})
            public final class GraphIterator
            extends AbstractObjectGraphIterator<T> {
                final /* synthetic */ Function1<T, List<T>> $getChildren;

                public GraphIterator(Function1<? super T, ? extends List<? extends T>> $getChildren, List<? extends T> dependencies) {
                    Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
                    this.$getChildren = $getChildren;
                    super((Collection)dependencies);
                }

                public Collection<? extends T> getChildren(T t) {
                    return CollectionsKt.toMutableList((Collection)((Collection)this.$getChildren.invoke(t)));
                }
            }
            List children = SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)new GraphIterator(getChildren, (List)getChildren.invoke(dependency))));
            for (Object child : children) {
                Object object;
                void $this$getOrPut$iv;
                Package childPackage = (Package)pkgMapper.invoke(child);
                if (childPackage == null) {
                    logger2.debug("Fail to parse package from " + child);
                    continue;
                }
                Map map2 = result;
                Package key$iv = childPackage;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new LinkedList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(rootPackage);
            }
        }
        return result;
    }

    @Nullable
    public static final Package createPackage(@NotNull Library $this$createPackage, @NotNull Project project) {
        Library library;
        Object $this$createPackage_u24lambda_u244;
        Intrinsics.checkNotNullParameter((Object)$this$createPackage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Logger logger = Logger.getInstance((String)loggerCategory);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        Library library2 = $this$createPackage;
        try {
            $this$createPackage_u24lambda_u244 = library2;
            boolean bl = false;
            Package pkg = JavaPackageUtilKt.getPackageFromLibraryName($this$createPackage_u24lambda_u244, project);
            if (pkg == null) {
                pkg = JavaPackageUtilKt.getPackageFromLibraryDescriptor($this$createPackage_u24lambda_u244, project);
            }
            if (logger2.isDebugEnabled() && pkg == null) {
                logger2.debug("cannot create package from library with presentableName: " + $this$createPackage_u24lambda_u244.getPresentableName());
            }
            $this$createPackage_u24lambda_u244 = Result.constructor-impl((Object)pkg);
        }
        catch (Throwable bl) {
            $this$createPackage_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        library2 = $this$createPackage_u24lambda_u244;
        Throwable throwable = Result.exceptionOrNull-impl((Object)library2);
        if (throwable == null) {
            library = library2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            logger2.warn(e);
            library = null;
        }
        return (Package)library;
    }

    private static final Package getPackageFromLibraryName(Library $this$getPackageFromLibraryName, Project project) {
        Package package_;
        String[] stringArray;
        List splitLibName;
        String string = $this$getPackageFromLibraryName.getName();
        if (string == null) {
            String string2 = $this$getPackageFromLibraryName.getPresentableName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableName(...)");
        }
        if ((splitLibName = StringsKt.split$default((CharSequence)string, (String[])(stringArray = new String[]{":"}), (boolean)false, (int)0, (int)6, null)).size() == 4) {
            String type = (String)splitLibName.get(0);
            String namespace = (String)splitLibName.get(1);
            String name = (String)splitLibName.get(2);
            String version = (String)splitLibName.get(3);
            PackageType packageType = packageTypes.get(type);
            if (packageType != null) {
                PackageType packageType2 = packageType;
                boolean bl = false;
                package_ = Package.Companion.create(project, packageType2, ((Object)StringsKt.trim((CharSequence)namespace)).toString(), ((Object)StringsKt.trim((CharSequence)name)).toString(), ((Object)StringsKt.trim((CharSequence)version)).toString());
            } else {
                package_ = null;
            }
        } else {
            package_ = null;
        }
        return package_;
    }

    private static final Package getPackageFromLibraryDescriptor(Library $this$getPackageFromLibraryDescriptor, Project project) {
        Package package_;
        RepositoryLibraryProperties repositoryLibraryProperties;
        LibraryEx libraryEx = $this$getPackageFromLibraryDescriptor instanceof LibraryEx ? (LibraryEx)$this$getPackageFromLibraryDescriptor : null;
        if (libraryEx == null) {
            return null;
        }
        LibraryEx libraryEx2 = libraryEx;
        if (libraryEx2.isDisposed()) {
            return null;
        }
        LibraryProperties libraryProperties = libraryEx2.getProperties();
        RepositoryLibraryProperties repositoryLibraryProperties2 = repositoryLibraryProperties = libraryProperties instanceof RepositoryLibraryProperties ? (RepositoryLibraryProperties)libraryProperties : null;
        if (repositoryLibraryProperties != null && (libraryProperties = repositoryLibraryProperties.getRepositoryLibraryDescriptor()) != null) {
            LibraryProperties it = libraryProperties;
            boolean bl = false;
            if (it.getGroupId() == null || it.getArtifactId() == null || it.getVersion() == null) {
                package_ = null;
            } else {
                String string = it.getGroupId();
                String string2 = it.getArtifactId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getArtifactId(...)");
                String string3 = it.getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
                package_ = Package.Companion.create(project, PackageType.maven, string, string2, string3);
            }
        } else {
            package_ = null;
        }
        return package_;
    }

    @Nullable
    public static final Package createMavenPackage(@NotNull DependencyNode $this$createMavenPackage, @NotNull Project project) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$createMavenPackage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object2 = $this$createMavenPackage;
        try {
            DependencyNode $this$createMavenPackage_u24lambda_u248 = object2;
            boolean bl = false;
            if (!($this$createMavenPackage_u24lambda_u248 instanceof ArtifactDependencyNode)) {
                return null;
            }
            String string = ((ArtifactDependencyNode)$this$createMavenPackage_u24lambda_u248).getGroup();
            String string2 = ((ArtifactDependencyNode)$this$createMavenPackage_u24lambda_u248).getModule();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getModule(...)");
            String string3 = ((ArtifactDependencyNode)$this$createMavenPackage_u24lambda_u248).getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
            object = Result.constructor-impl((Object)Package.Companion.create(project, PackageType.maven, string, string2, string3));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Package)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @NotNull
    public static final List<LibraryDependency> javaLibraryDependencies(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (module.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        List groupBy = new ArrayList();
        ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary(arg_0 -> JavaPackageUtilKt.javaLibraryDependencies$lambda$10(arg_0 -> JavaPackageUtilKt.javaLibraryDependencies$lambda$9(groupBy, arg_0), arg_0));
        return groupBy;
    }

    private static final Package rootDependencies$lambda$1(Project $project, DependencyNode node) {
        Intrinsics.checkNotNull((Object)node);
        return JavaPackageUtilKt.createMavenPackage(node, $project);
    }

    private static final List rootDependencies$lambda$2(DependencyNode it) {
        Object object = it;
        if (object == null || (object = object.getDependencies()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final boolean javaLibraryDependencies$lambda$9(List $groupBy, Library lib) {
        Intrinsics.checkNotNull((Object)lib);
        return $groupBy.add(new JavaLibraryDependency(lib));
    }

    private static final boolean javaLibraryDependencies$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Maven", (Object)((Object)PackageType.maven)), TuplesKt.to((Object)"Gradle", (Object)((Object)PackageType.maven)), TuplesKt.to((Object)"Amper", (Object)((Object)PackageType.maven))};
        packageTypes = MapsKt.mapOf((Pair[])pairArray);
    }
}

