/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.common.CodeWithMeCommonBundle;
import com.intellij.cwm.plugin.common.icons.CwmPluginCommonIcons;
import com.intellij.cwm.plugin.common.ui.CWMConnectionDialog;
import com.intellij.cwm.plugin.common.ui.UserInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.platform.RdConstants;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 42\u00020\u0001:\u00014B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0013J\b\u0010\u001d\u001a\u00020\u001bH\u0004J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0014J\n\u0010 \u001a\u0004\u0018\u00010!H\u0014J\r\u0010\"\u001a\u00070#\u00a2\u0006\u0002\b$H\u0016J\b\u0010%\u001a\u00020\u0005H\u0016J\b\u0010&\u001a\u00020\u001bH\u0016J\b\u0010'\u001a\u00020\u001bH\u0014J\b\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020)H\u0014J\u001c\u0010+\u001a\u00020\u001b2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010-H\u0016J\b\u0010/\u001a\u00020!H\u0016J&\u00100\u001a\u00020\u00052\n\b\u0001\u00101\u001a\u0004\u0018\u00010\u00052\b\u00102\u001a\u0004\u0018\u00010\u00052\u0006\u00103\u001a\u00020\u0013H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0017\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/cwm/plugin/common/ui/CWMBaseAcceptUserDialog;", "Lcom/intellij/cwm/plugin/common/ui/CWMConnectionDialog;", "project", "Lcom/intellij/openapi/project/Project;", "userName", "", "Lcom/intellij/openapi/util/NlsSafe;", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/codeWithMe/ClientId;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getUserName", "()Ljava/lang/String;", "getClientId", "()Lcom/intellij/codeWithMe/ClientId;", "result", "Ljava/util/concurrent/CompletableFuture;", "", "getResult", "()Ljava/util/concurrent/CompletableFuture;", "wasInitialized", "nameText", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "Lcom/intellij/openapi/util/NlsContexts$Label;", "setUndecorated", "", "undecorated", "init", "show", "onClose", "getExtraComponent", "Ljavax/swing/JComponent;", "getIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getSecurityMessage", "doCancelAction", "doOKAction", "getOKAction", "Ljavax/swing/Action;", "getCancelAction", "renderUserInfoPanel", "localUserInfo", "Lcom/intellij/cwm/plugin/common/ui/UserInfo;", "remoteUserInfo", "createMiddlePane", "getNameText", "name", "email", "verified", "Companion", "intellij.cwm.plugin.common"})
public class CWMBaseAcceptUserDialog
extends CWMConnectionDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String userName;
    @NotNull
    private final ClientId clientId;
    @NotNull
    private final CompletableFuture<Boolean> result;
    private boolean wasInitialized;
    @NotNull
    private final GraphProperty<String> nameText;
    private static final int INNER_TOP_GAP = 12;

    public CWMBaseAcceptUserDialog(@NotNull Project project, @NotNull String userName, @NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        this.project = project;
        this.userName = userName;
        this.clientId = clientId;
        this.result = new CompletableFuture();
        this.nameText = this.getProperties().property((Object)this.getNameText(this.userName, null, false));
        this.setTitle(CodeWithMeCommonBundle.INSTANCE.message("connection.dialog.title", new Object[0]));
        this.setModal(false);
        this.setUndecorated(false);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final String getUserName() {
        return this.userName;
    }

    @NotNull
    protected final ClientId getClientId() {
        return this.clientId;
    }

    @NotNull
    public final CompletableFuture<Boolean> getResult() {
        return this.result;
    }

    public final void setUndecorated(boolean undecorated) {
        super.setUndecorated(undecorated);
    }

    protected final void init() {
        super.init();
    }

    @Override
    public void show() {
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.wasInitialized) {
            this.wasInitialized = true;
            this.init();
        }
        super.show();
    }

    protected void onClose() {
    }

    @Nullable
    protected JComponent getExtraComponent() {
        return null;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = CwmPluginCommonIcons.CodeWithMeProduct_64;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"CodeWithMeProduct_64");
        return icon;
    }

    @Override
    @NotNull
    public String getSecurityMessage() {
        return CodeWithMeCommonBundle.INSTANCE.message("connection.message.verify.the.code", new Object[0]);
    }

    public void doCancelAction() {
        this.onClose();
        this.result.complete(false);
        super.doCancelAction();
    }

    protected void doOKAction() {
        this.onClose();
        this.result.complete(true);
        super.doOKAction();
    }

    @NotNull
    protected Action getOKAction() {
        Action action2;
        Action action3 = super.getOKAction();
        Intrinsics.checkNotNullExpressionValue((Object)action3, (String)"getOKAction(...)");
        Action $this$getOKAction_u24lambda_u240 = action2 = action3;
        boolean bl = false;
        $this$getOKAction_u24lambda_u240.putValue("Name", CodeWithMeCommonBundle.INSTANCE.message("notification.access.accept", new Object[0]));
        return action2;
    }

    @NotNull
    protected Action getCancelAction() {
        Action action2;
        Action action3 = super.getCancelAction();
        Intrinsics.checkNotNullExpressionValue((Object)action3, (String)"getCancelAction(...)");
        Action $this$getCancelAction_u24lambda_u241 = action2 = action3;
        boolean bl = false;
        $this$getCancelAction_u24lambda_u241.putValue("Name", CodeWithMeCommonBundle.INSTANCE.message("notification.access.decline", new Object[0]));
        return action2;
    }

    @Override
    public void renderUserInfoPanel(@Nullable UserInfo localUserInfo, @Nullable UserInfo remoteUserInfo) {
        if (remoteUserInfo == null) {
            return;
        }
        this.nameText.set((Object)this.getNameText(remoteUserInfo.getName(), remoteUserInfo.getEmail(), true));
        DialogPanel content = BuilderKt.panel(arg_0 -> CWMBaseAcceptUserDialog.renderUserInfoPanel$lambda$4(remoteUserInfo, arg_0));
        this.getCurrentUserInfoPanel().setContent((JComponent)content);
    }

    @Override
    @NotNull
    public JComponent createMiddlePane() {
        JComponent extra = this.getExtraComponent();
        return (JComponent)BuilderKt.panel(arg_0 -> CWMBaseAcceptUserDialog.createMiddlePane$lambda$7(extra, this, arg_0));
    }

    private final String getNameText(@NlsSafe String name, String email, boolean verified) {
        HtmlBuilder builder = new HtmlBuilder();
        List texts = new ArrayList();
        if (name != null) {
            HtmlChunk.Element element = HtmlChunk.text((String)name).bold();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"bold(...)");
            texts.add(element);
        }
        if (email != null) {
            HtmlChunk.Element element = HtmlChunk.text((String)String.valueOf(email)).wrapWith(HtmlChunk.font((String)ColorUtil.toHtmlColor((Color)UIUtil.getContextHelpForeground())));
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"wrapWith(...)");
            texts.add(element);
        }
        if (texts.isEmpty()) {
            HtmlChunk.Element element = HtmlChunk.text((String)this.userName).bold();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"bold(...)");
            texts.add(element);
        }
        builder.append((HtmlChunk)CollectionsKt.first((List)texts));
        if (verified) {
            builder.append(HtmlChunk.nbsp()).append((HtmlChunk)HtmlChunk.icon((String)"AllIcons.CodeWithMe.CwmVerified", (Icon)AllIcons.CodeWithMe.CwmVerified));
        }
        HtmlChunk htmlChunk = (HtmlChunk)CollectionsKt.getOrNull((List)texts, (int)1);
        if (htmlChunk != null) {
            HtmlChunk it = htmlChunk;
            boolean bl = false;
            builder.appendRaw("&#32;").append(it);
        }
        builder.appendRaw("&#32;");
        Object[] objectArray = new Object[1];
        String string = this.project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        CharSequence charSequence = string;
        Regex regex = RdConstants.INSTANCE.getNotAllowedNameCharactersRegex();
        String string2 = "_";
        objectArray[0] = regex.replace(charSequence, string2);
        builder.append(CodeWithMeCommonBundle.INSTANCE.message("connection.dialog.message", objectArray));
        String string3 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    private static final Unit renderUserInfoPanel$lambda$4$lambda$3$lambda$2(String $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{$it};
        $this$row.label(CodeWithMeCommonBundle.INSTANCE.message("session.token.organization", objectArray)).customize(UnscaledGapsKt.UnscaledGaps$default((int)12, (int)0, (int)0, (int)0, (int)14, null));
        return Unit.INSTANCE;
    }

    private static final Unit renderUserInfoPanel$lambda$4(UserInfo $remoteUserInfo, Panel $this$panel) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            String string = $remoteUserInfo.getOrganization();
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            Panel.row$default((Panel)$this$panel, null, arg_0 -> CWMBaseAcceptUserDialog.renderUserInfoPanel$lambda$4$lambda$3$lambda$2(it, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createMiddlePane$lambda$7$lambda$5(CWMBaseAcceptUserDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.bindText((Cell)Row.text$default((Row)$this$row, (String)((String)this$0.nameText.get()), (int)43, null, (int)4, null), (ObservableMutableProperty)((ObservableMutableProperty)this$0.nameText)).resizableColumn();
        return Unit.INSTANCE;
    }

    private static final Unit createMiddlePane$lambda$7$lambda$6(JComponent $extra, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell($extra).customize(UnscaledGapsKt.UnscaledGaps$default((int)12, (int)0, (int)12, (int)0, (int)10, null));
        return Unit.INSTANCE;
    }

    private static final Unit createMiddlePane$lambda$7(JComponent $extra, CWMBaseAcceptUserDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CWMBaseAcceptUserDialog.createMiddlePane$lambda$7$lambda$5(this$0, arg_0), (int)1, null);
        if ($extra != null) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> CWMBaseAcceptUserDialog.createMiddlePane$lambda$7$lambda$6($extra, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/cwm/plugin/common/ui/CWMBaseAcceptUserDialog$Companion;", "", "<init>", "()V", "INNER_TOP_GAP", "", "intellij.cwm.plugin.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

