/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.intentions.PyTypeHintGenerationUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMakeFunctionReturnTypeQuickFix
extends PsiUpdateModCommandAction<PyFunction> {
    private final String myReturnTypeName;

    public PyMakeFunctionReturnTypeQuickFix(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)function);
        this.myReturnTypeName = PyMakeFunctionReturnTypeQuickFix.getReturnTypeName(function, context);
    }

    @NotNull
    private static String getReturnTypeName(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        Ref<PyType> unwrappedType;
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(3);
        }
        PyType type2 = function.getInferredReturnType(context);
        if (function.isAsync() && (unwrappedType = PyTypingTypeProvider.unwrapCoroutineReturnType(type2)) != null) {
            type2 = (PyType)unwrappedType.get();
        }
        String string = PythonDocumentationProvider.getTypeHint(type2, context);
        if (string == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PyFunction function) {
        if (context == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(5);
        }
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(6);
        }
        return Presentation.of((String)PyPsiBundle.message("QFIX.make.function.return.type", function.getName(), this.myReturnTypeName));
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.make.function.return.type", new Object[0]);
        if (string == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PyFunction function, @NotNull ModPsiUpdater updater) {
        PsiComment typeComment;
        PyExpression annotationExpr;
        if (context == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(8);
        }
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(9);
        }
        if (updater == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(10);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(function.getProject());
        boolean shouldAddImports = false;
        PyAnnotation annotation = function.getAnnotation();
        if (annotation != null && (annotationExpr = annotation.getValue()) != null) {
            annotationExpr.replace((PsiElement)elementGenerator.createExpressionFromText(LanguageLevel.PYTHON34, this.myReturnTypeName));
            shouldAddImports = true;
        }
        if ((typeComment = function.getTypeComment()) != null) {
            StringBuilder typeCommentAnnotation = new StringBuilder(typeComment.getText());
            typeCommentAnnotation.delete(typeCommentAnnotation.indexOf("->"), typeCommentAnnotation.length());
            typeCommentAnnotation.append("-> ").append(this.myReturnTypeName);
            typeComment.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.PYTHON27, PsiComment.class, typeCommentAnnotation.toString()));
            shouldAddImports = true;
        }
        if (shouldAddImports) {
            PyMakeFunctionReturnTypeQuickFix.addImportsForTypeAnnotations(function);
        }
    }

    private static void addImportsForTypeAnnotations(@NotNull PyFunction function) {
        PsiFile file;
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(11);
        }
        if ((file = function.getContainingFile()) == null) {
            return;
        }
        TypeEvalContext context = TypeEvalContext.userInitiated(function.getProject(), file);
        PyType typeForImports = function.getInferredReturnType(context);
        if (typeForImports != null) {
            PyTypeHintGenerationUtil.addImportsForTypeAnnotations(List.of(typeForImports), context, file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionReturnTypeQuickFix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionReturnTypeQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnTypeName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeName";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addImportsForTypeAnnotations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7 -> new IllegalStateException(string);
        };
    }
}

