/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.annotation;

import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.Keyword;
import com.networknt.schema.path.NodePath;
import java.util.Objects;

public class Annotation {
    private final String keyword;
    private final NodePath instanceLocation;
    private final SchemaLocation schemaLocation;
    private final NodePath evaluationPath;
    private final Object value;
    private boolean valid = true;

    public Annotation(String keyword, NodePath instanceLocation, SchemaLocation schemaLocation, NodePath evaluationPath, Object value) {
        this.keyword = keyword;
        this.instanceLocation = instanceLocation;
        this.schemaLocation = schemaLocation;
        this.evaluationPath = evaluationPath;
        this.value = value;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public NodePath getInstanceLocation() {
        return this.instanceLocation;
    }

    public SchemaLocation getSchemaLocation() {
        return this.schemaLocation;
    }

    public NodePath getEvaluationPath() {
        return this.evaluationPath;
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String toString() {
        return "Annotation [evaluationPath=" + this.evaluationPath + ", schemaLocation=" + this.schemaLocation + ", instanceLocation=" + this.instanceLocation + ", keyword=" + this.keyword + ", value=" + this.value + "]";
    }

    public int hashCode() {
        return Objects.hash(this.evaluationPath, this.instanceLocation, this.keyword, this.schemaLocation, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Annotation other = (Annotation)obj;
        return Objects.equals(this.evaluationPath, other.evaluationPath) && Objects.equals(this.instanceLocation, other.instanceLocation) && Objects.equals(this.keyword, other.keyword) && Objects.equals(this.schemaLocation, other.schemaLocation) && Objects.equals(this.value, other.value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String keyword;
        private NodePath instanceLocation;
        private SchemaLocation schemaLocation;
        private NodePath evaluationPath;
        private Object value;

        public Builder keyword(Keyword keyword) {
            this.keyword = keyword.getValue();
            return this;
        }

        public Builder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public Builder instanceLocation(NodePath instanceLocation) {
            this.instanceLocation = instanceLocation;
            return this;
        }

        public Builder schemaLocation(SchemaLocation schemaLocation) {
            this.schemaLocation = schemaLocation;
            return this;
        }

        public Builder evaluationPath(NodePath evaluationPath) {
            this.evaluationPath = evaluationPath;
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public Annotation build() {
            return new Annotation(this.keyword, this.instanceLocation, this.schemaLocation, this.evaluationPath, this.value);
        }
    }
}

