/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttBinaryData;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.datatypes.MqttClientIdentifier;
import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class MqttClientIdentifierImpl
extends MqttUtf8StringImpl
implements MqttClientIdentifier {
    @NotNull
    public static final MqttClientIdentifierImpl REQUEST_CLIENT_IDENTIFIER_FROM_SERVER = new MqttClientIdentifierImpl(new byte[0]);
    private static final int MUST_BE_ALLOWED_BY_SERVER_MIN_BYTES = 1;
    private static final int MUST_BE_ALLOWED_BY_SERVER_MAX_BYTES = 23;

    @Contract(value="null -> fail")
    @NotNull
    public static MqttClientIdentifierImpl of(@Nullable String string) {
        Checks.notNull(string, "Client identifier");
        MqttClientIdentifierImpl.checkLength(string, "Client identifier");
        MqttClientIdentifierImpl.checkWellFormed(string, "Client identifier");
        return new MqttClientIdentifierImpl(string);
    }

    @Nullable
    public static MqttClientIdentifierImpl of(byte @NotNull [] binary) {
        return !MqttBinaryData.isInRange(binary) || MqttClientIdentifierImpl.isWellFormed(binary) ? null : new MqttClientIdentifierImpl(binary);
    }

    @Nullable
    public static MqttClientIdentifierImpl decode(@NotNull ByteBuf byteBuf) {
        byte[] binary = MqttBinaryData.decode(byteBuf);
        return binary == null ? null : MqttClientIdentifierImpl.of(binary);
    }

    private MqttClientIdentifierImpl(byte @NotNull [] binary) {
        super(binary);
    }

    private MqttClientIdentifierImpl(@NotNull String string) {
        super(string);
    }

    @Override
    public boolean mustBeAllowedByServer() {
        byte[] binary = this.toBinary();
        int length = binary.length;
        if (length < 1 || length > 23) {
            return false;
        }
        for (byte b : binary) {
            if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57) continue;
            return false;
        }
        return true;
    }
}

