/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.AbstractDirectory;
import brut.directory.DirectoryException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public final class FileDirectory
extends AbstractDirectory {
    public final File mDir;

    public FileDirectory(File file) {
        if (file.isDirectory()) {
            this.mDir = file;
            return;
        }
        throw new DirectoryException("file must be a directory: " + file);
    }

    @Override
    public final long getSize(String string) {
        File file;
        File file2 = file;
        if (new File(this.generatePath(string)).isFile()) {
            return file2.length();
        }
        throw new DirectoryException("file must be a file: " + file2);
    }

    @Override
    public final AbstractDirectory createDirLocal(String string) {
        File file;
        File file2 = file;
        new File(this.generatePath(string)).mkdirs();
        return new FileDirectory(file2);
    }

    @Override
    public final InputStream getFileInputLocal(String string) {
        try {
            return Files.newInputStream(new File(this.generatePath(string)).toPath(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            throw new DirectoryException(iOException);
        }
    }

    @Override
    public final OutputStream getFileOutputLocal(String string) {
        try {
            return Files.newOutputStream(new File(this.generatePath(string)).toPath(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            throw new DirectoryException(iOException);
        }
    }

    @Override
    public final void loadDirs() {
        this.loadAll();
    }

    @Override
    public final void loadFiles() {
        this.loadAll();
    }

    @Override
    public final void removeFileLocal(String string) {
        new File(this.generatePath(string)).delete();
    }

    public final String generatePath(String string) {
        return this.mDir.getPath() + '/' + string;
    }

    public final void loadAll() {
        this.mFiles = new LinkedHashSet();
        this.mDirs = new LinkedHashMap();
        File[] fileArray = this.mDir.listFiles();
        Arrays.sort(fileArray, Comparator.comparing(File::getName));
        for (File file : fileArray) {
            if (file.isFile()) {
                this.mFiles.add(file.getName());
                continue;
            }
            try {
                this.mDirs.put(file.getName(), new FileDirectory(file));
            }
            catch (DirectoryException directoryException) {}
        }
    }
}

