/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;

public class VisibleWhitespaceToken
extends Token {
    private Rectangle2D.Float dotRect;

    public VisibleWhitespaceToken() {
        this.dotRect = new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
    }

    public VisibleWhitespaceToken(Segment segment, int n, int n2, int n3, int n4) {
        this(segment.array, n, n2, n3, n4);
    }

    public VisibleWhitespaceToken(char[] cArray, int n, int n2, int n3, int n4) {
        super(cArray, n, n2, n3, n4);
    }

    public int getListOffset(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f, float f2) {
        if (f >= f2) {
            return this.offset;
        }
        float f3 = f;
        float f4 = f;
        float f5 = f;
        int n = this.offset;
        FontMetrics fontMetrics = null;
        for (Token token = this; token != null && token.isPaintable(); token = token.getNextToken()) {
            fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(token.type);
            char[] cArray = token.text;
            int n2 = token.textOffset;
            int n3 = n2 + token.textCount;
            for (int i = n2; i < n3; ++i) {
                f3 = f4;
                switch (cArray[i]) {
                    case '\t': {
                        f5 = f4 = tabExpander.nextTabStop(f4, 0);
                        n2 = i + 1;
                        break;
                    }
                    case ' ': {
                        f5 = f4 = f5 + (float)fontMetrics.charsWidth(cArray, n2, i - n2 + 1);
                        n2 = i + 1;
                        break;
                    }
                    default: {
                        f4 = f5 + (float)fontMetrics.charsWidth(cArray, n2, i - n2 + 1);
                    }
                }
                if (!(f2 >= f3) || !(f2 < f4)) continue;
                if (f2 - f3 < f4 - f2) {
                    return n + i - token.textOffset;
                }
                return n + i + 1 - token.textOffset;
            }
            f5 = f4;
            n += token.textCount;
        }
        return n;
    }

    public float getWidthUpTo(int n, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f) {
        float f2 = f;
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(this.type);
        if (fontMetrics != null) {
            int n2;
            int n3 = this.textOffset;
            int n4 = this.textOffset + n;
            block4: for (int i = n3; i < n4; ++i) {
                switch (this.text[i]) {
                    case '\t': {
                        n2 = i - n3;
                        if (n2 > 0) {
                            f2 += (float)fontMetrics.charsWidth(this.text, n3, n2);
                        }
                        n3 = i + 1;
                        f2 = tabExpander.nextTabStop(f2, 0);
                        continue block4;
                    }
                    case ' ': {
                        n2 = i - n3 + 1;
                        f2 += (float)fontMetrics.charsWidth(this.text, n3, n2);
                        n3 = i + 1;
                        continue block4;
                    }
                }
            }
            n2 = n4 - n3;
            f2 += (float)fontMetrics.charsWidth(this.text, n3, n2);
        }
        return f2 - f;
    }

    public Rectangle listOffsetToView(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, int n, int n2, Rectangle rectangle) {
        float f = n2;
        int n3 = this.offset;
        FontMetrics fontMetrics = null;
        for (Token token = this; token != null && token.isPaintable(); token = token.getNextToken()) {
            int n4;
            fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(token.type);
            char[] cArray = token.text;
            int n5 = token.textOffset;
            int n6 = n5 + token.textCount;
            if (token.containsPosition(n)) {
                n6 = n5 + (n - token.offset);
                block9: for (n4 = n5; n4 < n6; ++n4) {
                    switch (cArray[n4]) {
                        case '\t': {
                            f += (float)fontMetrics.charsWidth(cArray, n5, n4 - n5 + 1);
                            f = tabExpander.nextTabStop(f, 0);
                            n5 = n4 + 1;
                            continue block9;
                        }
                        case ' ': {
                            f += (float)fontMetrics.charsWidth(cArray, n5, n4 - n5 + 1);
                            n5 = n4 + 1;
                            continue block9;
                        }
                    }
                }
                int n7 = fontMetrics.charsWidth(cArray, n5, n4 - n5);
                rectangle.x = (int)f + n7;
                rectangle.width = cArray[n4] == '\t' ? fontMetrics.charWidth(' ') : fontMetrics.charsWidth(cArray, n5, n4 - n5 + 1) - n7;
                return rectangle;
            }
            block10: for (n4 = n5; n4 < n6; ++n4) {
                switch (cArray[n4]) {
                    case '\t': {
                        f += (float)fontMetrics.charsWidth(cArray, n5, n4 - n5 + 1);
                        f = tabExpander.nextTabStop(f, 0);
                        n5 = n4 + 1;
                        continue block10;
                    }
                    case ' ': {
                        f += (float)fontMetrics.charsWidth(cArray, n5, n4 - n5 + 1);
                        n5 = n4 + 1;
                        continue block10;
                    }
                }
            }
            f += (float)fontMetrics.charsWidth(cArray, n5, n4 - n5);
            n3 += token.textCount;
        }
        rectangle.x = (int)f;
        rectangle.width = 1;
        return rectangle;
    }

    public void makeStartAt(int n) {
        if (n < this.offset || n >= this.offset + this.textCount) {
            throw new IllegalArgumentException("pos not in range " + this.offset + "-" + (this.offset + this.textCount - 1));
        }
        int n2 = n - this.offset;
        this.offset = n;
        this.textOffset += n2;
        this.textCount -= n2;
    }

    public final float paint(Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f3) {
        int n;
        int n2 = (int)f;
        int n3 = this.textOffset + this.textCount;
        float f4 = f;
        int n4 = 0;
        int n5 = this.textOffset;
        Color color = rSyntaxTextArea.getForegroundForTokenType(this.type);
        Color color2 = rSyntaxTextArea.getBackgroundForTokenType(this.type);
        graphics2D.setFont(rSyntaxTextArea.getFontForTokenType(this.type));
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(this.type);
        int n6 = fontMetrics.getAscent();
        int n7 = fontMetrics.getHeight();
        block4: for (n = this.textOffset; n < n3; ++n) {
            switch (this.text[n]) {
                case '\t': {
                    f4 = f + (float)fontMetrics.charsWidth(this.text, n5, n4);
                    float f5 = tabExpander.nextTabStop(f4, 0);
                    if (color2 != null) {
                        this.paintBackground(f, f2, f5 - f, n7, graphics2D, n6, rSyntaxTextArea, color2);
                    }
                    graphics2D.setColor(color);
                    if (n4 > 0) {
                        graphics2D.drawString(new String(this.text, n5, n4), f, f2);
                        n4 = 0;
                    }
                    n5 = n + 1;
                    int n8 = n7 / 2;
                    int n9 = n8 / 2;
                    int n10 = (int)f2 - n6 + n8;
                    graphics2D.drawLine((int)f4, n10, (int)f5, n10);
                    graphics2D.drawLine((int)f5, n10, (int)f5 - 4, n10 - n9);
                    graphics2D.drawLine((int)f5, n10, (int)f5 - 4, n10 + n9);
                    f = f5;
                    continue block4;
                }
                case ' ': {
                    f4 = f + (float)fontMetrics.charsWidth(this.text, n5, n4 + 1);
                    int n11 = fontMetrics.charWidth(' ');
                    if (color2 != null) {
                        this.paintBackground(f, f2, f4 - f, n7, graphics2D, n6, rSyntaxTextArea, color2);
                    }
                    graphics2D.setColor(color);
                    if (n4 > 0) {
                        graphics2D.drawString(new String(this.text, n5, n4), f, f2);
                        n4 = 0;
                    }
                    this.dotRect.x = f4 - (float)n11 / 2.0f;
                    this.dotRect.y = f2 - (float)n6 + (float)n7 / 2.0f;
                    graphics2D.fill(this.dotRect);
                    n5 = n + 1;
                    f = f4;
                    continue block4;
                }
                default: {
                    ++n4;
                }
            }
        }
        f4 = f + (float)fontMetrics.charsWidth(this.text, n5, n4);
        if (n4 > 0 && f4 >= f3) {
            if (color2 != null) {
                this.paintBackground(f, f2, f4 - f, n7, graphics2D, n6, rSyntaxTextArea, color2);
            }
            graphics2D.setColor(color);
            graphics2D.drawString(new String(this.text, n5, n4), f, f2);
        }
        if (rSyntaxTextArea.getUnderlineForTokenType(this.type)) {
            graphics2D.setColor(color);
            n = (int)(f2 + 1.0f);
            graphics2D.drawLine(n2, n, (int)f4, n);
        }
        return f4;
    }
}

