/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.history.ActivityId;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import git4idea.GitActivity;
import git4idea.GitReference;
import git4idea.GitUtil;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitSmartOperationDialog;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineEventDetector;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMergeCommittingConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.util.GitPreservingProcess;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class GitMergeOperation
extends GitBranchOperation {
    private static final Logger LOG = Logger.getInstance(GitMergeOperation.class);
    @NotNull
    @NlsSafe
    private final String myBranchNameToMerge;
    @NotNull
    private final GitReference myReferenceToMerge;
    private final GitBrancher.DeleteOnMergeOption myDeleteOnMerge;
    @NotNull
    private final Map<GitRepository, Boolean> myConflictedRepositories;
    private GitPreservingProcess myPreservingProcess;

    GitMergeOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<? extends GitRepository> repositories, @NotNull GitReference referenceToMerge, GitBrancher.DeleteOnMergeOption deleteOnMerge) {
        if (project == null) {
            GitMergeOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitMergeOperation.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitMergeOperation.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitMergeOperation.$$$reportNull$$$0(3);
        }
        if (referenceToMerge == null) {
            GitMergeOperation.$$$reportNull$$$0(4);
        }
        super(project, git, uiHandler, repositories);
        this.myConflictedRepositories = new HashMap<GitRepository, Boolean>();
        this.myReferenceToMerge = referenceToMerge;
        this.myBranchNameToMerge = referenceToMerge.getName();
        this.myDeleteOnMerge = deleteOnMerge;
    }

    @Override
    protected void execute() {
        LOG.info("starting");
        GitMergeOperation.saveAllDocuments();
        boolean fatalErrorHappened = false;
        int alreadyUpToDateRepositories = 0;
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)GitBundle.message("activity.name.merge", new Object[0]), (ActivityId)GitActivity.Merge);){
            while (this.hasMoreRepositories() && !fatalErrorHappened) {
                GitRepository repository2 = this.next();
                LOG.info("next repository: " + String.valueOf(repository2));
                RepositoryMergeResult repoResult2 = this.mergeRepository(repository2, this.myBranchNameToMerge, Collections.emptyList());
                if (repoResult2.alreadyUpToDateRepository) {
                    ++alreadyUpToDateRepositories;
                }
                if (!repoResult2.fatalErrorHappened) continue;
                fatalErrorHappened = true;
            }
            if (fatalErrorHappened) {
                this.notifyAboutRemainingConflicts();
            } else {
                boolean allConflictsResolved = this.resolveConflicts();
                if (allConflictsResolved) {
                    if (alreadyUpToDateRepositories < this.getRepositories().size()) {
                        this.notifySuccess();
                    } else {
                        this.notifySuccess(GitBundle.message("merge.operation.already.up.to.date", new Object[0]));
                    }
                }
            }
            this.restoreLocalChanges();
        }
    }

    @NotNull
    private RepositoryMergeResult mergeRepository(@NotNull GitRepository repository2, @NotNull String branchToMerge, @NotNull List<String> mergeParams) {
        if (repository2 == null) {
            GitMergeOperation.$$$reportNull$$$0(5);
        }
        if (branchToMerge == null) {
            GitMergeOperation.$$$reportNull$$$0(6);
        }
        if (mergeParams == null) {
            GitMergeOperation.$$$reportNull$$$0(7);
        }
        boolean fatalErrorHappened = false;
        boolean alreadyUpToDateRepository = false;
        VirtualFile root = repository2.getRoot();
        Hash startHash = GitUtil.getHead(repository2);
        GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
        GitSimpleEventDetector unmergedFiles = new GitSimpleEventDetector(GitSimpleEventDetector.Event.UNMERGED_PREVENTING_MERGE);
        GitUntrackedFilesOverwrittenByOperationDetector untrackedOverwrittenByMerge = new GitUntrackedFilesOverwrittenByOperationDetector(root);
        GitSimpleEventDetector mergeConflict = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT);
        GitSimpleEventDetector alreadyUpToDateDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.ALREADY_UP_TO_DATE);
        MyAmbiguousNameDetector ambiguousReferenceDetector = new MyAmbiguousNameDetector();
        GitCommandResult result2 = this.myGit.merge(repository2, branchToMerge, mergeParams, localChangesDetector, unmergedFiles, untrackedOverwrittenByMerge, mergeConflict, alreadyUpToDateDetector, ambiguousReferenceDetector);
        String fullName = this.myReferenceToMerge.getFullName();
        if (ambiguousReferenceDetector.isDetected() && !branchToMerge.equals(fullName)) {
            return this.mergeRepository(repository2, fullName, mergeParams);
        }
        if (result2.success()) {
            LOG.info("Merged successfully");
            GitUtil.updateAndRefreshChangedVfs(repository2, startHash);
            this.markSuccessful(repository2);
            if (alreadyUpToDateDetector.isDetected()) {
                alreadyUpToDateRepository = true;
            }
        } else if (unmergedFiles.isDetected()) {
            LOG.info("Unmerged files error!");
            this.fatalUnmergedFilesError();
            fatalErrorHappened = true;
        } else if (localChangesDetector.isDetected()) {
            LOG.info("Local changes would be overwritten by merge!");
            boolean smartMergeSucceeded = this.proposeSmartMergePerformAndNotify(repository2, localChangesDetector);
            if (!smartMergeSucceeded) {
                fatalErrorHappened = true;
            }
        } else if (mergeConflict.isDetected()) {
            LOG.info("Merge conflict");
            this.myConflictedRepositories.put(repository2, Boolean.FALSE);
            GitUtil.updateAndRefreshChangedVfs(repository2, startHash);
            this.markSuccessful(repository2);
        } else if (untrackedOverwrittenByMerge.isDetected()) {
            LOG.info("Untracked files would be overwritten by merge!");
            this.fatalUntrackedFilesError(repository2.getRoot(), untrackedOverwrittenByMerge.getRelativeFilePaths());
            fatalErrorHappened = true;
        } else {
            LOG.info("Unknown error. " + String.valueOf(result2));
            this.fatalError(this.getCommonErrorTitle(), result2);
            fatalErrorHappened = true;
        }
        return new RepositoryMergeResult(fatalErrorHappened, alreadyUpToDateRepository);
    }

    private void notifyAboutRemainingConflicts() {
        if (!this.myConflictedRepositories.isEmpty()) {
            new MyMergeConflictResolver().notifyUnresolvedRemain();
        }
    }

    @Override
    protected void notifySuccess(@NotNull @Nls String message) {
        if (message == null) {
            GitMergeOperation.$$$reportNull$$$0(8);
        }
        switch (this.myDeleteOnMerge) {
            case DELETE: {
                super.notifySuccess(message);
                new GitBranchWorker(this.myProject, this.myGit, this.myUiHandler).deleteBranch(this.myBranchNameToMerge, new ArrayList<GitRepository>(this.getRepositories()));
                break;
            }
            case PROPOSE: {
                VcsNotifier.toolWindowNotification().createNotification("", new HtmlBuilder().appendRaw(message).toString(), NotificationType.INFORMATION).setDisplayId("git.delete.branch.on.merge").addAction((AnAction)NotificationAction.createSimpleExpiring((String)GitBundle.message("merge.operation.delete.branch.action", this.myBranchNameToMerge), () -> GitBrancher.getInstance(this.myProject).deleteBranch(this.myBranchNameToMerge, new ArrayList<GitRepository>(this.getRepositories())))).notify(this.myProject);
                break;
            }
            case NOTHING: {
                super.notifySuccess(message);
            }
        }
    }

    private boolean resolveConflicts() {
        if (!this.myConflictedRepositories.isEmpty()) {
            return new MyMergeConflictResolver().merge();
        }
        return true;
    }

    private boolean proposeSmartMergePerformAndNotify(@NotNull GitRepository repository2, @NotNull GitMessageWithFilesDetector localChangesOverwrittenByMerge) {
        Collection<String> absolutePaths;
        if (repository2 == null) {
            GitMergeOperation.$$$reportNull$$$0(9);
        }
        if (localChangesOverwrittenByMerge == null) {
            GitMergeOperation.$$$reportNull$$$0(10);
        }
        Pair<List<GitRepository>, List<Change>> conflictingRepositoriesAndAffectedChanges = this.getConflictingRepositoriesAndAffectedChanges(repository2, localChangesOverwrittenByMerge, (String)this.myCurrentHeads.get(repository2), this.myBranchNameToMerge);
        List allConflictingRepositories = (List)conflictingRepositoriesAndAffectedChanges.getFirst();
        List affectedChanges = (List)conflictingRepositoriesAndAffectedChanges.getSecond();
        GitSmartOperationDialog.Choice decision = this.myUiHandler.showSmartOperationDialog(this.myProject, affectedChanges, absolutePaths = GitUtil.toAbsolute(repository2.getRoot(), localChangesOverwrittenByMerge.getRelativeFilePaths()), GitBundle.message("merge.operation.name", new Object[0]), null);
        if (decision == GitSmartOperationDialog.Choice.SMART) {
            return this.doSmartMerge(allConflictingRepositories);
        }
        this.fatalLocalChangesError(this.myBranchNameToMerge);
        return false;
    }

    private void restoreLocalChanges() {
        if (this.myPreservingProcess != null) {
            this.myPreservingProcess.load();
        }
    }

    private boolean doSmartMerge(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitMergeOperation.$$$reportNull$$$0(11);
        }
        AtomicBoolean success2 = new AtomicBoolean();
        GitSaveChangesPolicy saveMethod = GitVcsSettings.getInstance(this.myProject).getSaveChangesPolicy();
        this.myPreservingProcess = new GitPreservingProcess(this.myProject, this.myGit, GitUtil.getRootsFromRepositories(repositories), GitBundle.message("merge.operation.name", new Object[0]), this.myBranchNameToMerge, saveMethod, this.getIndicator(), () -> success2.set(this.doMerge(repositories)));
        this.myPreservingProcess.execute((Computable<Boolean>)((Computable)this.myConflictedRepositories::isEmpty));
        return success2.get();
    }

    private boolean doMerge(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitMergeOperation.$$$reportNull$$$0(12);
        }
        for (GitRepository gitRepository : repositories) {
            Hash startHash = GitUtil.getHead(gitRepository);
            GitSimpleEventDetector mergeConflict = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT);
            GitCommandResult result2 = this.myGit.merge(gitRepository, this.myReferenceToMerge.getFullName(), Collections.emptyList(), mergeConflict);
            if (!result2.success()) {
                if (mergeConflict.isDetected()) {
                    this.myConflictedRepositories.put(gitRepository, Boolean.TRUE);
                    GitUtil.updateAndRefreshChangedVfs(gitRepository, startHash);
                    this.markSuccessful(gitRepository);
                    continue;
                }
                this.fatalError(this.getCommonErrorTitle(), result2);
                return false;
            }
            GitUtil.updateAndRefreshChangedVfs(gitRepository, startHash);
            this.markSuccessful(gitRepository);
        }
        return true;
    }

    @NlsContexts.NotificationTitle
    @NotNull
    private String getCommonErrorTitle() {
        String string = GitBundle.message("merge.operation.could.not.merge.branch", this.myBranchNameToMerge);
        if (string == null) {
            GitMergeOperation.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    protected void rollback() {
        LOG.info("starting rollback...");
        ArrayList<GitRepository> repositoriesForSmartRollback = new ArrayList<GitRepository>();
        ArrayList<GitRepository> repositoriesForSimpleRollback = new ArrayList<GitRepository>();
        ArrayList<GitRepository> repositoriesForMergeRollback = new ArrayList<GitRepository>();
        for (GitRepository repository2 : this.getSuccessfulRepositories()) {
            if (this.myConflictedRepositories.containsKey(repository2)) {
                repositoriesForMergeRollback.add(repository2);
                continue;
            }
            if (GitMergeOperation.thereAreLocalChangesIn(repository2)) {
                repositoriesForSmartRollback.add(repository2);
                continue;
            }
            repositoriesForSimpleRollback.add(repository2);
        }
        LOG.info("for smart rollback: " + DvcsUtil.getShortNames(repositoriesForSmartRollback) + "; for simple rollback: " + DvcsUtil.getShortNames(repositoriesForSimpleRollback) + "; for merge rollback: " + DvcsUtil.getShortNames(repositoriesForMergeRollback));
        GitCompoundResult result2 = this.smartRollback(repositoriesForSmartRollback);
        for (GitRepository repository3 : repositoriesForSimpleRollback) {
            result2.append(repository3, this.rollback(repository3));
        }
        for (GitRepository repository3 : repositoriesForMergeRollback) {
            result2.append(repository3, this.rollbackMerge(repository3));
        }
        this.myConflictedRepositories.clear();
        if (!result2.totalSuccess()) {
            VcsNotifier.getInstance((Project)this.myProject).notifyError("git.merge.rollback.error", GitBundle.message("merge.operation.error.during.rollback", new Object[0]), result2.getErrorOutputWithReposIndication(), true);
        }
        LOG.info("rollback finished.");
    }

    @NotNull
    private GitCompoundResult smartRollback(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitMergeOperation.$$$reportNull$$$0(14);
        }
        LOG.info("Starting smart rollback...");
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        Collection<VirtualFile> roots = GitUtil.getRootsFromRepositories(repositories);
        GitSaveChangesPolicy saveMethod = GitVcsSettings.getInstance(this.myProject).getSaveChangesPolicy();
        GitPreservingProcess preservingProcess = new GitPreservingProcess(this.myProject, this.myGit, roots, GitBundle.message("merge.operation.name", new Object[0]), this.myBranchNameToMerge, saveMethod, this.getIndicator(), () -> {
            for (GitRepository repository2 : repositories) {
                result2.append(repository2, this.rollback(repository2));
            }
        });
        preservingProcess.execute();
        LOG.info("Smart rollback completed.");
        GitCompoundResult gitCompoundResult = result2;
        if (gitCompoundResult == null) {
            GitMergeOperation.$$$reportNull$$$0(15);
        }
        return gitCompoundResult;
    }

    @NotNull
    private GitCommandResult rollback(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitMergeOperation.$$$reportNull$$$0(16);
        }
        GitCommandResult gitCommandResult = this.myGit.reset(repository2, GitResetMode.HARD, this.getInitialRevision(repository2), new GitLineHandlerListener[0]);
        if (gitCommandResult == null) {
            GitMergeOperation.$$$reportNull$$$0(17);
        }
        return gitCommandResult;
    }

    @NotNull
    private GitCommandResult rollbackMerge(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitMergeOperation.$$$reportNull$$$0(18);
        }
        Hash startHash = GitUtil.getHead(repository2);
        GitCommandResult result2 = this.myGit.resetMerge(repository2, null);
        GitUtil.updateAndRefreshChangedVfs(repository2, startHash);
        GitCommandResult gitCommandResult = result2;
        if (gitCommandResult == null) {
            GitMergeOperation.$$$reportNull$$$0(19);
        }
        return gitCommandResult;
    }

    private static boolean thereAreLocalChangesIn(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitMergeOperation.$$$reportNull$$$0(20);
        }
        return !repository2.getStagingAreaHolder().isEmpty();
    }

    @Override
    @NotNull
    protected String getSuccessMessage() {
        String string = GitBundle.message("merge.operation.merged.to", GitUIUtil.code(this.myBranchNameToMerge), GitUIUtil.code(GitMergeOperation.stringifyBranchesByRepos(this.myCurrentHeads)));
        if (string == null) {
            GitMergeOperation.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        String string = new HtmlBuilder().append(GitBundle.message("merge.operation.however.merge.has.succeeded.for.the.following.repositories", this.getSuccessfulRepositories().size())).br().appendRaw(this.successfulRepositoriesJoined()).br().append(GitBundle.message("merge.operation.you.may.rollback.not.to.let.branches.diverge", new Object[0])).toString();
        if (string == null) {
            GitMergeOperation.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls
    protected String getOperationName() {
        String string = GitBundle.message("merge.operation.name", new Object[0]);
        if (string == null) {
            GitMergeOperation.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 15, 17, 19, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceToMerge";
                break;
            }
            case 5: 
            case 9: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchToMerge";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeParams";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localChangesOverwrittenByMerge";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitMergeOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitMergeOperation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonErrorTitle";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "smartRollback";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "rollback";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "rollbackMerge";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessMessage";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackProposal";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeRepository";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "notifySuccess";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "proposeSmartMergePerformAndNotify";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doSmartMerge";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doMerge";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "smartRollback";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "rollback";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "rollbackMerge";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "thereAreLocalChangesIn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 15, 17, 19, 21, 22, 23 -> new IllegalStateException(string);
        };
    }

    private record RepositoryMergeResult(boolean fatalErrorHappened, boolean alreadyUpToDateRepository) {
    }

    private static class MyAmbiguousNameDetector
    implements GitLineEventDetector {
        @NotNull
        private static final Pattern PATTERN = Pattern.compile("warning: refname '.*' is ambiguous\\.");
        private boolean myHappened = false;

        private MyAmbiguousNameDetector() {
        }

        @Override
        public void onLineAvailable(@NlsSafe String line, Key outputType) {
            Matcher matcher = PATTERN.matcher(line);
            if (matcher.matches()) {
                this.myHappened = true;
            }
        }

        @Override
        public boolean isDetected() {
            return this.myHappened;
        }
    }

    private class MyMergeConflictResolver
    extends GitMergeCommittingConflictResolver {
        MyMergeConflictResolver() {
            super(GitMergeOperation.this.myProject, GitUtil.getRootsFromRepositories(GitMergeOperation.this.myConflictedRepositories.keySet()), new GitConflictResolver.Params(GitMergeOperation.this.myProject), true);
        }

        @Override
        protected void notifyUnresolvedRemain() {
            this.notifyWarning(GitBundle.message("merge.operation.branch.merged.with.conflicts", GitMergeOperation.this.myBranchNameToMerge), "");
        }
    }
}

