/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.LockOwner;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.TableNameInfo;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;
import org.apache.derby.vti.VTITemplate;

public class LockTable
extends VTITemplate
implements VTICosting {
    public static final int LATCH = 1;
    public static final int TABLE_AND_ROWLOCK = 2;
    public static final int ALL = -1;
    private TransactionController tc;
    private Hashtable currentRow;
    private Enumeration lockTable;
    private boolean wasNull;
    private boolean initialized;
    private final int flag;
    private TableNameInfo tabInfo;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("XID", 12, false, 15), EmbedResultSetMetaData.getResultColumnDescriptor("TYPE", 12, true, 5), EmbedResultSetMetaData.getResultColumnDescriptor("MODE", 12, false, 4), EmbedResultSetMetaData.getResultColumnDescriptor("TABLENAME", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("LOCKNAME", 12, false, 20), EmbedResultSetMetaData.getResultColumnDescriptor("STATE", 12, true, 5), EmbedResultSetMetaData.getResultColumnDescriptor("TABLETYPE", 12, false, 9), EmbedResultSetMetaData.getResultColumnDescriptor("LOCKCOUNT", 12, false, 5), EmbedResultSetMetaData.getResultColumnDescriptor("INDEXNAME", 12, true, 128)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public LockTable() {
        this.flag = 2;
    }

    public LockTable(int flag) {
        this.flag = flag;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            if (!this.initialized) {
                LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
                this.tc = lcc.getTransactionExecute();
                LockFactory lf = this.tc.getAccessManager().getLockFactory();
                this.lockTable = lf.makeVirtualLockTable();
                this.initialized = true;
                this.tabInfo = new TableNameInfo(lcc, true);
            }
            this.currentRow = null;
            if (this.lockTable != null) {
                while (this.lockTable.hasMoreElements() && this.currentRow == null) {
                    this.currentRow = this.dumpLock((Latch)this.lockTable.nextElement());
                }
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException((StandardException)se);
        }
        return this.currentRow != null;
    }

    @Override
    public void close() {
        this.lockTable = null;
    }

    @Override
    public String getString(int columnNumber) {
        String val = (String)this.currentRow.get(columnInfo[columnNumber - 1].getName());
        this.wasNull = val == null;
        return val;
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public double getEstimatedRowCount(VTIEnvironment vtiEnvironment) {
        return 10000.0;
    }

    @Override
    public double getEstimatedCostPerInstantiation(VTIEnvironment vtiEnvironment) {
        return 100000.0;
    }

    @Override
    public boolean supportsMultipleInstantiations(VTIEnvironment vtiEnvironment) {
        return false;
    }

    private Hashtable<String, Object> dumpLock(Latch lock) throws StandardException {
        String state;
        Hashtable<String, Object> attributes = new Hashtable<String, Object>(17);
        Object lock_type = lock.getQualifier();
        Lockable lockable = lock.getLockable();
        if (!lockable.lockAttributes(this.flag, attributes)) {
            return null;
        }
        SanityManager.ASSERT((attributes.get("LOCKNAME") != null ? 1 : 0) != 0, (String)"lock table can only represent locks that have a LOCKNAME");
        SanityManager.ASSERT((attributes.get("TYPE") != null ? 1 : 0) != 0, (String)"lock table can only represent locks that have a LOCKTYPE");
        if (attributes.get("CONTAINERID") == null && attributes.get("CONGLOMID") == null) {
            SanityManager.THROWASSERT((String)"lock table can only represent locks that are associated with a container or conglomerate");
        }
        if (attributes.get("LOCKNAME") == null || attributes.get("TYPE") == null) {
            return null;
        }
        int lockCount = lock.getCount();
        if (lockCount != 0) {
            state = "GRANT";
        } else {
            if (!(lock instanceof ActiveLock)) {
                return null;
            }
            state = "WAIT";
        }
        Long conglomId = (Long)attributes.get("CONGLOMID");
        if (conglomId == null) {
            if (attributes.get("CONTAINERID") == null) {
                return null;
            }
            Long value = (Long)attributes.get("CONTAINERID");
            conglomId = this.tc.findConglomid(value);
            attributes.put("CONGLOMID", conglomId);
        }
        attributes.put("LOCKOBJ", lock);
        LockOwner owner = lock.getCompatabilitySpace().getOwner();
        attributes.put("XID", owner == null ? "<null>" : owner.toString());
        attributes.put("MODE", lock_type.toString());
        attributes.put("LOCKCOUNT", Integer.toString(lockCount));
        attributes.put("STATE", state);
        String tableName = this.tabInfo.getTableName(conglomId);
        attributes.put("TABLENAME", tableName);
        String indexName = this.tabInfo.getIndexName(conglomId);
        if (indexName != null) {
            attributes.put("INDEXNAME", indexName);
        }
        String tableType = this.tabInfo.getTableType(conglomId);
        attributes.put("TABLETYPE", tableType);
        return attributes;
    }
}

