/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.xplain;

import java.sql.SQLException;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINFactoryIF;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.execute.xplain.XPLAINDefaultVisitor;
import org.apache.derby.impl.sql.execute.xplain.XPLAINSystemTableVisitor;
import org.apache.derby.shared.common.error.StandardException;

public class XPLAINFactory
implements XPLAINFactoryIF {
    private XPLAINVisitor currentVisitor = new XPLAINDefaultVisitor();
    private String currentSchema = null;

    @Override
    public XPLAINVisitor getXPLAINVisitor() throws StandardException {
        try {
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            String schema = lcc.getXplainSchema();
            if (schema != this.currentSchema) {
                this.currentSchema = schema;
                this.currentVisitor = this.currentSchema == null ? new XPLAINDefaultVisitor() : new XPLAINSystemTableVisitor();
            }
        }
        catch (SQLException e) {
            throw StandardException.plainWrapException((Throwable)e);
        }
        return this.currentVisitor;
    }

    @Override
    public void freeResources() {
        this.currentVisitor = null;
        this.currentSchema = null;
    }
}

