/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.sf.mpxj.fasttrack.AbstractColumn;
import net.sf.mpxj.fasttrack.FastTrackUtility;
import net.sf.mpxj.fasttrack.FixedSizeItemsBlock;

class DateColumn
extends AbstractColumn {
    private static final long DATE_EPOCH = 315446400000L;

    DateColumn() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 0;
    }

    @Override
    protected int readData(byte[] byArray, int n) {
        n += 6;
        n += 4;
        n = FastTrackUtility.skipToNextMatchingShort(byArray, n, 10) - 2;
        FixedSizeItemsBlock fixedSizeItemsBlock = new FixedSizeItemsBlock().read(byArray, n);
        n = fixedSizeItemsBlock.getOffset();
        Calendar calendar = Calendar.getInstance();
        byte[][] byArray2 = fixedSizeItemsBlock.getData();
        this.m_data = new Date[byArray2.length];
        for (int i = 0; i < byArray2.length; ++i) {
            int n2;
            byte[] byArray3 = byArray2[i];
            if (byArray3 == null || byArray3.length < 4 || (n2 = FastTrackUtility.getInt(byArray3, 0)) <= 0) continue;
            calendar.setTimeInMillis(315446400000L);
            calendar.add(6, n2);
            this.m_data[i] = calendar.getTime();
        }
        return n;
    }

    @Override
    protected void dumpData(PrintWriter printWriter) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        printWriter.println("  [Data");
        for (Object object : this.m_data) {
            String string = object == null ? "" : simpleDateFormat.format((Date)object);
            printWriter.println("    " + String.valueOf(string));
        }
        printWriter.println("  ]");
    }
}

