/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.ast.PyAstFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface PyAnnotatorBase {
    @ApiStatus.Internal
    public static void runAnnotators(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder, PyAnnotatorBase[] annotators) {
        if (psiElement == null) {
            PyAnnotatorBase.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            PyAnnotatorBase.$$$reportNull$$$0(1);
        }
        PsiFile file = holder.getCurrentAnnotationSession().getFile();
        for (PyAnnotatorBase annotator : annotators) {
            if (file instanceof PyAstFile && !((PyAstFile)file).isAcceptedFor(annotator.getClass())) continue;
            annotator.annotateElement(psiElement, holder);
        }
    }

    @ApiStatus.Internal
    public boolean isTestMode();

    public AnnotationHolder getHolder();

    public void annotateElement(PsiElement var1, AnnotationHolder var2);

    @ApiStatus.Internal
    default public void markError(@NotNull PsiElement element, @NotNull @InspectionMessage String message) {
        if (element == null) {
            PyAnnotatorBase.$$$reportNull$$$0(2);
        }
        if (message == null) {
            PyAnnotatorBase.$$$reportNull$$$0(3);
        }
        this.getHolder().newAnnotation(HighlightSeverity.ERROR, message).range(element).create();
    }

    @ApiStatus.Internal
    default public void addHighlightingAnnotation(@NotNull PsiElement target, @NotNull TextAttributesKey key) {
        if (target == null) {
            PyAnnotatorBase.$$$reportNull$$$0(4);
        }
        if (key == null) {
            PyAnnotatorBase.$$$reportNull$$$0(5);
        }
        this.addHighlightingAnnotation(target, key, HighlightInfoType.SYMBOL_TYPE_SEVERITY);
    }

    @ApiStatus.Internal
    default public void addHighlightingAnnotation(@NotNull PsiElement target, @NotNull TextAttributesKey key, @NotNull HighlightSeverity severity) {
        if (target == null) {
            PyAnnotatorBase.$$$reportNull$$$0(6);
        }
        if (key == null) {
            PyAnnotatorBase.$$$reportNull$$$0(7);
        }
        if (severity == null) {
            PyAnnotatorBase.$$$reportNull$$$0(8);
        }
        String message = this.isTestMode() ? key.getExternalName() : null;
        HighlightSeverity actualSeverity = this.isTestMode() && severity.myVal < HighlightSeverity.INFORMATION.myVal ? HighlightSeverity.INFORMATION : severity;
        (message == null ? this.getHolder().newSilentAnnotation(actualSeverity) : this.getHolder().newAnnotation(actualSeverity, message)).range(target).textAttributes(key).create();
    }

    @ApiStatus.Internal
    default public void addHighlightingAnnotation(@NotNull ASTNode target, @NotNull TextAttributesKey key) {
        if (target == null) {
            PyAnnotatorBase.$$$reportNull$$$0(9);
        }
        if (key == null) {
            PyAnnotatorBase.$$$reportNull$$$0(10);
        }
        this.addHighlightingAnnotation(target.getPsi(), key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/PyAnnotatorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runAnnotators";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "markError";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addHighlightingAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

