/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;

public class ResourceResolverWrappingURIResolver
implements ResourceResolver {
    private final URIResolver uriResolver;

    public ResourceResolverWrappingURIResolver(URIResolver uriResolver) {
        Objects.requireNonNull(uriResolver);
        this.uriResolver = uriResolver;
    }

    @Override
    public Source resolve(ResourceRequest request) throws XPathException {
        String href;
        if (request.relativeUri != null && request.baseUri != null) {
            href = request.relativeUri;
        } else if (request.uri != null) {
            href = request.uri;
        } else {
            return null;
        }
        try {
            Source resolved = this.uriResolver.resolve(href, request.baseUri);
            if ("https://www.iana.org/assignments/media-types/text/plain".equals(request.nature) && resolved instanceof SAXSource && ((SAXSource)resolved).getInputSource() != null) {
                resolved = ResourceResolverWrappingURIResolver.convertToStreamSource((SAXSource)resolved);
            }
            return resolved;
        }
        catch (TransformerException e) {
            throw XPathException.makeXPathException(e);
        }
    }

    public static StreamSource convertToStreamSource(SAXSource resolved) {
        InputSource is = resolved.getInputSource();
        StreamSource ss = new StreamSource();
        ss.setInputStream(is.getByteStream());
        ss.setReader(is.getCharacterStream());
        ss.setSystemId(is.getSystemId());
        ss.setPublicId(is.getPublicId());
        if (is.getEncoding() != null && is.getByteStream() != null && is.getCharacterStream() == null) {
            try {
                ss.setReader(new InputStreamReader(is.getByteStream(), is.getEncoding()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return ss;
    }

    public URIResolver getWrappedURIResolver() {
        return this.uriResolver;
    }
}

