/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.ModifierFormat;
import net.sf.freecol.client.gui.label.UnitLabel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;

public class WorkProductionPanel
extends FreeColPanel {
    private final Turn turn = this.getGame().getTurn();

    public WorkProductionPanel(FreeColClient freeColClient, Unit unit) {
        super(freeColClient, null, new MigLayout("wrap 3, insets 10 10 10 10", "[]30:push[right][]", ""));
        ImageLibrary lib = this.getImageLibrary();
        Colony colony = unit.getColony();
        UnitType unitType = unit.getType();
        WorkLocation wl = (WorkLocation)unit.getLocation();
        GoodsType workType = unit.getWorkType();
        String shortName = "";
        String longName = "";
        BufferedImage image = null;
        float result = wl.getBaseProduction(wl.getProductionType(), workType, unitType);
        Tile tile = wl.getWorkTile();
        if (tile != null) {
            TileType tileType = tile.getType();
            shortName = Messages.getName(tileType);
            longName = Messages.message(wl.getLabel());
            image = this.getGUI().createColonyTileImage(tile, colony);
        } else {
            Building building = (Building)wl;
            longName = shortName = Messages.getName(building.getType());
            image = lib.getScaledBuildingImage(building);
        }
        this.add((Component)new JLabel(longName), "span, align center, wrap 30");
        this.add(new JLabel(new ImageIcon(image)));
        this.add((Component)new UnitLabel(this.getFreeColClient(), unit), "wrap");
        this.add(new JLabel(shortName));
        this.add(new JLabel(ModifierFormat.format(result)));
        this.output(CollectionUtils.sort(wl.getProductionModifiers(workType, unitType), Modifier.ascendingModifierIndexComparator), unitType);
        result = wl.getPotentialProduction(workType, unitType);
        if (result < 0.0f) {
            this.add((Component)Utility.localizedLabel("workProductionPanel.zeroThreshold"), "newline");
            this.add((Component)new JLabel(ModifierFormat.format(-result)), "wrap 30");
            result = 0.0f;
        }
        Font bigFont = lib.getScaledFont("normal-bold-smaller", null);
        JLabel finalLabel = Utility.localizedLabel("finalResult");
        finalLabel.setFont(bigFont);
        this.add((Component)finalLabel, "newline");
        JLabel finalResult = new JLabel(ModifierFormat.format(result));
        finalResult.setFont(bigFont);
        finalResult.setBorder(Utility.getProductionBorder());
        this.add((Component)finalResult, "wrap 30");
        result = wl.getBaseProduction(null, workType, null);
        if (wl instanceof Building && result > 0.0f) {
            Font boldFont = FontLibrary.getUnscaledFont("normal-bold-tiny");
            JLabel unattendedLabel = Utility.localizedLabel("workProductionPanel.unattendedProduction");
            unattendedLabel.setFont(boldFont);
            this.add((Component)unattendedLabel, "span");
            this.add(Utility.localizedLabel(wl.getLabel()));
            this.add(new JLabel(ModifierFormat.format(result)));
            this.output(CollectionUtils.sort(wl.getProductionModifiers(workType, null), Modifier.ascendingModifierIndexComparator), unitType);
        }
        this.add((Component)this.okButton, "newline, span, tag ok");
        this.setSize(this.getPreferredSize());
        this.setEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WorkProductionPanel.this.okButton.doClick();
            }
        });
    }

    private void output(List<Modifier> modifiers, UnitType unitType) {
        for (Modifier m : modifiers) {
            JLabel[] mLabels = ModifierFormat.getModifierLabels(m, unitType, this.turn);
            for (int i = 0; i < mLabels.length; ++i) {
                if (mLabels[i] == null) continue;
                if (i == 0) {
                    this.add((Component)mLabels[i], "newline");
                    continue;
                }
                this.add(mLabels[i]);
            }
        }
    }
}

