/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.concurrent.TimeoutException;

public class NetworkReplyObject {
    private static int ONE_SECOND = 1000;
    private final int networkReplyId;
    private Object response;
    private volatile boolean responseGiven;

    public NetworkReplyObject(int networkReplyId) {
        this.networkReplyId = networkReplyId;
        this.response = null;
        this.responseGiven = false;
    }

    public int getNetworkReplyId() {
        return this.networkReplyId;
    }

    public synchronized Object getResponse(long timeout) throws TimeoutException {
        long end = System.currentTimeMillis() + timeout;
        while (!this.responseGiven) {
            if (System.currentTimeMillis() > end) {
                throw new TimeoutException("The network request timed out: " + timeout);
            }
            try {
                this.wait(ONE_SECOND);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.response;
    }

    public synchronized void setResponse(Object response) {
        if (!this.responseGiven) {
            this.response = response;
            this.responseGiven = true;
            this.notifyAll();
        }
    }

    public void interrupt() {
        this.setResponse(null);
    }
}

