/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbBasicImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.BasicJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.ColumnJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.FormulaAnnotation;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class BasicAttributeProcessing {
    public static MutableMemberDetails processBasicAttribute(JaxbBasicImpl jaxbBasic, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbBasic.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbBasic.getName(), accessType, declarer);
        BasicJpaAnnotation basicAnn = (BasicJpaAnnotation)memberDetails.applyAnnotationUsage(JpaAnnotations.BASIC, xmlDocumentContext.getModelBuildingContext());
        CommonAttributeProcessing.applyAccess(accessType, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeAccessor(jaxbBasic, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyFetching(jaxbBasic, memberDetails, basicAnn, xmlDocumentContext);
        CommonAttributeProcessing.applyOptionality(jaxbBasic, basicAnn, xmlDocumentContext);
        CommonAttributeProcessing.applyOptimisticLock(jaxbBasic, memberDetails, xmlDocumentContext);
        if (StringHelper.isNotEmpty(jaxbBasic.getFormula())) {
            assert (jaxbBasic.getColumn() == null);
            FormulaAnnotation formulaAnn = (FormulaAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.FORMULA, xmlDocumentContext.getModelBuildingContext());
            formulaAnn.value(jaxbBasic.getFormula());
        } else if (jaxbBasic.getColumn() != null) {
            ColumnJpaAnnotation columnAnn = (ColumnJpaAnnotation)memberDetails.applyAnnotationUsage(JpaAnnotations.COLUMN, xmlDocumentContext.getModelBuildingContext());
            columnAnn.apply(jaxbBasic.getColumn(), xmlDocumentContext);
            XmlAnnotationHelper.applyColumnTransformation(jaxbBasic.getColumn(), memberDetails, xmlDocumentContext);
        }
        XmlAnnotationHelper.applyConvert(jaxbBasic.getConvert(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyBasicTypeComposition(jaxbBasic, memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyTemporal(jaxbBasic.getTemporal(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLob(jaxbBasic.getLob(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyEnumerated(jaxbBasic.getEnumerated(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyNationalized(jaxbBasic.getNationalized(), memberDetails, xmlDocumentContext);
        return memberDetails;
    }
}

