/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.attribute.ModuleAttribute;
import io.github.dmlloyd.classfile.attribute.ModuleExportInfo;
import io.github.dmlloyd.classfile.attribute.ModuleOpenInfo;
import io.github.dmlloyd.classfile.attribute.ModuleProvideInfo;
import io.github.dmlloyd.classfile.attribute.ModuleRequireInfo;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.constantpool.ModuleEntry;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.extras.constant.ModuleDesc;
import io.github.dmlloyd.classfile.extras.constant.PackageDesc;
import io.github.dmlloyd.classfile.impl.TemporaryConstantPool;
import io.github.dmlloyd.classfile.impl.UnboundAttribute;
import java.lang.constant.ClassDesc;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public final class ModuleAttributeBuilderImpl
implements ModuleAttribute.ModuleAttributeBuilder {
    private ModuleEntry moduleEntry;
    private Utf8Entry moduleVersion;
    private int moduleFlags;
    private final Set<ModuleRequireInfo> requires = new LinkedHashSet<ModuleRequireInfo>();
    private final Set<ModuleExportInfo> exports = new LinkedHashSet<ModuleExportInfo>();
    private final Set<ModuleOpenInfo> opens = new LinkedHashSet<ModuleOpenInfo>();
    private final Set<ClassEntry> uses = new LinkedHashSet<ClassEntry>();
    private final Set<ModuleProvideInfo> provides = new LinkedHashSet<ModuleProvideInfo>();

    public ModuleAttributeBuilderImpl(ModuleEntry moduleName) {
        this.moduleEntry = moduleName;
        this.moduleFlags = 0;
    }

    public ModuleAttributeBuilderImpl(ModuleDesc moduleName) {
        this(TemporaryConstantPool.INSTANCE.moduleEntry(TemporaryConstantPool.INSTANCE.utf8Entry(moduleName.name())));
    }

    public ModuleAttribute build() {
        return new UnboundAttribute.UnboundModuleAttribute(this.moduleEntry, this.moduleFlags, this.moduleVersion, this.requires, this.exports, this.opens, this.uses, this.provides);
    }

    @Override
    public ModuleAttribute.ModuleAttributeBuilder moduleName(ModuleDesc moduleName) {
        Objects.requireNonNull(moduleName);
        this.moduleEntry = TemporaryConstantPool.INSTANCE.moduleEntry(TemporaryConstantPool.INSTANCE.utf8Entry(moduleName.name()));
        return this;
    }

    @Override
    public ModuleAttribute.ModuleAttributeBuilder moduleFlags(int flags) {
        this.moduleFlags = flags;
        return this;
    }

    @Override
    public ModuleAttribute.ModuleAttributeBuilder moduleVersion(String version) {
        this.moduleVersion = version == null ? null : TemporaryConstantPool.INSTANCE.utf8Entry(version);
        return this;
    }

    @Override
    public ModuleAttribute.ModuleAttributeBuilder requires(ModuleDesc module, int flags, String version) {
        Objects.requireNonNull(module);
        return this.requires(ModuleRequireInfo.of(TemporaryConstantPool.INSTANCE.moduleEntry(TemporaryConstantPool.INSTANCE.utf8Entry(module.name())), flags, version == null ? null : TemporaryConstantPool.INSTANCE.utf8Entry(version)));
    }

    @Override
    public ModuleAttribute.ModuleAttributeBuilder requires(ModuleRequireInfo requires) {
        Objects.requireNonNull(requires);
        this.requires.add(requires);
        return this;
    }

    @Override
    public ModuleAttribute.ModuleAttributeBuilder exports(PackageDesc pkge, int flags, ModuleDesc ... exportsToModules) {
        Objects.requireNonNull(pkge);
        ArrayList<ModuleEntry> exportsTo = new ArrayList<ModuleEntry>(exportsToModules.length);
        for (ModuleDesc e : exportsToModules) {
            exportsTo.add(TemporaryConstantPool.INSTANCE.moduleEntry(TemporaryConstantPool.INSTANCE.utf8Entry(e.name())));
        }
        return this.exports(ModuleExportInfo.of(TemporaryConstantPool.INSTANCE.packageEntry(TemporaryConstantPool.INSTANCE.utf8Entry(pkge.internalName())), flags, exportsTo));
    }

    @Override
    public ModuleAttribute.ModuleAttributeBuilder exports(ModuleExportInfo exports) {
        Objects.requireNonNull(exports);
        this.exports.add(exports);
        return this;
    }

    @Override
    public ModuleAttribute.ModuleAttributeBuilder opens(PackageDesc pkge, int flags, ModuleDesc ... opensToModules) {
        Objects.requireNonNull(pkge);
        ArrayList<ModuleEntry> opensTo = new ArrayList<ModuleEntry>(opensToModules.length);
        for (ModuleDesc e : opensToModules) {
            opensTo.add(TemporaryConstantPool.INSTANCE.moduleEntry(TemporaryConstantPool.INSTANCE.utf8Entry(e.name())));
        }
        return this.opens(ModuleOpenInfo.of(TemporaryConstantPool.INSTANCE.packageEntry(TemporaryConstantPool.INSTANCE.utf8Entry(pkge.internalName())), flags, opensTo));
    }

    @Override
    public ModuleAttribute.ModuleAttributeBuilder opens(ModuleOpenInfo opens) {
        Objects.requireNonNull(opens);
        this.opens.add(opens);
        return this;
    }

    @Override
    public ModuleAttribute.ModuleAttributeBuilder uses(ClassDesc service) {
        Objects.requireNonNull(service);
        return this.uses(TemporaryConstantPool.INSTANCE.classEntry(service));
    }

    @Override
    public ModuleAttribute.ModuleAttributeBuilder uses(ClassEntry uses) {
        Objects.requireNonNull(uses);
        this.uses.add(uses);
        return this;
    }

    @Override
    public ModuleAttribute.ModuleAttributeBuilder provides(ClassDesc service, ClassDesc ... implClasses) {
        Objects.requireNonNull(service);
        ArrayList<ClassEntry> impls = new ArrayList<ClassEntry>(implClasses.length);
        for (ClassDesc seq : implClasses) {
            impls.add(TemporaryConstantPool.INSTANCE.classEntry(seq));
        }
        return this.provides(ModuleProvideInfo.of(TemporaryConstantPool.INSTANCE.classEntry(service), impls));
    }

    @Override
    public ModuleAttribute.ModuleAttributeBuilder provides(ModuleProvideInfo provides) {
        Objects.requireNonNull(provides);
        this.provides.add(provides);
        return this;
    }
}

