/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Id;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAttributesContainerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCachingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityOrMappedSuperclass;
import org.hibernate.boot.jaxb.mapping.spi.JaxbIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMappedSuperclassImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistentAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTenantIdImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.XmlAnnotations;
import org.hibernate.boot.models.annotations.internal.AccessJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.AttributeAccessorAnnotation;
import org.hibernate.boot.models.annotations.internal.CacheAnnotation;
import org.hibernate.boot.models.annotations.internal.CacheableJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.ExtendsXmlAnnotation;
import org.hibernate.boot.models.internal.ModelsHelper;
import org.hibernate.boot.models.xml.XmlProcessLogging;
import org.hibernate.boot.models.xml.internal.AttributeProcessor;
import org.hibernate.boot.models.xml.internal.DynamicModelHelper;
import org.hibernate.boot.models.xml.internal.EntityGraphProcessing;
import org.hibernate.boot.models.xml.internal.QueryProcessing;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.BasicAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.BasicIdAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.EmbeddedIdAttributeProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.boot.models.xml.spi.XmlProcessingResult;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.ModelsException;
import org.hibernate.models.internal.ClassTypeDetailsImpl;
import org.hibernate.models.internal.ModelsClassLogging;
import org.hibernate.models.internal.dynamic.DynamicClassDetails;
import org.hibernate.models.rendering.internal.RenderingTargetCollectingImpl;
import org.hibernate.models.rendering.internal.SimpleRenderer;
import org.hibernate.models.rendering.spi.RenderingTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;

public class ManagedTypeProcessor {
    public static void processCompleteEntity(JaxbEntityMappingsImpl jaxbRoot, JaxbEntityImpl jaxbEntity, XmlDocumentContext xmlDocumentContext) {
        MutableClassDetails classDetails;
        AccessType classAccessType;
        AttributeProcessor.MemberAdjuster memberAdjuster;
        ClassDetailsRegistry classDetailsRegistry = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry();
        if (StringHelper.isEmpty(jaxbEntity.getClazz())) {
            if (StringHelper.isEmpty(jaxbEntity.getName())) {
                throw new ModelsException("Assumed dynamic entity did not define entity-name");
            }
            memberAdjuster = ManagedTypeProcessor::adjustDynamicTypeMember;
            classAccessType = AccessType.FIELD;
            classDetails = (MutableClassDetails)ModelsHelper.resolveClassDetails(jaxbEntity.getName(), classDetailsRegistry, () -> {
                ClassTypeDetailsImpl superType;
                ClassDetails superClass;
                if (StringHelper.isEmpty(jaxbEntity.getExtends())) {
                    superClass = null;
                    superType = null;
                } else {
                    superClass = classDetailsRegistry.getClassDetails(jaxbEntity.getExtends());
                    superType = new ClassTypeDetailsImpl(superClass, TypeDetails.Kind.CLASS);
                }
                return new DynamicClassDetails(jaxbEntity.getName(), null, jaxbEntity.isAbstract() != null && jaxbEntity.isAbstract() != false, superClass, (TypeDetails)superType, xmlDocumentContext.getModelBuildingContext());
            });
            DynamicModelHelper.prepareDynamicClass(classDetails, jaxbEntity, xmlDocumentContext);
        } else {
            memberAdjuster = ManagedTypeProcessor::adjustCompleteNonDynamicTypeMember;
            String className = XmlProcessingHelper.determineClassName(jaxbRoot, jaxbEntity);
            classDetails = (MutableClassDetails)classDetailsRegistry.resolveClassDetails(className);
            classAccessType = NullnessHelper.coalesce(jaxbEntity.getAccess(), jaxbRoot.getAccess(), xmlDocumentContext.getEffectiveDefaults().getDefaultPropertyAccessType(), ManagedTypeProcessor.defaultAccessTypeFromDefaultAccessor(xmlDocumentContext), AccessType.PROPERTY);
            if (classDetails.isInterface()) {
                throw new MappingException("Only classes (not interfaces) may be mapped as @Entity : " + classDetails.getName());
            }
            classDetails.forEachPersistableMember(memberDetails -> {
                MutableMemberDetails mutableMemberDetails = (MutableMemberDetails)memberDetails;
                mutableMemberDetails.clearAnnotationUsages();
            });
        }
        classDetails.clearAnnotationUsages();
        ManagedTypeProcessor.processEntityMetadata(classDetails, jaxbEntity, classAccessType, memberAdjuster, jaxbRoot, xmlDocumentContext);
    }

    private static AccessType defaultAccessTypeFromDefaultAccessor(XmlDocumentContext xmlDocumentContext) {
        String defaultAccessStrategyName = xmlDocumentContext.getEffectiveDefaults().getDefaultAccessStrategyName();
        if (BuiltInPropertyAccessStrategies.BASIC.getExternalName().equalsIgnoreCase(defaultAccessStrategyName) || BuiltInPropertyAccessStrategies.BASIC.getStrategy().getClass().getName().equals(defaultAccessStrategyName)) {
            return AccessType.PROPERTY;
        }
        if (BuiltInPropertyAccessStrategies.FIELD.getExternalName().equalsIgnoreCase(defaultAccessStrategyName) || BuiltInPropertyAccessStrategies.FIELD.getStrategy().getClass().getName().equals(defaultAccessStrategyName)) {
            return AccessType.FIELD;
        }
        return null;
    }

    private static void adjustDynamicTypeMember(MutableMemberDetails memberDetails, JaxbPersistentAttribute jaxbAttribute, XmlDocumentContext xmlDocumentContext) {
        AttributeAccessorAnnotation annotationUsage = (AttributeAccessorAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.ATTRIBUTE_ACCESSOR, xmlDocumentContext.getModelBuildingContext());
        annotationUsage.value(BuiltInPropertyAccessStrategies.MAP.getExternalName());
    }

    private static void processEntityMetadata(MutableClassDetails classDetails, JaxbEntityImpl jaxbEntity, AccessType classAccessType, AttributeProcessor.MemberAdjuster memberAdjuster, JaxbEntityMappingsImpl jaxbRoot, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyEntity(jaxbEntity, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyInheritance(jaxbEntity, classDetails, xmlDocumentContext);
        ManagedTypeProcessor.applyAccessAnnotation(classAccessType, classDetails, xmlDocumentContext);
        ManagedTypeProcessor.applyCaching(jaxbEntity, classDetails, xmlDocumentContext);
        if (jaxbEntity.isAbstract() != null) {
            classDetails.applyAnnotationUsage(XmlAnnotations.ABSTRACT, xmlDocumentContext.getModelBuildingContext());
        }
        if (StringHelper.isNotEmpty(jaxbEntity.getExtends())) {
            ExtendsXmlAnnotation extendsAnn = (ExtendsXmlAnnotation)XmlAnnotations.EXTENDS.createUsage(xmlDocumentContext.getModelBuildingContext());
            extendsAnn.superType(jaxbEntity.getExtends());
        }
        XmlAnnotationHelper.applyTable(jaxbEntity.getTable(), (MutableAnnotationTarget)classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applySecondaryTables(jaxbEntity.getSecondaryTables(), (MutableAnnotationTarget)classDetails, xmlDocumentContext);
        JaxbAttributesContainerImpl attributes = jaxbEntity.getAttributes();
        if (attributes != null) {
            ManagedTypeProcessor.processIdMappings(attributes, classAccessType, classDetails, memberAdjuster, xmlDocumentContext);
            AttributeProcessor.processNaturalId(attributes.getNaturalId(), classDetails, classAccessType, memberAdjuster, xmlDocumentContext);
            AttributeProcessor.processAttributes(attributes, classDetails, classAccessType, memberAdjuster, xmlDocumentContext);
        }
        AttributeProcessor.processAttributeOverrides(jaxbEntity.getAttributeOverrides(), classDetails, xmlDocumentContext);
        AttributeProcessor.processAssociationOverrides(jaxbEntity.getAssociationOverrides(), classDetails, xmlDocumentContext);
        QueryProcessing.applyNamedQueries(jaxbEntity, classDetails, xmlDocumentContext);
        QueryProcessing.applyNamedNativeQueries(jaxbEntity, classDetails, jaxbRoot, xmlDocumentContext);
        QueryProcessing.applyNamedProcedureQueries(jaxbEntity, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyFilters(jaxbEntity.getFilters(), (MutableAnnotationTarget)classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applySqlRestriction(jaxbEntity.getSqlRestriction(), (MutableAnnotationTarget)classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbEntity.getSqlInsert(), (MutableAnnotationTarget)classDetails, HibernateAnnotations.SQL_INSERT, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbEntity.getSqlUpdate(), (MutableAnnotationTarget)classDetails, HibernateAnnotations.SQL_UPDATE, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbEntity.getSqlDelete(), (MutableAnnotationTarget)classDetails, HibernateAnnotations.SQL_DELETE, xmlDocumentContext);
        ManagedTypeProcessor.processEntityOrMappedSuperclass(jaxbEntity, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyRowId(jaxbEntity.getRowid(), classDetails, xmlDocumentContext);
        ManagedTypeProcessor.applyTenantId(classDetails, jaxbEntity, classAccessType, xmlDocumentContext);
        EntityGraphProcessing.applyEntityGraphs(jaxbEntity, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyDiscriminatorValue(jaxbEntity.getDiscriminatorValue(), classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyDiscriminatorColumn(jaxbEntity.getDiscriminatorColumn(), classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyDiscriminatorFormula(jaxbEntity.getDiscriminatorFormula(), classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyPrimaryKeyJoinColumns(jaxbEntity, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyTableGenerator(jaxbEntity.getTableGenerator(), (MutableAnnotationTarget)classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applySequenceGenerator(jaxbEntity.getSequenceGenerator(), (MutableAnnotationTarget)classDetails, xmlDocumentContext);
        ManagedTypeProcessor.renderClass(classDetails, xmlDocumentContext);
    }

    private static void renderClass(MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        if (!XmlProcessLogging.XML_PROCESS_LOGGER.isDebugEnabled()) {
            return;
        }
        RenderingTargetCollectingImpl collectingTarget = new RenderingTargetCollectingImpl();
        SimpleRenderer renderer = new SimpleRenderer((RenderingTarget)collectingTarget);
        renderer.renderClass((ClassDetails)classDetails, xmlDocumentContext.getModelBuildingContext());
        XmlProcessLogging.XML_PROCESS_LOGGER.tracef("Class annotations from XML for %s:\n%s", (Object)classDetails.getName(), (Object)collectingTarget.toString());
    }

    private static void applyAccessAnnotation(AccessType accessType, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        AccessJpaAnnotation annotationUsage = (AccessJpaAnnotation)((Object)target.applyAnnotationUsage(JpaAnnotations.ACCESS, xmlDocumentContext.getModelBuildingContext()));
        annotationUsage.value(accessType);
        target.addAnnotationUsage((Annotation)((Object)annotationUsage));
    }

    private static void applyCaching(JaxbEntityImpl jaxbEntity, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        JaxbCachingImpl jaxbCaching;
        if (jaxbEntity.isCacheable() != null) {
            CacheableJpaAnnotation cacheableUsage = (CacheableJpaAnnotation)((Object)classDetails.applyAnnotationUsage(JpaAnnotations.CACHEABLE, xmlDocumentContext.getModelBuildingContext()));
            cacheableUsage.value(jaxbEntity.isCacheable());
            classDetails.addAnnotationUsage((Annotation)((Object)cacheableUsage));
        }
        if ((jaxbCaching = jaxbEntity.getCaching()) != null) {
            CacheConcurrencyStrategy strategy;
            CacheAnnotation cacheUsage = (CacheAnnotation)classDetails.replaceAnnotationUsage(HibernateAnnotations.CACHE, xmlDocumentContext.getModelBuildingContext());
            if (StringHelper.isNotEmpty(jaxbCaching.getRegion())) {
                cacheUsage.region(jaxbCaching.getRegion());
            }
            if (jaxbCaching.getAccess() != null && (strategy = ManagedTypeProcessor.convertCacheAccessType(jaxbCaching.getAccess())) != null) {
                cacheUsage.usage(strategy);
            }
        }
    }

    private static CacheConcurrencyStrategy convertCacheAccessType(org.hibernate.cache.spi.access.AccessType accessType) {
        return accessType == null ? null : CacheConcurrencyStrategy.fromAccessType(accessType);
    }

    private static void applyTenantId(MutableClassDetails classDetails, JaxbEntityImpl jaxbEntity, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        JaxbTenantIdImpl jaxbTenantId = jaxbEntity.getTenantId();
        if (jaxbTenantId != null) {
            MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbTenantId.getName(), NullnessHelper.coalesce(jaxbTenantId.getAccess(), classAccessType), classDetails);
            memberDetails.applyAnnotationUsage(HibernateAnnotations.TENANT_ID, xmlDocumentContext.getModelBuildingContext());
            BasicAttributeProcessing.processBasicAttribute(jaxbTenantId, classDetails, classAccessType, xmlDocumentContext);
        }
    }

    private static void adjustNonDynamicTypeMember(MutableMemberDetails memberDetails, JaxbPersistentAttribute jaxbAttribute, XmlDocumentContext xmlDocumentContext) {
        CommonAttributeProcessing.applyAttributeAccessor(jaxbAttribute, memberDetails, xmlDocumentContext);
    }

    private static void adjustCompleteNonDynamicTypeMember(MutableMemberDetails memberDetails, JaxbPersistentAttribute jaxbAttribute, XmlDocumentContext xmlDocumentContext) {
        CommonAttributeProcessing.applyAttributeAccessor(jaxbAttribute, memberDetails, xmlDocumentContext);
    }

    public static void processOverrideEntity(List<XmlProcessingResult.OverrideTuple<JaxbEntityImpl>> entityOverrides) {
        entityOverrides.forEach(overrideTuple -> {
            XmlDocumentContext xmlDocumentContext = overrideTuple.getXmlDocumentContext();
            JaxbEntityMappingsImpl jaxbRoot = overrideTuple.getJaxbRoot();
            JaxbEntityImpl jaxbEntity = (JaxbEntityImpl)overrideTuple.getManagedType();
            String className = XmlProcessingHelper.determineClassName(jaxbRoot, jaxbEntity);
            MutableClassDetails classDetails = (MutableClassDetails)xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(className);
            Supplier[] supplierArray = new Supplier[6];
            supplierArray[0] = jaxbEntity::getAccess;
            supplierArray[1] = jaxbRoot::getAccess;
            supplierArray[2] = () -> ManagedTypeProcessor.determineAccessTypeFromClassAnnotations((ClassDetails)classDetails);
            supplierArray[3] = xmlDocumentContext.getEffectiveDefaults()::getDefaultPropertyAccessType;
            supplierArray[4] = () -> ManagedTypeProcessor.determineAccessTypeFromClassMembers((ClassDetails)classDetails);
            supplierArray[5] = () -> AccessType.PROPERTY;
            AccessType classAccessType = (AccessType)NullnessHelper.coalesceSuppliedValues(supplierArray);
            ManagedTypeProcessor.processEntityMetadata(classDetails, jaxbEntity, classAccessType, ManagedTypeProcessor::adjustNonDynamicTypeMember, jaxbRoot, xmlDocumentContext);
        });
    }

    private static AccessType determineAccessTypeFromClassAnnotations(ClassDetails classDetails) {
        Access accessUsage = (Access)classDetails.getDirectAnnotationUsage(Access.class);
        return accessUsage != null ? accessUsage.value() : null;
    }

    private static AccessType determineAccessTypeFromClassMembers(ClassDetails classDetails) {
        for (FieldDetails field : classDetails.getFields()) {
            if (!field.hasDirectAnnotationUsage(Id.class) && !field.hasDirectAnnotationUsage(EmbeddedId.class)) continue;
            return AccessType.FIELD;
        }
        for (MethodDetails method : classDetails.getMethods()) {
            if (!method.hasDirectAnnotationUsage(Id.class) && !method.hasDirectAnnotationUsage(EmbeddedId.class)) continue;
            assert (method.getMethodKind() == MethodDetails.MethodKind.GETTER);
            return AccessType.PROPERTY;
        }
        return null;
    }

    private static void processIdMappings(JaxbAttributesContainerImpl attributes, AccessType classAccessType, MutableClassDetails classDetails, AttributeProcessor.MemberAdjuster memberAdjuster, XmlDocumentContext xmlDocumentContext) {
        List<JaxbIdImpl> jaxbIds = attributes.getIdAttributes();
        JaxbEmbeddedIdImpl jaxbEmbeddedId = attributes.getEmbeddedIdAttribute();
        if (CollectionHelper.isNotEmpty(jaxbIds)) {
            for (int i = 0; i < jaxbIds.size(); ++i) {
                JaxbIdImpl jaxbId = jaxbIds.get(i);
                MutableMemberDetails memberDetails = BasicIdAttributeProcessing.processBasicIdAttribute(jaxbId, classDetails, classAccessType, xmlDocumentContext);
                memberAdjuster.adjust(memberDetails, jaxbId, xmlDocumentContext);
            }
        } else if (jaxbEmbeddedId != null) {
            MutableMemberDetails memberDetails = EmbeddedIdAttributeProcessing.processEmbeddedIdAttribute(jaxbEmbeddedId, classDetails, classAccessType, xmlDocumentContext);
            memberAdjuster.adjust(memberDetails, jaxbEmbeddedId, xmlDocumentContext);
        } else {
            ModelsClassLogging.MODELS_CLASS_LOGGER.debugf("Identifiable type [%s] contained no <id/> nor <embedded-id/>", (Object)classDetails.getName());
        }
    }

    public static void processCompleteMappedSuperclass(JaxbEntityMappingsImpl jaxbRoot, JaxbMappedSuperclassImpl jaxbMappedSuperclass, XmlDocumentContext xmlDocumentContext) {
        String className = XmlProcessingHelper.determineClassName(jaxbRoot, jaxbMappedSuperclass);
        MutableClassDetails classDetails = (MutableClassDetails)xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(className);
        classDetails.clearMemberAnnotationUsages();
        classDetails.clearAnnotationUsages();
        ManagedTypeProcessor.processMappedSuperclassMetadata(jaxbMappedSuperclass, classDetails, xmlDocumentContext);
    }

    private static void processMappedSuperclassMetadata(JaxbMappedSuperclassImpl jaxbMappedSuperclass, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        JaxbAttributesContainerImpl attributes;
        ModelsContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        classDetails.applyAnnotationUsage(JpaAnnotations.MAPPED_SUPERCLASS, modelBuildingContext);
        AccessType classAccessType = NullnessHelper.coalesce(jaxbMappedSuperclass.getAccess(), xmlDocumentContext.getEffectiveDefaults().getDefaultPropertyAccessType());
        if (classAccessType != null) {
            AccessJpaAnnotation accessUsage = (AccessJpaAnnotation)((Object)classDetails.applyAnnotationUsage(JpaAnnotations.ACCESS, modelBuildingContext));
            accessUsage.value(classAccessType);
        }
        if ((attributes = jaxbMappedSuperclass.getAttributes()) != null) {
            ManagedTypeProcessor.processIdMappings(attributes, classAccessType, classDetails, ManagedTypeProcessor::adjustNonDynamicTypeMember, xmlDocumentContext);
            AttributeProcessor.processAttributes(attributes, classDetails, classAccessType, xmlDocumentContext);
        }
        ManagedTypeProcessor.processEntityOrMappedSuperclass(jaxbMappedSuperclass, classDetails, xmlDocumentContext);
        ManagedTypeProcessor.renderClass(classDetails, xmlDocumentContext);
    }

    public static void processOverrideMappedSuperclass(List<XmlProcessingResult.OverrideTuple<JaxbMappedSuperclassImpl>> mappedSuperclassesOverrides) {
        mappedSuperclassesOverrides.forEach(overrideTuple -> {
            XmlDocumentContext xmlDocumentContext = overrideTuple.getXmlDocumentContext();
            JaxbEntityMappingsImpl jaxbRoot = overrideTuple.getJaxbRoot();
            JaxbMappedSuperclassImpl jaxbMappedSuperclass = (JaxbMappedSuperclassImpl)overrideTuple.getManagedType();
            String className = XmlProcessingHelper.determineClassName(jaxbRoot, jaxbMappedSuperclass);
            MutableClassDetails classDetails = (MutableClassDetails)xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(className);
            ManagedTypeProcessor.processMappedSuperclassMetadata(jaxbMappedSuperclass, classDetails, xmlDocumentContext);
        });
    }

    private static void processEntityOrMappedSuperclass(JaxbEntityOrMappedSuperclass jaxbClass, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyIdClass(jaxbClass.getIdClass(), classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallbacks(jaxbClass, classDetails, xmlDocumentContext);
    }

    public static void processCompleteEmbeddable(JaxbEntityMappingsImpl jaxbRoot, JaxbEmbeddableImpl jaxbEmbeddable, XmlDocumentContext xmlDocumentContext) {
        AttributeProcessor.MemberAdjuster memberAdjuster;
        AccessType classAccessType;
        MutableClassDetails classDetails;
        ClassDetailsRegistry classDetailsRegistry = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry();
        if (StringHelper.isEmpty(jaxbEmbeddable.getClazz())) {
            if (StringHelper.isEmpty(jaxbEmbeddable.getName())) {
                throw new ModelsException("Embeddable did not define class nor name");
            }
            classDetails = (MutableClassDetails)ModelsHelper.resolveClassDetails(jaxbEmbeddable.getName(), classDetailsRegistry, () -> new DynamicClassDetails(jaxbEmbeddable.getName(), xmlDocumentContext.getModelBuildingContext()));
            classAccessType = AccessType.FIELD;
            memberAdjuster = ManagedTypeProcessor::adjustDynamicTypeMember;
            DynamicModelHelper.prepareDynamicClass(classDetails, jaxbEmbeddable, xmlDocumentContext);
        } else {
            String className = XmlProcessingHelper.determineClassName(jaxbRoot, jaxbEmbeddable);
            classDetails = (MutableClassDetails)classDetailsRegistry.resolveClassDetails(className);
            classAccessType = NullnessHelper.coalesce(jaxbEmbeddable.getAccess(), xmlDocumentContext.getEffectiveDefaults().getDefaultPropertyAccessType());
            memberAdjuster = ManagedTypeProcessor::adjustNonDynamicTypeMember;
        }
        classDetails.clearMemberAnnotationUsages();
        classDetails.clearAnnotationUsages();
        ManagedTypeProcessor.processEmbeddableMetadata(jaxbEmbeddable, classDetails, classAccessType, memberAdjuster, xmlDocumentContext);
    }

    private static void processEmbeddableMetadata(JaxbEmbeddableImpl jaxbEmbeddable, MutableClassDetails classDetails, AccessType classAccessType, AttributeProcessor.MemberAdjuster memberAdjuster, XmlDocumentContext xmlDocumentContext) {
        classDetails.applyAnnotationUsage(JpaAnnotations.EMBEDDABLE, xmlDocumentContext.getModelBuildingContext());
        if (classAccessType != null) {
            AccessJpaAnnotation accessUsage = (AccessJpaAnnotation)((Object)classDetails.applyAnnotationUsage(JpaAnnotations.ACCESS, xmlDocumentContext.getModelBuildingContext()));
            accessUsage.value(classAccessType);
        }
        if (jaxbEmbeddable.getAttributes() != null) {
            AttributeProcessor.processAttributes(jaxbEmbeddable.getAttributes(), classDetails, AccessType.FIELD, memberAdjuster, xmlDocumentContext);
        }
    }

    public static void processOverrideEmbeddable(List<XmlProcessingResult.OverrideTuple<JaxbEmbeddableImpl>> embeddableOverrides) {
        embeddableOverrides.forEach(overrideTuple -> {
            XmlDocumentContext xmlDocumentContext = overrideTuple.getXmlDocumentContext();
            JaxbEntityMappingsImpl jaxbRoot = overrideTuple.getJaxbRoot();
            JaxbEmbeddableImpl jaxbEmbeddable = (JaxbEmbeddableImpl)overrideTuple.getManagedType();
            String className = XmlProcessingHelper.determineClassName(jaxbRoot, jaxbEmbeddable);
            MutableClassDetails classDetails = (MutableClassDetails)xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(className);
            classDetails.applyAnnotationUsage(JpaAnnotations.EMBEDDABLE, xmlDocumentContext.getModelBuildingContext());
            if (jaxbEmbeddable.getAttributes() != null) {
                AttributeProcessor.processAttributes(jaxbEmbeddable.getAttributes(), classDetails, AccessType.FIELD, ManagedTypeProcessor::adjustNonDynamicTypeMember, xmlDocumentContext);
            }
        });
    }
}

