/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import liquibase.logging.LogFactory;

public class NetUtil {
    private static InetAddress getLocalHost() throws UnknownHostException, SocketException {
        String osName = System.getProperty("os.name");
        if (osName != null && osName.toLowerCase().contains("windows")) {
            return InetAddress.getLocalHost();
        }
        InetAddress loopback = null;
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface i = e.nextElement();
            if (!i.isUp() || i.isPointToPoint()) continue;
            Enumeration<InetAddress> ie = i.getInetAddresses();
            while (ie.hasMoreElements()) {
                InetAddress lch = ie.nextElement();
                if (lch.isLoopbackAddress()) {
                    loopback = lch;
                    continue;
                }
                if (lch.isLinkLocalAddress()) continue;
                return lch;
            }
        }
        return loopback;
    }

    public static String getLocalHostAddress() throws UnknownHostException, SocketException {
        try {
            return NetUtil.getLocalHost().getHostAddress();
        }
        catch (Throwable e) {
            LogFactory.getInstance().getLog().debug("Error getting hostname", e);
            return "unknown";
        }
    }

    public static String getLocalHostName() throws UnknownHostException, SocketException {
        try {
            return NetUtil.getLocalHost().getHostName();
        }
        catch (Throwable e) {
            LogFactory.getInstance().getLog().debug("Error getting hostname", e);
            return "unknown";
        }
    }
}

