<?php
// This file was auto-generated from sdk-root/src/data/bedrock-data-automation/2023-07-26/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2023-07-26', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'bedrock-data-automation', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'Data Automation for Amazon Bedrock', 'serviceId' => 'Bedrock Data Automation', 'signatureVersion' => 'v4', 'signingName' => 'bedrock', 'uid' => 'bedrock-data-automation-2023-07-26', ], 'operations' => [ 'CopyBlueprintStage' => [ 'name' => 'CopyBlueprintStage', 'http' => [ 'method' => 'PUT', 'requestUri' => '/blueprints/{blueprintArn}/copy-stage', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CopyBlueprintStageRequest', ], 'output' => [ 'shape' => 'CopyBlueprintStageResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'CreateBlueprint' => [ 'name' => 'CreateBlueprint', 'http' => [ 'method' => 'PUT', 'requestUri' => '/blueprints/', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateBlueprintRequest', ], 'output' => [ 'shape' => 'CreateBlueprintResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'CreateBlueprintVersion' => [ 'name' => 'CreateBlueprintVersion', 'http' => [ 'method' => 'POST', 'requestUri' => '/blueprints/{blueprintArn}/versions/', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateBlueprintVersionRequest', ], 'output' => [ 'shape' => 'CreateBlueprintVersionResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'CreateDataAutomationProject' => [ 'name' => 'CreateDataAutomationProject', 'http' => [ 'method' => 'PUT', 'requestUri' => '/data-automation-projects/', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateDataAutomationProjectRequest', ], 'output' => [ 'shape' => 'CreateDataAutomationProjectResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'DeleteBlueprint' => [ 'name' => 'DeleteBlueprint', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/blueprints/{blueprintArn}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteBlueprintRequest', ], 'output' => [ 'shape' => 'DeleteBlueprintResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'DeleteDataAutomationProject' => [ 'name' => 'DeleteDataAutomationProject', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/data-automation-projects/{projectArn}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteDataAutomationProjectRequest', ], 'output' => [ 'shape' => 'DeleteDataAutomationProjectResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'GetBlueprint' => [ 'name' => 'GetBlueprint', 'http' => [ 'method' => 'POST', 'requestUri' => '/blueprints/{blueprintArn}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetBlueprintRequest', ], 'output' => [ 'shape' => 'GetBlueprintResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetBlueprintOptimizationStatus' => [ 'name' => 'GetBlueprintOptimizationStatus', 'http' => [ 'method' => 'POST', 'requestUri' => '/getBlueprintOptimizationStatus/{invocationArn}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetBlueprintOptimizationStatusRequest', ], 'output' => [ 'shape' => 'GetBlueprintOptimizationStatusResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'GetDataAutomationProject' => [ 'name' => 'GetDataAutomationProject', 'http' => [ 'method' => 'POST', 'requestUri' => '/data-automation-projects/{projectArn}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDataAutomationProjectRequest', ], 'output' => [ 'shape' => 'GetDataAutomationProjectResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'InvokeBlueprintOptimizationAsync' => [ 'name' => 'InvokeBlueprintOptimizationAsync', 'http' => [ 'method' => 'POST', 'requestUri' => '/invokeBlueprintOptimizationAsync', 'responseCode' => 200, ], 'input' => [ 'shape' => 'InvokeBlueprintOptimizationAsyncRequest', ], 'output' => [ 'shape' => 'InvokeBlueprintOptimizationAsyncResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'ListBlueprints' => [ 'name' => 'ListBlueprints', 'http' => [ 'method' => 'POST', 'requestUri' => '/blueprints/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListBlueprintsRequest', ], 'output' => [ 'shape' => 'ListBlueprintsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListDataAutomationProjects' => [ 'name' => 'ListDataAutomationProjects', 'http' => [ 'method' => 'POST', 'requestUri' => '/data-automation-projects/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDataAutomationProjectsRequest', ], 'output' => [ 'shape' => 'ListDataAutomationProjectsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'readonly' => true, ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/listTagsForResource', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tagResource', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/untagResource', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateBlueprint' => [ 'name' => 'UpdateBlueprint', 'http' => [ 'method' => 'PUT', 'requestUri' => '/blueprints/{blueprintArn}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateBlueprintRequest', ], 'output' => [ 'shape' => 'UpdateBlueprintResponse', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], 'UpdateDataAutomationProject' => [ 'name' => 'UpdateDataAutomationProject', 'http' => [ 'method' => 'PUT', 'requestUri' => '/data-automation-projects/{projectArn}/', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateDataAutomationProjectRequest', ], 'output' => [ 'shape' => 'UpdateDataAutomationProjectResponse', ], 'errors' => [ [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AudioExtractionCategory' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'state' => [ 'shape' => 'State', ], 'types' => [ 'shape' => 'AudioExtractionCategoryTypes', ], 'typeConfiguration' => [ 'shape' => 'AudioExtractionCategoryTypeConfiguration', ], ], ], 'AudioExtractionCategoryType' => [ 'type' => 'string', 'enum' => [ 'AUDIO_CONTENT_MODERATION', 'TRANSCRIPT', 'TOPIC_CONTENT_MODERATION', ], ], 'AudioExtractionCategoryTypeConfiguration' => [ 'type' => 'structure', 'members' => [ 'transcript' => [ 'shape' => 'TranscriptConfiguration', ], ], ], 'AudioExtractionCategoryTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'AudioExtractionCategoryType', ], ], 'AudioGenerativeOutputLanguage' => [ 'type' => 'string', 'enum' => [ 'DEFAULT', 'EN', ], ], 'AudioInputLanguages' => [ 'type' => 'list', 'member' => [ 'shape' => 'Language', ], ], 'AudioLanguageConfiguration' => [ 'type' => 'structure', 'members' => [ 'inputLanguages' => [ 'shape' => 'AudioInputLanguages', ], 'generativeOutputLanguage' => [ 'shape' => 'AudioGenerativeOutputLanguage', ], 'identifyMultipleLanguages' => [ 'shape' => 'Boolean', ], ], ], 'AudioOverrideConfiguration' => [ 'type' => 'structure', 'members' => [ 'modalityProcessing' => [ 'shape' => 'ModalityProcessingConfiguration', ], 'languageConfiguration' => [ 'shape' => 'AudioLanguageConfiguration', ], 'sensitiveDataConfiguration' => [ 'shape' => 'SensitiveDataConfiguration', ], ], ], 'AudioStandardExtraction' => [ 'type' => 'structure', 'required' => [ 'category', ], 'members' => [ 'category' => [ 'shape' => 'AudioExtractionCategory', ], ], ], 'AudioStandardGenerativeField' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'state' => [ 'shape' => 'State', ], 'types' => [ 'shape' => 'AudioStandardGenerativeFieldTypes', ], ], ], 'AudioStandardGenerativeFieldType' => [ 'type' => 'string', 'enum' => [ 'AUDIO_SUMMARY', 'IAB', 'TOPIC_SUMMARY', ], ], 'AudioStandardGenerativeFieldTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'AudioStandardGenerativeFieldType', ], ], 'AudioStandardOutputConfiguration' => [ 'type' => 'structure', 'members' => [ 'extraction' => [ 'shape' => 'AudioStandardExtraction', ], 'generativeField' => [ 'shape' => 'AudioStandardGenerativeField', ], ], ], 'Blueprint' => [ 'type' => 'structure', 'required' => [ 'blueprintArn', 'schema', 'type', 'creationTime', 'lastModifiedTime', 'blueprintName', ], 'members' => [ 'blueprintArn' => [ 'shape' => 'BlueprintArn', ], 'schema' => [ 'shape' => 'BlueprintSchema', ], 'type' => [ 'shape' => 'Type', ], 'creationTime' => [ 'shape' => 'DateTimestamp', ], 'lastModifiedTime' => [ 'shape' => 'DateTimestamp', ], 'blueprintName' => [ 'shape' => 'BlueprintName', ], 'blueprintVersion' => [ 'shape' => 'BlueprintVersion', ], 'blueprintStage' => [ 'shape' => 'BlueprintStage', ], 'kmsKeyId' => [ 'shape' => 'KmsKeyId', ], 'kmsEncryptionContext' => [ 'shape' => 'KmsEncryptionContext', ], 'optimizationSamples' => [ 'shape' => 'BlueprintOptimizationSamples', ], 'optimizationTime' => [ 'shape' => 'DateTimestamp', ], ], ], 'BlueprintArn' => [ 'type' => 'string', 'max' => 128, 'min' => 0, 'pattern' => 'arn:aws(|-cn|-us-gov):bedrock:[a-zA-Z0-9-]*:(aws|[0-9]{12}):blueprint/(bedrock-data-automation-public-[a-zA-Z0-9-_]{1,30}|[a-zA-Z0-9-]{12,36})', ], 'BlueprintFilter' => [ 'type' => 'structure', 'required' => [ 'blueprintArn', ], 'members' => [ 'blueprintArn' => [ 'shape' => 'BlueprintArn', ], 'blueprintVersion' => [ 'shape' => 'BlueprintVersion', ], 'blueprintStage' => [ 'shape' => 'BlueprintStage', ], ], ], 'BlueprintItem' => [ 'type' => 'structure', 'required' => [ 'blueprintArn', ], 'members' => [ 'blueprintArn' => [ 'shape' => 'BlueprintArn', ], 'blueprintVersion' => [ 'shape' => 'BlueprintVersion', ], 'blueprintStage' => [ 'shape' => 'BlueprintStage', ], ], ], 'BlueprintItems' => [ 'type' => 'list', 'member' => [ 'shape' => 'BlueprintItem', ], ], 'BlueprintName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9-_]+', 'sensitive' => true, ], 'BlueprintOptimizationInvocationArn' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => 'arn:aws(|-cn|-iso|-iso-[a-z]|-us-gov):bedrock:[a-zA-Z0-9-]*:[0-9]{12}:blueprint-optimization-invocation/[a-zA-Z0-9-_]+', ], 'BlueprintOptimizationJobStatus' => [ 'type' => 'string', 'enum' => [ 'Created', 'InProgress', 'Success', 'ServiceError', 'ClientError', ], ], 'BlueprintOptimizationObject' => [ 'type' => 'structure', 'required' => [ 'blueprintArn', ], 'members' => [ 'blueprintArn' => [ 'shape' => 'BlueprintArn', ], 'stage' => [ 'shape' => 'BlueprintStage', ], ], ], 'BlueprintOptimizationOutputConfiguration' => [ 'type' => 'structure', 'required' => [ 's3Object', ], 'members' => [ 's3Object' => [ 'shape' => 'S3Object', ], ], ], 'BlueprintOptimizationSample' => [ 'type' => 'structure', 'required' => [ 'assetS3Object', 'groundTruthS3Object', ], 'members' => [ 'assetS3Object' => [ 'shape' => 'S3Object', ], 'groundTruthS3Object' => [ 'shape' => 'S3Object', ], ], ], 'BlueprintOptimizationSamples' => [ 'type' => 'list', 'member' => [ 'shape' => 'BlueprintOptimizationSample', ], ], 'BlueprintSchema' => [ 'type' => 'string', 'max' => 100000, 'min' => 1, 'sensitive' => true, ], 'BlueprintStage' => [ 'type' => 'string', 'enum' => [ 'DEVELOPMENT', 'LIVE', ], ], 'BlueprintStageFilter' => [ 'type' => 'string', 'enum' => [ 'DEVELOPMENT', 'LIVE', 'ALL', ], ], 'BlueprintSummary' => [ 'type' => 'structure', 'required' => [ 'blueprintArn', 'creationTime', ], 'members' => [ 'blueprintArn' => [ 'shape' => 'BlueprintArn', ], 'blueprintVersion' => [ 'shape' => 'BlueprintVersion', ], 'blueprintStage' => [ 'shape' => 'BlueprintStage', ], 'blueprintName' => [ 'shape' => 'BlueprintName', ], 'creationTime' => [ 'shape' => 'DateTimestamp', ], 'lastModifiedTime' => [ 'shape' => 'DateTimestamp', ], ], ], 'BlueprintVersion' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[0-9]*', ], 'Blueprints' => [ 'type' => 'list', 'member' => [ 'shape' => 'BlueprintSummary', ], ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'ChannelLabelingConfiguration' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'state' => [ 'shape' => 'State', ], ], ], 'ClientToken' => [ 'type' => 'string', 'max' => 256, 'min' => 33, 'pattern' => '[a-zA-Z0-9](-*[a-zA-Z0-9]){0,256}', ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'CopyBlueprintStageRequest' => [ 'type' => 'structure', 'required' => [ 'blueprintArn', 'sourceStage', 'targetStage', ], 'members' => [ 'blueprintArn' => [ 'shape' => 'BlueprintArn', 'location' => 'uri', 'locationName' => 'blueprintArn', ], 'sourceStage' => [ 'shape' => 'BlueprintStage', ], 'targetStage' => [ 'shape' => 'BlueprintStage', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CopyBlueprintStageResponse' => [ 'type' => 'structure', 'members' => [], ], 'CreateBlueprintRequest' => [ 'type' => 'structure', 'required' => [ 'blueprintName', 'type', 'schema', ], 'members' => [ 'blueprintName' => [ 'shape' => 'BlueprintName', ], 'type' => [ 'shape' => 'Type', ], 'blueprintStage' => [ 'shape' => 'BlueprintStage', ], 'schema' => [ 'shape' => 'BlueprintSchema', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'encryptionConfiguration' => [ 'shape' => 'EncryptionConfiguration', ], 'tags' => [ 'shape' => 'TagList', ], ], ], 'CreateBlueprintResponse' => [ 'type' => 'structure', 'required' => [ 'blueprint', ], 'members' => [ 'blueprint' => [ 'shape' => 'Blueprint', ], ], ], 'CreateBlueprintVersionRequest' => [ 'type' => 'structure', 'required' => [ 'blueprintArn', ], 'members' => [ 'blueprintArn' => [ 'shape' => 'BlueprintArn', 'location' => 'uri', 'locationName' => 'blueprintArn', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateBlueprintVersionResponse' => [ 'type' => 'structure', 'required' => [ 'blueprint', ], 'members' => [ 'blueprint' => [ 'shape' => 'Blueprint', ], ], ], 'CreateDataAutomationProjectRequest' => [ 'type' => 'structure', 'required' => [ 'projectName', 'standardOutputConfiguration', ], 'members' => [ 'projectName' => [ 'shape' => 'DataAutomationProjectName', ], 'projectDescription' => [ 'shape' => 'DataAutomationProjectDescription', ], 'projectStage' => [ 'shape' => 'DataAutomationProjectStage', ], 'projectType' => [ 'shape' => 'DataAutomationProjectType', ], 'standardOutputConfiguration' => [ 'shape' => 'StandardOutputConfiguration', ], 'customOutputConfiguration' => [ 'shape' => 'CustomOutputConfiguration', ], 'overrideConfiguration' => [ 'shape' => 'OverrideConfiguration', ], 'clientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'encryptionConfiguration' => [ 'shape' => 'EncryptionConfiguration', ], 'tags' => [ 'shape' => 'TagList', ], ], ], 'CreateDataAutomationProjectResponse' => [ 'type' => 'structure', 'required' => [ 'projectArn', ], 'members' => [ 'projectArn' => [ 'shape' => 'DataAutomationProjectArn', ], 'projectStage' => [ 'shape' => 'DataAutomationProjectStage', ], 'status' => [ 'shape' => 'DataAutomationProjectStatus', ], ], ], 'CustomOutputConfiguration' => [ 'type' => 'structure', 'members' => [ 'blueprints' => [ 'shape' => 'BlueprintItems', ], ], ], 'DataAutomationProfileArn' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => 'arn:aws(|-cn|-us-gov):bedrock:[a-zA-Z0-9-]*:(aws|[0-9]{12}):data-automation-profile/[a-zA-Z0-9-_.]+', ], 'DataAutomationProject' => [ 'type' => 'structure', 'required' => [ 'projectArn', 'creationTime', 'lastModifiedTime', 'projectName', 'status', ], 'members' => [ 'projectArn' => [ 'shape' => 'DataAutomationProjectArn', ], 'creationTime' => [ 'shape' => 'DateTimestamp', ], 'lastModifiedTime' => [ 'shape' => 'DateTimestamp', ], 'projectName' => [ 'shape' => 'DataAutomationProjectName', ], 'projectStage' => [ 'shape' => 'DataAutomationProjectStage', ], 'projectType' => [ 'shape' => 'DataAutomationProjectType', ], 'projectDescription' => [ 'shape' => 'DataAutomationProjectDescription', ], 'standardOutputConfiguration' => [ 'shape' => 'StandardOutputConfiguration', ], 'customOutputConfiguration' => [ 'shape' => 'CustomOutputConfiguration', ], 'overrideConfiguration' => [ 'shape' => 'OverrideConfiguration', ], 'status' => [ 'shape' => 'DataAutomationProjectStatus', ], 'kmsKeyId' => [ 'shape' => 'KmsKeyId', ], 'kmsEncryptionContext' => [ 'shape' => 'KmsEncryptionContext', ], ], ], 'DataAutomationProjectArn' => [ 'type' => 'string', 'max' => 128, 'min' => 0, 'pattern' => 'arn:aws(|-cn|-us-gov):bedrock:[a-zA-Z0-9-]*:(aws|[0-9]{12}):data-automation-project/[a-zA-Z0-9-]{12,36}', ], 'DataAutomationProjectDescription' => [ 'type' => 'string', 'max' => 300, 'min' => 0, 'sensitive' => true, ], 'DataAutomationProjectFilter' => [ 'type' => 'structure', 'required' => [ 'projectArn', ], 'members' => [ 'projectArn' => [ 'shape' => 'DataAutomationProjectArn', ], 'projectStage' => [ 'shape' => 'DataAutomationProjectStage', ], ], ], 'DataAutomationProjectName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9-_]+', 'sensitive' => true, ], 'DataAutomationProjectStage' => [ 'type' => 'string', 'enum' => [ 'DEVELOPMENT', 'LIVE', ], ], 'DataAutomationProjectStageFilter' => [ 'type' => 'string', 'enum' => [ 'DEVELOPMENT', 'LIVE', 'ALL', ], ], 'DataAutomationProjectStatus' => [ 'type' => 'string', 'enum' => [ 'COMPLETED', 'IN_PROGRESS', 'FAILED', ], ], 'DataAutomationProjectSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataAutomationProjectSummary', ], ], 'DataAutomationProjectSummary' => [ 'type' => 'structure', 'required' => [ 'projectArn', 'creationTime', ], 'members' => [ 'projectArn' => [ 'shape' => 'DataAutomationProjectArn', ], 'projectStage' => [ 'shape' => 'DataAutomationProjectStage', ], 'projectType' => [ 'shape' => 'DataAutomationProjectType', ], 'projectName' => [ 'shape' => 'DataAutomationProjectName', ], 'creationTime' => [ 'shape' => 'DateTimestamp', ], ], ], 'DataAutomationProjectType' => [ 'type' => 'string', 'enum' => [ 'ASYNC', 'SYNC', ], ], 'DateTimestamp' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'DeleteBlueprintRequest' => [ 'type' => 'structure', 'required' => [ 'blueprintArn', ], 'members' => [ 'blueprintArn' => [ 'shape' => 'BlueprintArn', 'location' => 'uri', 'locationName' => 'blueprintArn', ], 'blueprintVersion' => [ 'shape' => 'BlueprintVersion', 'location' => 'querystring', 'locationName' => 'blueprintVersion', ], ], ], 'DeleteBlueprintResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteDataAutomationProjectRequest' => [ 'type' => 'structure', 'required' => [ 'projectArn', ], 'members' => [ 'projectArn' => [ 'shape' => 'DataAutomationProjectArn', 'location' => 'uri', 'locationName' => 'projectArn', ], ], ], 'DeleteDataAutomationProjectResponse' => [ 'type' => 'structure', 'required' => [ 'projectArn', ], 'members' => [ 'projectArn' => [ 'shape' => 'DataAutomationProjectArn', ], 'status' => [ 'shape' => 'DataAutomationProjectStatus', ], ], ], 'DesiredModality' => [ 'type' => 'string', 'enum' => [ 'IMAGE', 'DOCUMENT', 'AUDIO', 'VIDEO', ], ], 'DocumentBoundingBox' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'state' => [ 'shape' => 'State', ], ], ], 'DocumentExtractionGranularity' => [ 'type' => 'structure', 'members' => [ 'types' => [ 'shape' => 'DocumentExtractionGranularityTypes', ], ], ], 'DocumentExtractionGranularityType' => [ 'type' => 'string', 'enum' => [ 'DOCUMENT', 'PAGE', 'ELEMENT', 'WORD', 'LINE', ], ], 'DocumentExtractionGranularityTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'DocumentExtractionGranularityType', ], ], 'DocumentOutputAdditionalFileFormat' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'state' => [ 'shape' => 'State', ], ], ], 'DocumentOutputFormat' => [ 'type' => 'structure', 'required' => [ 'textFormat', 'additionalFileFormat', ], 'members' => [ 'textFormat' => [ 'shape' => 'DocumentOutputTextFormat', ], 'additionalFileFormat' => [ 'shape' => 'DocumentOutputAdditionalFileFormat', ], ], ], 'DocumentOutputTextFormat' => [ 'type' => 'structure', 'members' => [ 'types' => [ 'shape' => 'DocumentOutputTextFormatTypes', ], ], ], 'DocumentOutputTextFormatType' => [ 'type' => 'string', 'enum' => [ 'PLAIN_TEXT', 'MARKDOWN', 'HTML', 'CSV', ], ], 'DocumentOutputTextFormatTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'DocumentOutputTextFormatType', ], ], 'DocumentOverrideConfiguration' => [ 'type' => 'structure', 'members' => [ 'splitter' => [ 'shape' => 'SplitterConfiguration', ], 'modalityProcessing' => [ 'shape' => 'ModalityProcessingConfiguration', ], 'sensitiveDataConfiguration' => [ 'shape' => 'SensitiveDataConfiguration', ], ], ], 'DocumentStandardExtraction' => [ 'type' => 'structure', 'required' => [ 'granularity', 'boundingBox', ], 'members' => [ 'granularity' => [ 'shape' => 'DocumentExtractionGranularity', ], 'boundingBox' => [ 'shape' => 'DocumentBoundingBox', ], ], ], 'DocumentStandardGenerativeField' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'state' => [ 'shape' => 'State', ], ], ], 'DocumentStandardOutputConfiguration' => [ 'type' => 'structure', 'members' => [ 'extraction' => [ 'shape' => 'DocumentStandardExtraction', ], 'generativeField' => [ 'shape' => 'DocumentStandardGenerativeField', ], 'outputFormat' => [ 'shape' => 'DocumentOutputFormat', ], ], ], 'EncryptionConfiguration' => [ 'type' => 'structure', 'required' => [ 'kmsKeyId', ], 'members' => [ 'kmsKeyId' => [ 'shape' => 'KmsKeyId', ], 'kmsEncryptionContext' => [ 'shape' => 'KmsEncryptionContext', ], ], ], 'EncryptionContextKey' => [ 'type' => 'string', 'max' => 2000, 'min' => 1, 'pattern' => '.*\\S.*', ], 'EncryptionContextValue' => [ 'type' => 'string', 'max' => 2000, 'min' => 1, 'pattern' => '.*\\S.*', ], 'GetBlueprintOptimizationStatusRequest' => [ 'type' => 'structure', 'required' => [ 'invocationArn', ], 'members' => [ 'invocationArn' => [ 'shape' => 'BlueprintOptimizationInvocationArn', 'location' => 'uri', 'locationName' => 'invocationArn', ], ], ], 'GetBlueprintOptimizationStatusResponse' => [ 'type' => 'structure', 'members' => [ 'status' => [ 'shape' => 'BlueprintOptimizationJobStatus', ], 'errorType' => [ 'shape' => 'String', ], 'errorMessage' => [ 'shape' => 'String', ], 'outputConfiguration' => [ 'shape' => 'BlueprintOptimizationOutputConfiguration', ], ], ], 'GetBlueprintRequest' => [ 'type' => 'structure', 'required' => [ 'blueprintArn', ], 'members' => [ 'blueprintArn' => [ 'shape' => 'BlueprintArn', 'location' => 'uri', 'locationName' => 'blueprintArn', ], 'blueprintVersion' => [ 'shape' => 'BlueprintVersion', ], 'blueprintStage' => [ 'shape' => 'BlueprintStage', ], ], ], 'GetBlueprintResponse' => [ 'type' => 'structure', 'required' => [ 'blueprint', ], 'members' => [ 'blueprint' => [ 'shape' => 'Blueprint', ], ], ], 'GetDataAutomationProjectRequest' => [ 'type' => 'structure', 'required' => [ 'projectArn', ], 'members' => [ 'projectArn' => [ 'shape' => 'DataAutomationProjectArn', 'location' => 'uri', 'locationName' => 'projectArn', ], 'projectStage' => [ 'shape' => 'DataAutomationProjectStage', ], ], ], 'GetDataAutomationProjectResponse' => [ 'type' => 'structure', 'required' => [ 'project', ], 'members' => [ 'project' => [ 'shape' => 'DataAutomationProject', ], ], ], 'ImageBoundingBox' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'state' => [ 'shape' => 'State', ], ], ], 'ImageExtractionCategory' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'state' => [ 'shape' => 'State', ], 'types' => [ 'shape' => 'ImageExtractionCategoryTypes', ], ], ], 'ImageExtractionCategoryType' => [ 'type' => 'string', 'enum' => [ 'CONTENT_MODERATION', 'TEXT_DETECTION', 'LOGOS', ], ], 'ImageExtractionCategoryTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'ImageExtractionCategoryType', ], ], 'ImageOverrideConfiguration' => [ 'type' => 'structure', 'members' => [ 'modalityProcessing' => [ 'shape' => 'ModalityProcessingConfiguration', ], 'sensitiveDataConfiguration' => [ 'shape' => 'SensitiveDataConfiguration', ], ], ], 'ImageStandardExtraction' => [ 'type' => 'structure', 'required' => [ 'category', 'boundingBox', ], 'members' => [ 'category' => [ 'shape' => 'ImageExtractionCategory', ], 'boundingBox' => [ 'shape' => 'ImageBoundingBox', ], ], ], 'ImageStandardGenerativeField' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'state' => [ 'shape' => 'State', ], 'types' => [ 'shape' => 'ImageStandardGenerativeFieldTypes', ], ], ], 'ImageStandardGenerativeFieldType' => [ 'type' => 'string', 'enum' => [ 'IMAGE_SUMMARY', 'IAB', ], ], 'ImageStandardGenerativeFieldTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'ImageStandardGenerativeFieldType', ], ], 'ImageStandardOutputConfiguration' => [ 'type' => 'structure', 'members' => [ 'extraction' => [ 'shape' => 'ImageStandardExtraction', ], 'generativeField' => [ 'shape' => 'ImageStandardGenerativeField', ], ], ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'InvokeBlueprintOptimizationAsyncRequest' => [ 'type' => 'structure', 'required' => [ 'blueprint', 'samples', 'outputConfiguration', 'dataAutomationProfileArn', ], 'members' => [ 'blueprint' => [ 'shape' => 'BlueprintOptimizationObject', ], 'samples' => [ 'shape' => 'BlueprintOptimizationSamples', ], 'outputConfiguration' => [ 'shape' => 'BlueprintOptimizationOutputConfiguration', ], 'dataAutomationProfileArn' => [ 'shape' => 'DataAutomationProfileArn', ], 'encryptionConfiguration' => [ 'shape' => 'EncryptionConfiguration', ], 'tags' => [ 'shape' => 'TagList', ], ], ], 'InvokeBlueprintOptimizationAsyncResponse' => [ 'type' => 'structure', 'required' => [ 'invocationArn', ], 'members' => [ 'invocationArn' => [ 'shape' => 'BlueprintOptimizationInvocationArn', ], ], ], 'KmsEncryptionContext' => [ 'type' => 'map', 'key' => [ 'shape' => 'EncryptionContextKey', ], 'value' => [ 'shape' => 'EncryptionContextValue', ], 'min' => 1, ], 'KmsKeyId' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '[A-Za-z0-9][A-Za-z0-9:_/+=,@.-]+', ], 'Language' => [ 'type' => 'string', 'enum' => [ 'EN', 'DE', 'ES', 'FR', 'IT', 'PT', 'JA', 'KO', 'CN', 'TW', 'HK', ], ], 'ListBlueprintsRequest' => [ 'type' => 'structure', 'members' => [ 'blueprintArn' => [ 'shape' => 'BlueprintArn', ], 'resourceOwner' => [ 'shape' => 'ResourceOwner', ], 'blueprintStageFilter' => [ 'shape' => 'BlueprintStageFilter', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], 'projectFilter' => [ 'shape' => 'DataAutomationProjectFilter', ], ], ], 'ListBlueprintsResponse' => [ 'type' => 'structure', 'required' => [ 'blueprints', ], 'members' => [ 'blueprints' => [ 'shape' => 'Blueprints', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListDataAutomationProjectsRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], 'projectStageFilter' => [ 'shape' => 'DataAutomationProjectStageFilter', ], 'blueprintFilter' => [ 'shape' => 'BlueprintFilter', ], 'resourceOwner' => [ 'shape' => 'ResourceOwner', ], ], ], 'ListDataAutomationProjectsResponse' => [ 'type' => 'structure', 'required' => [ 'projects', ], 'members' => [ 'projects' => [ 'shape' => 'DataAutomationProjectSummaries', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceARN', ], 'members' => [ 'resourceARN' => [ 'shape' => 'TaggableResourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'TagList', ], ], ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'ModalityProcessingConfiguration' => [ 'type' => 'structure', 'members' => [ 'state' => [ 'shape' => 'State', ], ], ], 'ModalityRoutingConfiguration' => [ 'type' => 'structure', 'members' => [ 'jpeg' => [ 'shape' => 'DesiredModality', ], 'png' => [ 'shape' => 'DesiredModality', ], 'mp4' => [ 'shape' => 'DesiredModality', ], 'mov' => [ 'shape' => 'DesiredModality', ], ], ], 'NextToken' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '\\S*', ], 'NonBlankString' => [ 'type' => 'string', 'pattern' => '[\\s\\S]+', ], 'OverrideConfiguration' => [ 'type' => 'structure', 'members' => [ 'document' => [ 'shape' => 'DocumentOverrideConfiguration', ], 'image' => [ 'shape' => 'ImageOverrideConfiguration', ], 'video' => [ 'shape' => 'VideoOverrideConfiguration', ], 'audio' => [ 'shape' => 'AudioOverrideConfiguration', ], 'modalityRouting' => [ 'shape' => 'ModalityRoutingConfiguration', ], ], ], 'PIIEntitiesConfiguration' => [ 'type' => 'structure', 'members' => [ 'piiEntityTypes' => [ 'shape' => 'PIIEntityTypes', ], 'redactionMaskMode' => [ 'shape' => 'PIIRedactionMaskMode', ], ], ], 'PIIEntityType' => [ 'type' => 'string', 'enum' => [ 'ALL', 'ADDRESS', 'AGE', 'NAME', 'EMAIL', 'PHONE', 'USERNAME', 'PASSWORD', 'DRIVER_ID', 'LICENSE_PLATE', 'VEHICLE_IDENTIFICATION_NUMBER', 'CREDIT_DEBIT_CARD_CVV', 'CREDIT_DEBIT_CARD_EXPIRY', 'CREDIT_DEBIT_CARD_NUMBER', 'PIN', 'INTERNATIONAL_BANK_ACCOUNT_NUMBER', 'SWIFT_CODE', 'IP_ADDRESS', 'MAC_ADDRESS', 'URL', 'AWS_ACCESS_KEY', 'AWS_SECRET_KEY', 'US_BANK_ACCOUNT_NUMBER', 'US_BANK_ROUTING_NUMBER', 'US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER', 'US_PASSPORT_NUMBER', 'US_SOCIAL_SECURITY_NUMBER', 'CA_HEALTH_NUMBER', 'CA_SOCIAL_INSURANCE_NUMBER', 'UK_NATIONAL_HEALTH_SERVICE_NUMBER', 'UK_NATIONAL_INSURANCE_NUMBER', 'UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER', ], ], 'PIIEntityTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'PIIEntityType', ], 'max' => 32, 'min' => 1, ], 'PIIRedactionMaskMode' => [ 'type' => 'string', 'enum' => [ 'PII', 'ENTITY_TYPE', ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'ResourceOwner' => [ 'type' => 'string', 'enum' => [ 'SERVICE', 'ACCOUNT', ], ], 'S3Object' => [ 'type' => 'structure', 'required' => [ 's3Uri', ], 'members' => [ 's3Uri' => [ 'shape' => 'S3Uri', ], 'version' => [ 'shape' => 'S3ObjectVersion', ], ], ], 'S3ObjectVersion' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'S3Uri' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => 's3://[a-z0-9][\\.\\-a-z0-9]{1,61}[a-z0-9](/.*)?', ], 'SensitiveDataConfiguration' => [ 'type' => 'structure', 'required' => [ 'detectionMode', ], 'members' => [ 'detectionMode' => [ 'shape' => 'SensitiveDataDetectionMode', ], 'detectionScope' => [ 'shape' => 'SensitiveDataDetectionScope', ], 'piiEntitiesConfiguration' => [ 'shape' => 'PIIEntitiesConfiguration', ], ], ], 'SensitiveDataDetectionMode' => [ 'type' => 'string', 'enum' => [ 'DETECTION', 'DETECTION_AND_REDACTION', ], ], 'SensitiveDataDetectionScope' => [ 'type' => 'list', 'member' => [ 'shape' => 'SensitiveDataDetectionScopeType', ], 'max' => 2, 'min' => 1, ], 'SensitiveDataDetectionScopeType' => [ 'type' => 'string', 'enum' => [ 'STANDARD', 'CUSTOM', ], ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'SpeakerLabelingConfiguration' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'state' => [ 'shape' => 'State', ], ], ], 'SplitterConfiguration' => [ 'type' => 'structure', 'members' => [ 'state' => [ 'shape' => 'State', ], ], ], 'StandardOutputConfiguration' => [ 'type' => 'structure', 'members' => [ 'document' => [ 'shape' => 'DocumentStandardOutputConfiguration', ], 'image' => [ 'shape' => 'ImageStandardOutputConfiguration', ], 'video' => [ 'shape' => 'VideoStandardOutputConfiguration', ], 'audio' => [ 'shape' => 'AudioStandardOutputConfiguration', ], ], ], 'State' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'DISABLED', ], ], 'String' => [ 'type' => 'string', ], 'Tag' => [ 'type' => 'structure', 'required' => [ 'key', 'value', ], 'members' => [ 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 200, 'min' => 0, ], 'TagList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Tag', ], 'max' => 200, 'min' => 0, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceARN', 'tags', ], 'members' => [ 'resourceARN' => [ 'shape' => 'TaggableResourceArn', ], 'tags' => [ 'shape' => 'TagList', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'TaggableResourceArn' => [ 'type' => 'string', 'max' => 1011, 'min' => 20, 'pattern' => 'arn:aws(|-cn|-iso|-iso-[a-z]|-us-gov):bedrock:[a-z0-9-]*:[0-9]{12}:(blueprint|data-automation-project|blueprint-optimization-invocation)/[a-zA-Z0-9-]{12,36}', ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], 'TranscriptConfiguration' => [ 'type' => 'structure', 'members' => [ 'speakerLabeling' => [ 'shape' => 'SpeakerLabelingConfiguration', ], 'channelLabeling' => [ 'shape' => 'ChannelLabelingConfiguration', ], ], ], 'Type' => [ 'type' => 'string', 'enum' => [ 'DOCUMENT', 'IMAGE', 'AUDIO', 'VIDEO', ], ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceARN', 'tagKeys', ], 'members' => [ 'resourceARN' => [ 'shape' => 'TaggableResourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateBlueprintRequest' => [ 'type' => 'structure', 'required' => [ 'blueprintArn', 'schema', ], 'members' => [ 'blueprintArn' => [ 'shape' => 'BlueprintArn', 'location' => 'uri', 'locationName' => 'blueprintArn', ], 'schema' => [ 'shape' => 'BlueprintSchema', ], 'blueprintStage' => [ 'shape' => 'BlueprintStage', ], 'encryptionConfiguration' => [ 'shape' => 'EncryptionConfiguration', ], ], ], 'UpdateBlueprintResponse' => [ 'type' => 'structure', 'required' => [ 'blueprint', ], 'members' => [ 'blueprint' => [ 'shape' => 'Blueprint', ], ], ], 'UpdateDataAutomationProjectRequest' => [ 'type' => 'structure', 'required' => [ 'projectArn', 'standardOutputConfiguration', ], 'members' => [ 'projectArn' => [ 'shape' => 'DataAutomationProjectArn', 'location' => 'uri', 'locationName' => 'projectArn', ], 'projectStage' => [ 'shape' => 'DataAutomationProjectStage', ], 'projectDescription' => [ 'shape' => 'DataAutomationProjectDescription', ], 'standardOutputConfiguration' => [ 'shape' => 'StandardOutputConfiguration', ], 'customOutputConfiguration' => [ 'shape' => 'CustomOutputConfiguration', ], 'overrideConfiguration' => [ 'shape' => 'OverrideConfiguration', ], 'encryptionConfiguration' => [ 'shape' => 'EncryptionConfiguration', ], ], ], 'UpdateDataAutomationProjectResponse' => [ 'type' => 'structure', 'required' => [ 'projectArn', ], 'members' => [ 'projectArn' => [ 'shape' => 'DataAutomationProjectArn', ], 'projectStage' => [ 'shape' => 'DataAutomationProjectStage', ], 'status' => [ 'shape' => 'DataAutomationProjectStatus', ], ], ], 'ValidationException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], 'fieldList' => [ 'shape' => 'ValidationExceptionFieldList', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'ValidationExceptionField' => [ 'type' => 'structure', 'required' => [ 'name', 'message', ], 'members' => [ 'name' => [ 'shape' => 'NonBlankString', ], 'message' => [ 'shape' => 'NonBlankString', ], ], ], 'ValidationExceptionFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ValidationExceptionField', ], ], 'VideoBoundingBox' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'state' => [ 'shape' => 'State', ], ], ], 'VideoExtractionCategory' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'state' => [ 'shape' => 'State', ], 'types' => [ 'shape' => 'VideoExtractionCategoryTypes', ], ], ], 'VideoExtractionCategoryType' => [ 'type' => 'string', 'enum' => [ 'CONTENT_MODERATION', 'TEXT_DETECTION', 'TRANSCRIPT', 'LOGOS', ], ], 'VideoExtractionCategoryTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'VideoExtractionCategoryType', ], ], 'VideoOverrideConfiguration' => [ 'type' => 'structure', 'members' => [ 'modalityProcessing' => [ 'shape' => 'ModalityProcessingConfiguration', ], 'sensitiveDataConfiguration' => [ 'shape' => 'SensitiveDataConfiguration', ], ], ], 'VideoStandardExtraction' => [ 'type' => 'structure', 'required' => [ 'category', 'boundingBox', ], 'members' => [ 'category' => [ 'shape' => 'VideoExtractionCategory', ], 'boundingBox' => [ 'shape' => 'VideoBoundingBox', ], ], ], 'VideoStandardGenerativeField' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'state' => [ 'shape' => 'State', ], 'types' => [ 'shape' => 'VideoStandardGenerativeFieldTypes', ], ], ], 'VideoStandardGenerativeFieldType' => [ 'type' => 'string', 'enum' => [ 'VIDEO_SUMMARY', 'IAB', 'CHAPTER_SUMMARY', ], ], 'VideoStandardGenerativeFieldTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'VideoStandardGenerativeFieldType', ], ], 'VideoStandardOutputConfiguration' => [ 'type' => 'structure', 'members' => [ 'extraction' => [ 'shape' => 'VideoStandardExtraction', ], 'generativeField' => [ 'shape' => 'VideoStandardGenerativeField', ], ], ], ],];
