function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0) { ; } } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { useState, useEffect } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { keysOf } from '../../common';
import { OuiIcon } from '../../icon';
import { OuiPopover } from '../../popover';
import { OuiI18n } from '../../i18n';
import { OuiHeaderSectionItemButton } from '../header_section';
import { OuiHideFor, OuiShowFor } from '../../responsive';
var gutterSizeToClassNameMap = {
  xs: '--gutterXS',
  s: '--gutterS',
  m: '--gutterM',
  l: '--gutterL'
};
export var GUTTER_SIZES = keysOf(gutterSizeToClassNameMap);
export var OuiHeaderLinks = function OuiHeaderLinks(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 's' : _ref$gutterSize,
    _ref$popoverBreakpoin = _ref.popoverBreakpoints,
    popoverBreakpoints = _ref$popoverBreakpoin === void 0 ? ['xs', 's'] : _ref$popoverBreakpoin,
    popoverButtonProps = _ref.popoverButtonProps,
    popoverProps = _ref.popoverProps,
    rest = _objectWithoutProperties(_ref, ["children", "className", "gutterSize", "popoverBreakpoints", "popoverButtonProps", "popoverProps"]);
  var _ref2 = popoverButtonProps !== null && popoverButtonProps !== void 0 ? popoverButtonProps : {},
    onClick = _ref2.onClick,
    _ref2$iconType = _ref2.iconType,
    iconType = _ref2$iconType === void 0 ? 'apps' : _ref2$iconType,
    popoverButtonRest = _objectWithoutProperties(_ref2, ["onClick", "iconType"]);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    mobileMenuIsOpen = _useState2[0],
    setMobileMenuIsOpen = _useState2[1];
  var onMenuButtonClick = function onMenuButtonClick(e) {
    onClick === null || onClick === void 0 ? void 0 : onClick(e);
    setMobileMenuIsOpen(!mobileMenuIsOpen);
  };
  var closeMenu = function closeMenu() {
    setMobileMenuIsOpen(false);
  };
  useEffect(function () {
    window.addEventListener('resize', closeMenu);
    return function () {
      window.removeEventListener('resize', closeMenu);
    };
  });
  var classes = classNames('ouiHeaderLinks', className);
  var button = /*#__PURE__*/React.createElement(OuiI18n, {
    token: "ouiHeaderLinks.openNavigationMenu",
    default: "Open menu"
  }, function (openNavigationMenu) {
    return /*#__PURE__*/React.createElement(OuiHeaderSectionItemButton, _extends({
      "aria-label": openNavigationMenu,
      onClick: onMenuButtonClick
    }, popoverButtonRest), /*#__PURE__*/React.createElement(OuiIcon, {
      type: iconType,
      size: "m"
    }));
  });
  return /*#__PURE__*/React.createElement(OuiI18n, {
    token: "ouiHeaderLinks.appNavigation",
    default: "App menu"
  }, function (appNavigation) {
    return /*#__PURE__*/React.createElement("nav", _extends({
      className: classes,
      "aria-label": appNavigation
    }, rest), /*#__PURE__*/React.createElement(OuiHideFor, {
      sizes: popoverBreakpoints
    }, /*#__PURE__*/React.createElement("div", {
      className: classNames('ouiHeaderLinks__list', ["ouiHeaderLinks__list".concat(gutterSizeToClassNameMap[gutterSize])])
    }, children)), /*#__PURE__*/React.createElement(OuiShowFor, {
      sizes: popoverBreakpoints
    }, /*#__PURE__*/React.createElement(OuiPopover, _extends({
      button: button,
      isOpen: mobileMenuIsOpen,
      anchorPosition: "downRight",
      closePopover: closeMenu,
      panelPaddingSize: "none"
    }, popoverProps), /*#__PURE__*/React.createElement("div", {
      className: classNames('ouiHeaderLinks__mobileList', ["ouiHeaderLinks__mobileList".concat(gutterSizeToClassNameMap[gutterSize])])
    }, children))));
  });
};

/* OUI -> EUI Aliases: Build-Time */
OuiHeaderLinks.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  /**
       * Spacing between direct children
       */
  gutterSize: PropTypes.oneOf(["xs", "s", "m", "l"]),
  /**
       * A list of named breakpoints at which to show the popover version
       */
  popoverBreakpoints: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOf(["xs", "s", "m", "l", "xl", "xxl", "xxxl"]).isRequired).isRequired, PropTypes.oneOf(["all", "none"])]),
  /**
       * Extend the functionality of the OuiPopover.button which is a OuiHeaderSectionItemButton.
       * With the addition of `iconType` to change the display icon which defaults to `apps`
       */
  popoverButtonProps: PropTypes.shape({
    iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addBookmark", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "anomalyDetection", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "bookOpen", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "chatLeft", "chatRight", "check", "checkInCircleEmpty", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "color", "compass", "compute", "console", "consoleApp", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "crossInCircleEmpty", "crossInCircleFilled", "currency", "cut", "dashboard", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentation", "documentEdit", "documents", "dot", "download", "dockedBottom", "dockedDetached", "dockedLeft", "dockedRight", "dockedTakeover", "dockedTop", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "eql", "eraser", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "functionAdd", "gear", "generate", "generateContent", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "history", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "inputOutput", "inspect", "integrationGeneral", "integrationObservability", "integrationSearch", "integrationSecurity", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "layers", "lensApp", "lineChart", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOpenSearch", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "percent", "pin", "pinFilled", "pipelineApp", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "polygon", "popout", "power", "pulse", "push", "questionInCircle", "quote", "radar", "radius", "recent", "recentlyViewedApp", "redeploy", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "rocket", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sparkleFilled", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "thumbsDown", "thumbsUp", "timeline", "timelionApp", "timeslider", "training", "trash", "upgradeAssistantApp", "uptimeApp", "undeploy", "unfold", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visBuilder", "visBuilderSavedObject", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visQueryDQL", "visQueryPPL", "visQueryPromQL", "visQuerySQL", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram", "wsAnalytics", "wsEssentials", "wsObservability", "wsSearch", "wsSecurityAnalytics", "wsSelector", "navAdministration", "navAiFlow", "navAlerting", "navAnomalyDetection", "navDashboards", "navData", "navDetectionRules", "navDevtools", "navDiscover", "navExperiments", "navGetStarted", "navInfo", "navInfra", "navIntegrations", "navJudgements", "navManage", "navMaps", "navModels", "navNotebooks", "navNotifications", "navOverview", "navQuerySets", "navReports", "navSecurityCases", "navSecurityFindings", "navServiceMap", "navServices", "navSlos", "navThreatIntel", "navTicketing", "navUi", "navSearchConfigurationsln"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired])
  }),
  /**
       * Extend the functionality of the OuiPopover
       */
  popoverProps: PropTypes.shape({
    /**
       * Class name passed to the direct parent of the button
       */
    anchorClassName: PropTypes.string,
    /**
       * Alignment of the popover and arrow relative to the button
       */
    anchorPosition: PropTypes.oneOf(["upCenter", "upLeft", "upRight", "downCenter", "downLeft", "downRight", "leftCenter", "leftUp", "leftDown", "rightCenter", "rightUp", "rightDown"]),
    /**
       * Style and position alteration for arrow-less, left-aligned
       * attachment. Intended for use with inputs as anchors, e.g.
       * OuiInputPopover
       */
    attachToAnchor: PropTypes.bool,
    buttonRef: PropTypes.any,
    /**
       * Restrict the popover's position within this element
       */
    container: PropTypes.any,
    /**
       * CSS display type for both the popover and anchor
       */
    display: PropTypes.oneOf(["inlineBlock", "block"]),
    /**
       * Object of props passed to OuiFocusTrap
       */
    focusTrapProps: PropTypes.any,
    /**
       * Show arrow indicating to originating button
       */
    hasArrow: PropTypes.bool,
    /**
       * Specifies what element should initially have focus; Can be a DOM
       * node, or a selector string (which will be passed to
       * document.querySelector() to find the DOM node), or a function that
       * returns a DOM node
       * Set to `false` to prevent initial auto-focus. Use only
       * when your app handles setting initial focus state.
       */
    initialFocus: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.string.isRequired, PropTypes.func.isRequired]).isRequired, PropTypes.oneOf([false])]),
    /**
       * Passed directly to OuiPortal for DOM positioning. Both properties are
       * required if prop is specified
       */
    insert: PropTypes.shape({
      sibling: PropTypes.any.isRequired,
      position: PropTypes.oneOf(["before", "after"]).isRequired
    }),
    /**
       * Visibility state of the popover
       */
    isOpen: PropTypes.bool,
    /**
       * Traps tab focus within the popover contents
       */
    ownFocus: PropTypes.bool,
    /**
       * Custom class added to the OuiPanel containing the popover contents
       */
    panelClassName: PropTypes.string,
    /**
       * OuiPanel padding on all sides
       */
    panelPaddingSize: PropTypes.any,
    /**
       * Standard DOM `style` attribute. Passed to the OuiPanel
       */
    panelStyle: PropTypes.any,
    /**
       * Object of props passed to OuiPanel
       */
    panelProps: PropTypes.any,
    panelRef: PropTypes.any,
    popoverRef: PropTypes.any,
    /**
       * When `true`, the popover's position is re-calculated when the user
       * scrolls, this supports having fixed-position popover anchors
       */
    repositionOnScroll: PropTypes.bool,
    /**
       * By default, popover content inherits the z-index of the anchor
       * component; pass `zIndex` to override
       */
    zIndex: PropTypes.number,
    /**
       * Function callback for when the focus trap is deactivated
       */
    onTrapDeactivation: PropTypes.any,
    /**
       * Distance away from the anchor that the popover will render
       */
    offset: PropTypes.number,
    /**
       * Minimum distance between the popover and the bounding container;
       * Pass an array of 4 values to adjust each side differently: `[top, right, bottom, left]`
       * Default is 16
       */
    buffer: PropTypes.oneOfType([PropTypes.number.isRequired, PropTypes.any.isRequired]),
    /**
       * Element to pass as the child element of the arrow;
       * Use case is typically limited to an accompanying `OuiBeacon`
       */
    arrowChildren: PropTypes.node,
    /**
       * Provide a name to the popover panel
       */
    "aria-label": PropTypes.string,
    /**
       * Alternative option to `aria-label` that takes an `id`.
       * Usually takes the `id` of the popover title
       */
    "aria-labelledby": PropTypes.string
  })
};
/* OUI -> EUI Aliases: Build-Time */export { EuiHeaderLinks } from '../../../eui_components/header/header_links/header_links';