/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * determinant(dmat2(1.6lf, 1.53lf, 0.76lf, -1.0lf)) => -2.7628000000000004lf
 * determinant(dmat2(-0.13lf, -1.4lf, -0.87lf, 1.4lf)) => -1.4lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(determinant(dmat2(1.6lf, 1.53lf, 0.76lf, -1.0lf)), -2.7628000000000004lf) <= 2.7628000000000007e-05lf ? 1 : -1] array0;
  double[distance(determinant(dmat2(-0.13lf, -1.4lf, -0.87lf, 1.4lf)), -1.4lf) <= 1.4e-05lf ? 1 : -1] array1;
  gl_FragColor = vec4(array0.length() + array1.length());
}
