/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) * 0ul) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) * 3ul) => u64vec3(3999999999999999777ul, 255ul, 282ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) * 1192ul) => u64vec3(2913342994311805752ul, 101320ul, 112048ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) * 1048576ul) => u64vec3(4153242812628860928ul, 89128960ul, 98566144ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) * 4251475ul) => u64vec3(4219714608934365073ul, 361375375ul, 399638650ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) * 29852643761ul) => u64vec3(12435611803786930075ul, 2537474719685ul, 2806148513534ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) * 4398046511104ul) => u64vec3(1536901751351803904ul, 373833953443840ul, 413416372043776ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) * 3948976685146ul) => u64vec3(18322276327564027358ul, 335663018237410ul, 371203808403724ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) * 135763469567146206ul) => u64vec3(11844925944747534218ul, 11539894913207427510ul, 12761766139311743364ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) * 11654173250180970009ul) => u64vec3(6211093075868999699ul, 12927290358776215117ul, 7134385168147635502ul)
 * (u64vec3(167ul, 66ul, 187ul) * 0ul) => u64vec3(0ul, 0ul, 0ul)
 * (u64vec3(167ul, 66ul, 187ul) * 3ul) => u64vec3(501ul, 198ul, 561ul)
 * (u64vec3(167ul, 66ul, 187ul) * 1192ul) => u64vec3(199064ul, 78672ul, 222904ul)
 * (u64vec3(167ul, 66ul, 187ul) * 1048576ul) => u64vec3(175112192ul, 69206016ul, 196083712ul)
 * (u64vec3(167ul, 66ul, 187ul) * 4251475ul) => u64vec3(709996325ul, 280597350ul, 795025825ul)
 * (u64vec3(167ul, 66ul, 187ul) * 29852643761ul) => u64vec3(4985391508087ul, 1970274488226ul, 5582444383307ul)
 * (u64vec3(167ul, 66ul, 187ul) * 4398046511104ul) => u64vec3(734473767354368ul, 290271069732864ul, 822434697576448ul)
 * (u64vec3(167ul, 66ul, 187ul) * 3948976685146ul) => u64vec3(659479106419382ul, 260632461219636ul, 738458640122302ul)
 * (u64vec3(167ul, 66ul, 187ul) * 135763469567146206ul) => u64vec3(4225755344003864786ul, 8960388991431649596ul, 6941024735346788906ul)
 * (u64vec3(167ul, 66ul, 187ul) * 11654173250180970009ul) => u64vec3(9338805040719071823ul, 12858927489852404338ul, 2614597086114300995ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) * 0ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array0;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) * 3ul), u64vec3(3999999999999999777ul, 255ul, 282ul))) ? 1 : -1] array1;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) * 1192ul), u64vec3(2913342994311805752ul, 101320ul, 112048ul))) ? 1 : -1] array2;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) * 1048576ul), u64vec3(4153242812628860928ul, 89128960ul, 98566144ul))) ? 1 : -1] array3;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) * 4251475ul), u64vec3(4219714608934365073ul, 361375375ul, 399638650ul))) ? 1 : -1] array4;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) * 29852643761ul), u64vec3(12435611803786930075ul, 2537474719685ul, 2806148513534ul))) ? 1 : -1] array5;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) * 4398046511104ul), u64vec3(1536901751351803904ul, 373833953443840ul, 413416372043776ul))) ? 1 : -1] array6;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) * 3948976685146ul), u64vec3(18322276327564027358ul, 335663018237410ul, 371203808403724ul))) ? 1 : -1] array7;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) * 135763469567146206ul), u64vec3(11844925944747534218ul, 11539894913207427510ul, 12761766139311743364ul))) ? 1 : -1] array8;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) * 11654173250180970009ul), u64vec3(6211093075868999699ul, 12927290358776215117ul, 7134385168147635502ul))) ? 1 : -1] array9;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) * 0ul), u64vec3(0ul, 0ul, 0ul))) ? 1 : -1] array10;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) * 3ul), u64vec3(501ul, 198ul, 561ul))) ? 1 : -1] array11;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) * 1192ul), u64vec3(199064ul, 78672ul, 222904ul))) ? 1 : -1] array12;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) * 1048576ul), u64vec3(175112192ul, 69206016ul, 196083712ul))) ? 1 : -1] array13;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) * 4251475ul), u64vec3(709996325ul, 280597350ul, 795025825ul))) ? 1 : -1] array14;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) * 29852643761ul), u64vec3(4985391508087ul, 1970274488226ul, 5582444383307ul))) ? 1 : -1] array15;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) * 4398046511104ul), u64vec3(734473767354368ul, 290271069732864ul, 822434697576448ul))) ? 1 : -1] array16;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) * 3948976685146ul), u64vec3(659479106419382ul, 260632461219636ul, 738458640122302ul))) ? 1 : -1] array17;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) * 135763469567146206ul), u64vec3(4225755344003864786ul, 8960388991431649596ul, 6941024735346788906ul))) ? 1 : -1] array18;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) * 11654173250180970009ul), u64vec3(9338805040719071823ul, 12858927489852404338ul, 2614597086114300995ul))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
