/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * max(uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u)) => uvec3(0u, 1u, 2u)
 * max(uvec3(0u, 0u, 1u), uvec3(5u, 34u, 0u)) => uvec3(5u, 34u, 1u)
 * max(uvec3(1u, 1u, 1u), uvec3(1u, 2u, 5u)) => uvec3(1u, 2u, 5u)
 * max(uvec3(1u, 2u, 2u), uvec3(34u, 0u, 1u)) => uvec3(34u, 2u, 2u)
 * max(uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u)) => uvec3(2u, 5u, 34u)
 * max(uvec3(5u, 5u, 5u), uvec3(0u, 1u, 2u)) => uvec3(5u, 5u, 5u)
 * max(uvec3(5u, 5u, 34u), uvec3(5u, 34u, 0u)) => uvec3(5u, 34u, 34u)
 * max(uvec3(34u, 34u, 34u), uvec3(1u, 2u, 5u)) => uvec3(34u, 34u, 34u)
 * max(uvec3(34u, 0u, 0u), uvec3(34u, 0u, 1u)) => uvec3(34u, 0u, 1u)
 */
#version 150

void main()
{
  float[all(equal(max(uvec3(0u, 0u, 0u), uvec3(0u, 1u, 2u)), uvec3(0u, 1u, 2u))) ? 1 : -1] array0;
  float[all(equal(max(uvec3(0u, 0u, 1u), uvec3(5u, 34u, 0u)), uvec3(5u, 34u, 1u))) ? 1 : -1] array1;
  float[all(equal(max(uvec3(1u, 1u, 1u), uvec3(1u, 2u, 5u)), uvec3(1u, 2u, 5u))) ? 1 : -1] array2;
  float[all(equal(max(uvec3(1u, 2u, 2u), uvec3(34u, 0u, 1u)), uvec3(34u, 2u, 2u))) ? 1 : -1] array3;
  float[all(equal(max(uvec3(2u, 2u, 2u), uvec3(2u, 5u, 34u)), uvec3(2u, 5u, 34u))) ? 1 : -1] array4;
  float[all(equal(max(uvec3(5u, 5u, 5u), uvec3(0u, 1u, 2u)), uvec3(5u, 5u, 5u))) ? 1 : -1] array5;
  float[all(equal(max(uvec3(5u, 5u, 34u), uvec3(5u, 34u, 0u)), uvec3(5u, 34u, 34u))) ? 1 : -1] array6;
  float[all(equal(max(uvec3(34u, 34u, 34u), uvec3(1u, 2u, 5u)), uvec3(34u, 34u, 34u))) ? 1 : -1] array7;
  float[all(equal(max(uvec3(34u, 0u, 0u), uvec3(34u, 0u, 1u)), uvec3(34u, 0u, 1u))) ? 1 : -1] array8;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
