/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 % ivec2(38, 35)) => ivec2(12, 12)
 * (12 % ivec2(64, 9)) => ivec2(12, 3)
 * (76 % ivec2(38, 35)) => ivec2(0, 6)
 * (76 % ivec2(64, 9)) => ivec2(12, 4)
 * (0 % ivec2(38, 35)) => ivec2(0, 0)
 * (0 % ivec2(64, 9)) => ivec2(0, 0)
 */
#version 150

void main()
{
  float[all(equal((12 % ivec2(38, 35)), ivec2(12, 12))) ? 1 : -1] array0;
  float[all(equal((12 % ivec2(64, 9)), ivec2(12, 3))) ? 1 : -1] array1;
  float[all(equal((76 % ivec2(38, 35)), ivec2(0, 6))) ? 1 : -1] array2;
  float[all(equal((76 % ivec2(64, 9)), ivec2(12, 4))) ? 1 : -1] array3;
  float[all(equal((0 % ivec2(38, 35)), ivec2(0, 0))) ? 1 : -1] array4;
  float[all(equal((0 % ivec2(64, 9)), ivec2(0, 0))) ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
