/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.hadoop.shaded.org.xbill.DNS.Master;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.RRSIGRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.RRset;
import org.apache.hadoop.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.shaded.org.xbill.DNS.SOARecord;
import org.apache.hadoop.shaded.org.xbill.DNS.SetResponse;
import org.apache.hadoop.shaded.org.xbill.DNS.ZoneTransferException;
import org.apache.hadoop.shaded.org.xbill.DNS.ZoneTransferIn;

public class Zone
implements Serializable {
    private static final long serialVersionUID = -9220510891189510942L;
    public static final int PRIMARY = 1;
    public static final int SECONDARY = 2;
    private Map<Name, Object> data;
    private Name origin;
    private Object originNode;
    private RRset NS;
    private SOARecord SOA;
    private boolean hasWild;

    private void validate() throws IOException {
        this.originNode = this.exactName(this.origin);
        if (this.originNode == null) {
            throw new IOException(this.origin + ": no data specified");
        }
        RRset rrset = this.oneRRset(this.originNode, 6);
        if (rrset == null || rrset.size() != 1) {
            throw new IOException(this.origin + ": exactly 1 SOA must be specified");
        }
        this.SOA = (SOARecord)rrset.rrs().get(0);
        this.NS = this.oneRRset(this.originNode, 2);
        if (this.NS == null) {
            throw new IOException(this.origin + ": no NS set specified");
        }
    }

    private void maybeAddRecord(Record record) throws IOException {
        int rtype = record.getType();
        Name name = record.getName();
        if (rtype == 6 && !name.equals(this.origin)) {
            throw new IOException("SOA owner " + name + " does not match zone origin " + this.origin);
        }
        if (name.subdomain(this.origin)) {
            this.addRecord(record);
        }
    }

    public Zone(Name zone, String file) throws IOException {
        this.data = new TreeMap<Name, Object>();
        if (zone == null) {
            throw new IllegalArgumentException("no zone name specified");
        }
        try (Master m4 = new Master(file, zone);){
            Record record;
            this.origin = zone;
            while ((record = m4.nextRecord()) != null) {
                this.maybeAddRecord(record);
            }
        }
        this.validate();
    }

    public Zone(Name zone, Record[] records) throws IOException {
        this.data = new TreeMap<Name, Object>();
        if (zone == null) {
            throw new IllegalArgumentException("no zone name specified");
        }
        this.origin = zone;
        for (Record record : records) {
            this.maybeAddRecord(record);
        }
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fromXFR(ZoneTransferIn xfrin2) throws IOException, ZoneTransferException {
        Zone zone = this;
        synchronized (zone) {
            this.data = new TreeMap<Name, Object>();
        }
        this.origin = xfrin2.getName();
        xfrin2.run();
        if (!xfrin2.isAXFR()) {
            throw new IllegalArgumentException("zones can only be created from AXFRs");
        }
        for (Record record : xfrin2.getAXFR()) {
            this.maybeAddRecord(record);
        }
        this.validate();
    }

    public Zone(ZoneTransferIn xfrin2) throws IOException, ZoneTransferException {
        this.fromXFR(xfrin2);
    }

    public Zone(Name zone, int dclass, String remote) throws IOException, ZoneTransferException {
        ZoneTransferIn xfrin2 = ZoneTransferIn.newAXFR(zone, remote, null);
        xfrin2.setDClass(dclass);
        this.fromXFR(xfrin2);
    }

    public Name getOrigin() {
        return this.origin;
    }

    public RRset getNS() {
        return this.NS;
    }

    public SOARecord getSOA() {
        return this.SOA;
    }

    public int getDClass() {
        return 1;
    }

    private synchronized Object exactName(Name name) {
        return this.data.get(name);
    }

    private synchronized RRset[] allRRsets(Object types) {
        if (types instanceof List) {
            List typelist = (List)types;
            return typelist.toArray(new RRset[0]);
        }
        RRset set = (RRset)types;
        return new RRset[]{set};
    }

    private synchronized RRset oneRRset(Object types, int type) {
        if (type == 255) {
            throw new IllegalArgumentException("oneRRset(ANY)");
        }
        if (types instanceof List) {
            List list = (List)types;
            for (RRset set : list) {
                if (set.getType() != type) continue;
                return set;
            }
        } else {
            RRset set = (RRset)types;
            if (set.getType() == type) {
                return set;
            }
        }
        return null;
    }

    private synchronized RRset findRRset(Name name, int type) {
        Object types = this.exactName(name);
        if (types == null) {
            return null;
        }
        return this.oneRRset(types, type);
    }

    private synchronized void addRRset(Name name, RRset rrset) {
        Object types;
        if (!this.hasWild && name.isWild()) {
            this.hasWild = true;
        }
        if ((types = this.data.get(name)) == null) {
            this.data.put(name, rrset);
            return;
        }
        int rtype = rrset.getType();
        if (types instanceof List) {
            List list = (List)types;
            for (int i = 0; i < list.size(); ++i) {
                RRset set = (RRset)list.get(i);
                if (set.getType() != rtype) continue;
                list.set(i, rrset);
                return;
            }
            list.add(rrset);
        } else {
            RRset set = (RRset)types;
            if (set.getType() == rtype) {
                this.data.put(name, rrset);
            } else {
                LinkedList<RRset> list = new LinkedList<RRset>();
                list.add(set);
                list.add(rrset);
                this.data.put(name, list);
            }
        }
    }

    private synchronized void removeRRset(Name name, int type) {
        Object types = this.data.get(name);
        if (types == null) {
            return;
        }
        if (types instanceof List) {
            List list = (List)types;
            for (int i = 0; i < list.size(); ++i) {
                RRset set = (RRset)list.get(i);
                if (set.getType() != type) continue;
                list.remove(i);
                if (list.size() == 0) {
                    this.data.remove(name);
                }
                return;
            }
        } else {
            RRset set = (RRset)types;
            if (set.getType() != type) {
                return;
            }
            this.data.remove(name);
        }
    }

    private synchronized SetResponse lookup(Name name, int type) {
        int olabels;
        if (!name.subdomain(this.origin)) {
            return SetResponse.ofType(1);
        }
        int labels = name.labels();
        for (int tlabels = olabels = this.origin.labels(); tlabels <= labels; ++tlabels) {
            RRset rrset;
            RRset ns;
            boolean isExact;
            boolean isOrigin = tlabels == olabels;
            boolean bl = isExact = tlabels == labels;
            Name tname = isOrigin ? this.origin : (isExact ? name : new Name(name, labels - tlabels));
            Object types = this.exactName(tname);
            if (types == null) continue;
            if (!isOrigin && (ns = this.oneRRset(types, 2)) != null) {
                return new SetResponse(3, ns);
            }
            if (isExact && type == 255) {
                SetResponse sr = new SetResponse(6);
                for (RRset set : this.allRRsets(types)) {
                    sr.addRRset(set);
                }
                return sr;
            }
            if (isExact) {
                rrset = this.oneRRset(types, type);
                if (rrset != null) {
                    return new SetResponse(6, rrset);
                }
                rrset = this.oneRRset(types, 5);
                if (rrset != null) {
                    return new SetResponse(4, rrset);
                }
            } else {
                rrset = this.oneRRset(types, 39);
                if (rrset != null) {
                    return new SetResponse(5, rrset);
                }
            }
            if (!isExact) continue;
            return SetResponse.ofType(2);
        }
        if (this.hasWild) {
            for (int i = 0; i < labels - olabels; ++i) {
                Name tname = name.wild(i + 1);
                Object types = this.exactName(tname);
                if (types == null) continue;
                if (type == 255) {
                    SetResponse sr = new SetResponse(6);
                    for (RRset set : this.allRRsets(types)) {
                        sr.addRRset(this.expandSet(set, name));
                    }
                    return sr;
                }
                RRset rrset = this.oneRRset(types, type);
                if (rrset == null) continue;
                return new SetResponse(6, this.expandSet(rrset, name));
            }
        }
        return SetResponse.ofType(1);
    }

    private RRset expandSet(RRset set, Name tname) {
        RRset expandedSet = new RRset();
        for (Record record : set.rrs()) {
            expandedSet.addRR(record.withName(tname));
        }
        for (RRSIGRecord rRSIGRecord : set.sigs()) {
            expandedSet.addRR(rRSIGRecord.withName(tname));
        }
        return expandedSet;
    }

    public SetResponse findRecords(Name name, int type) {
        return this.lookup(name, type);
    }

    public RRset findExactMatch(Name name, int type) {
        Object types = this.exactName(name);
        if (types == null) {
            return null;
        }
        return this.oneRRset(types, type);
    }

    public void addRRset(RRset rrset) {
        Name name = rrset.getName();
        this.addRRset(name, rrset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Record> void addRecord(T r) {
        Name name = r.getName();
        int rtype = r.getRRsetType();
        Zone zone = this;
        synchronized (zone) {
            RRset rrset = this.findRRset(name, rtype);
            if (rrset == null) {
                rrset = new RRset((Record)r);
                this.addRRset(name, rrset);
            } else {
                rrset.addRR(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecord(Record r) {
        Name name = r.getName();
        int rtype = r.getRRsetType();
        Zone zone = this;
        synchronized (zone) {
            RRset rrset = this.findRRset(name, rtype);
            if (rrset == null) {
                return;
            }
            if (rrset.size() == 1 && rrset.first().equals(r)) {
                this.removeRRset(name, rtype);
            } else {
                rrset.deleteRR(r);
            }
        }
    }

    public Iterator<RRset> iterator() {
        return new ZoneIterator(false);
    }

    public Iterator<RRset> AXFR() {
        return new ZoneIterator(true);
    }

    private void nodeToString(StringBuffer sb, Object node) {
        RRset[] sets;
        for (RRset rrset : sets = this.allRRsets(node)) {
            rrset.rrs().forEach(r -> sb.append(r).append('\n'));
            rrset.sigs().forEach(r -> sb.append(r).append('\n'));
        }
    }

    public synchronized String toMasterFile() {
        StringBuffer sb = new StringBuffer();
        this.nodeToString(sb, this.originNode);
        for (Map.Entry<Name, Object> entry : this.data.entrySet()) {
            if (this.origin.equals(entry.getKey())) continue;
            this.nodeToString(sb, entry.getValue());
        }
        return sb.toString();
    }

    public String toString() {
        return this.toMasterFile();
    }

    class ZoneIterator
    implements Iterator<RRset> {
        private Iterator<Map.Entry<Name, Object>> zentries;
        private RRset[] current;
        private int count;
        private boolean wantLastSOA;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ZoneIterator(boolean axfr) {
            Zone zone = Zone.this;
            synchronized (zone) {
                this.zentries = Zone.this.data.entrySet().iterator();
            }
            this.wantLastSOA = axfr;
            RRset[] sets = Zone.this.allRRsets(Zone.this.originNode);
            this.current = new RRset[sets.length];
            int j = 2;
            for (int i = 0; i < sets.length; ++i) {
                int type = sets[i].getType();
                if (type == 6) {
                    this.current[0] = sets[i];
                    continue;
                }
                if (type == 2) {
                    this.current[1] = sets[i];
                    continue;
                }
                this.current[j++] = sets[i];
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null || this.wantLastSOA;
        }

        @Override
        public RRset next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.current == null) {
                this.wantLastSOA = false;
                return Zone.this.oneRRset(Zone.this.originNode, 6);
            }
            RRset set = this.current[this.count++];
            if (this.count == this.current.length) {
                this.current = null;
                while (this.zentries.hasNext()) {
                    RRset[] sets;
                    Map.Entry<Name, Object> entry = this.zentries.next();
                    if (entry.getKey().equals(Zone.this.origin) || (sets = Zone.this.allRRsets(entry.getValue())).length == 0) continue;
                    this.current = sets;
                    this.count = 0;
                    break;
                }
            }
            return set;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

