/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.PrintStream;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;

public class SnapshotDeleteTool
extends ToolBase {
    public SnapshotDeleteTool() {
        this(CLIO.getOutStream());
    }

    public SnapshotDeleteTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "snapshot-delete";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED_SHORT, Option.builder((String)"c").longOpt("name").argName("NAME").hasArg().required(true).desc("Name of collection to manage.").build(), Option.builder().longOpt("snapshot-name").argName("NAME").hasArg().required(true).desc("Name of the snapshot to delete").build(), SolrCLI.OPTION_CREDENTIALS);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String snapshotName = cli.getOptionValue("snapshot-name");
        String collectionName = cli.getOptionValue("name");
        try (SolrClient solrClient = SolrCLI.getSolrClient(cli);){
            this.deleteSnapshot(solrClient, collectionName, snapshotName);
        }
    }

    public void deleteSnapshot(SolrClient solrClient, String collectionName, String snapshotName) {
        CollectionAdminRequest.DeleteSnapshot deleteSnapshot = new CollectionAdminRequest.DeleteSnapshot(collectionName, snapshotName);
        try {
            CollectionAdminResponse resp = (CollectionAdminResponse)deleteSnapshot.process(solrClient);
            if (resp.getStatus() != 0) {
                throw new IllegalStateException("The DELETESNAPSHOT request failed. The status code is " + resp.getStatus());
            }
            this.echo("Successfully deleted snapshot with name " + snapshotName + " for collection " + collectionName);
        }
        catch (Exception e) {
            this.echo("Failed to delete a snapshot with name " + snapshotName + " for collection " + collectionName + " due to following error : " + e.getLocalizedMessage());
        }
    }
}

