/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.filestore;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.solr.filestore.FileStoreAPI;
import org.apache.zookeeper.server.ByteBufferInputStream;

public interface FileStore {
    public void put(FileEntry var1) throws IOException;

    public void get(String var1, Consumer<FileEntry> var2, boolean var3) throws IOException;

    public boolean fetch(String var1, String var2);

    public List<FileDetails> list(String var1, Predicate<String> var2);

    public void syncToAllNodes(String var1) throws IOException;

    public Path getRealpath(String var1);

    public FileType getType(String var1, boolean var2);

    public Map<String, byte[]> getKeys() throws IOException;

    public void refresh(String var1);

    public void delete(String var1);

    public void deleteLocal(String var1);

    public static interface FileDetails {
        public String getSimpleName();

        public FileStoreAPI.MetaData getMetaData();

        public Date getTimeStamp();

        public long size();

        public boolean isDir();
    }

    public static enum FileType {
        FILE,
        DIRECTORY,
        NOFILE,
        METADATA;

    }

    public static class FileEntry {
        final ByteBuffer buf;
        final FileStoreAPI.MetaData meta;
        final String path;

        FileEntry(ByteBuffer buf, FileStoreAPI.MetaData meta, String path) {
            this.buf = buf;
            this.meta = meta;
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public InputStream getInputStream() {
            if (this.buf != null) {
                return new ByteBufferInputStream(this.buf);
            }
            return null;
        }

        public ByteBuffer getBuffer() {
            return this.buf;
        }

        public FileStoreAPI.MetaData getMetaData() {
            return this.meta;
        }
    }
}

