/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.solr.client.solrj.io.ModelCache;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.DaemonStream;
import org.apache.solr.client.solrj.io.stream.ExceptionStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParser;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.routing.RequestReplicaListTransformerGenerator;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.cloud.NodesSysProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.SolrDefaultStreamFactory;
import org.apache.solr.pkg.PackagePluginHolder;
import org.apache.solr.pkg.SolrPackageLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamHandler
extends RequestHandlerBase
implements SolrCoreAware,
PermissionNameProvider {
    private ModelCache modelCache;
    private ConcurrentMap<String, ConcurrentMap<String, Object>> objectCache;
    private SolrDefaultStreamFactory streamFactory = new SolrDefaultStreamFactory();
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String coreName;
    private SolrClientCache solrClientCache;
    private Map<String, DaemonStream> daemons = new ConcurrentHashMap<String, DaemonStream>();

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    @Override
    public void inform(SolrCore core) {
        CoreContainer coreContainer = core.getCoreContainer();
        this.solrClientCache = coreContainer.getSolrClientCache();
        this.coreName = core.getName();
        String cacheKey = this.getClass().getName() + "_" + this.coreName + "_";
        this.objectCache = (ConcurrentMap)coreContainer.getObjectCache().computeIfAbsent(cacheKey + "objectCache", ConcurrentHashMap.class, k -> new ConcurrentHashMap());
        if (coreContainer.isZooKeeperAware()) {
            String defaultCollection = core.getCoreDescriptor().getCollectionName();
            String defaultZkhost = core.getCoreContainer().getZkController().getZkServerAddress();
            this.streamFactory.withCollectionZkHost(defaultCollection, defaultZkhost);
            this.streamFactory.withDefaultZkHost(defaultZkhost);
            this.modelCache = (ModelCache)coreContainer.getObjectCache().computeIfAbsent(cacheKey + "modelCache", ModelCache.class, k -> new ModelCache(250, defaultZkhost, this.solrClientCache));
        }
        this.streamFactory.withSolrResourceLoader(core.getResourceLoader());
        StreamHandler.addExpressiblePlugins((StreamFactory)this.streamFactory, core);
    }

    public static void addExpressiblePlugins(StreamFactory streamFactory, SolrCore core) {
        List<PluginInfo> pluginInfos = core.getSolrConfig().getPluginInfos(Expressible.class.getName());
        for (PluginInfo pluginInfo : pluginInfos) {
            if (pluginInfo.pkgName != null) {
                ExpressibleHolder holder = new ExpressibleHolder(pluginInfo, core, SolrConfig.classVsSolrPluginInfo.get(Expressible.class.getName()));
                streamFactory.withFunctionName(pluginInfo.name, (Supplier)holder);
                continue;
            }
            Class<Expressible> clazz = core.getResourceLoader().findClass(pluginInfo.className, Expressible.class);
            streamFactory.withFunctionName(pluginInfo.name, clazz);
        }
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        TupleStream tupleStream;
        SolrParams params = req.getParams();
        params = this.adjustParams(params);
        req.setParams(params);
        if (params.get("action") != null) {
            this.handleAdmin(req, rsp, params);
            return;
        }
        try {
            StreamExpression streamExpression = StreamExpressionParser.parse((String)params.get("expr"));
            if (this.streamFactory.isEvaluator(streamExpression)) {
                StreamExpression tupleExpression = new StreamExpression("tuple");
                tupleExpression.addParameter((StreamExpressionParameter)new StreamExpressionNamedParameter("return-value", (StreamExpressionParameter)streamExpression));
                tupleStream = this.streamFactory.constructStream(tupleExpression);
            } else {
                tupleStream = this.streamFactory.constructStream(streamExpression);
            }
        }
        catch (Exception e) {
            log.error("Exception creating stream", (Throwable)e);
            rsp.add("result-set", (Object)new DummyErrorStream(e));
            return;
        }
        SolrCore core = req.getCore();
        ZkController zkController = core == null ? null : core.getCoreContainer().getZkController();
        RequestReplicaListTransformerGenerator requestReplicaListTransformerGenerator = zkController != null ? new RequestReplicaListTransformerGenerator(zkController.getZkStateReader().getClusterProperties().getOrDefault("defaultShardPreferences", "").toString(), zkController.getNodeName(), zkController.getBaseUrl(), (NodesSysProps)zkController.getSysPropsCacher()) : new RequestReplicaListTransformerGenerator();
        int worker = params.getInt("workerID", 0);
        int numWorkers = params.getInt("numWorkers", 1);
        boolean local = params.getBool("streamLocalOnly", false);
        StreamContext context = new StreamContext();
        context.setRequestParams(params);
        context.setRequestReplicaListTransformerGenerator(requestReplicaListTransformerGenerator);
        context.put("shards", this.getCollectionShards(params));
        context.workerID = worker;
        context.numWorkers = numWorkers;
        context.setSolrClientCache(this.solrClientCache);
        context.setModelCache(this.modelCache);
        context.setObjectCache(this.objectCache);
        context.put("core", (Object)this.coreName);
        context.put("solr-core", (Object)req.getCore());
        context.setLocal(local);
        tupleStream.setStreamContext(context);
        if (params.getBool("explain", false)) {
            rsp.add("explanation", tupleStream.toExplanation((StreamFactory)this.streamFactory));
        }
        if (tupleStream instanceof DaemonStream) {
            DaemonStream daemonStream = (DaemonStream)tupleStream;
            if (this.daemons.containsKey(daemonStream.getId())) {
                this.daemons.remove(daemonStream.getId()).close();
            }
            daemonStream.setDaemons(this.daemons);
            daemonStream.open();
            this.daemons.put(daemonStream.getId(), daemonStream);
            rsp.add("result-set", (Object)new DaemonResponseStream("Daemon:" + daemonStream.getId() + " started on " + this.coreName));
        } else {
            rsp.add("result-set", (Object)new TimerStream((TupleStream)new ExceptionStream(tupleStream)));
        }
    }

    private void handleAdmin(SolrQueryRequest req, SolrQueryResponse rsp, SolrParams params) {
        String action = params.get("action").toLowerCase(Locale.ROOT).trim();
        if ("plugins".equals(action)) {
            rsp.add("plugins", ew -> this.streamFactory.getFunctionNames().forEach((s, classSupplier) -> ew.putNoEx((CharSequence)s, (Object)((Class)classSupplier.get()).getName())));
            return;
        }
        if ("list".equals(action)) {
            Collection<DaemonStream> vals = this.daemons.values();
            rsp.add("result-set", (Object)new DaemonCollectionStream(vals));
            return;
        }
        String id = params.get("id");
        DaemonStream d = this.daemons.get(id);
        if (d == null) {
            rsp.add("result-set", (Object)new DaemonResponseStream("Daemon:" + id + " not found on " + this.coreName));
            return;
        }
        switch (action) {
            case "stop": {
                d.close();
                rsp.add("result-set", (Object)new DaemonResponseStream("Daemon:" + id + " stopped on " + this.coreName));
                break;
            }
            case "start": {
                try {
                    d.open();
                }
                catch (IOException e) {
                    rsp.add("result-set", (Object)new DaemonResponseStream("Daemon: " + id + " error: " + e.getMessage()));
                }
                rsp.add("result-set", (Object)new DaemonResponseStream("Daemon:" + id + " started on " + this.coreName));
                break;
            }
            case "kill": {
                this.daemons.remove(id);
                d.close();
                rsp.add("result-set", (Object)new DaemonResponseStream("Daemon:" + id + " killed on " + this.coreName));
                break;
            }
            default: {
                rsp.add("result-set", (Object)new DaemonResponseStream("Daemon:" + id + " action '" + action + "' not recognized on " + this.coreName));
            }
        }
    }

    private SolrParams adjustParams(SolrParams params) {
        ModifiableSolrParams adjustedParams = new ModifiableSolrParams();
        adjustedParams.add(params);
        adjustedParams.add("omitHeader", new String[]{"true"});
        return adjustedParams;
    }

    @Override
    public String getDescription() {
        return "StreamHandler";
    }

    public String getSource() {
        return null;
    }

    private Map<String, List<String>> getCollectionShards(SolrParams params) {
        HashMap<String, List<String>> collectionShards = new HashMap<String, List<String>>();
        Iterator paramsIt = params.getParameterNamesIterator();
        while (paramsIt.hasNext()) {
            String param = (String)paramsIt.next();
            if (!param.contains(".shards")) continue;
            String collection = param.split("\\.")[0];
            String shardString = params.get(param);
            String[] shards = shardString.split(",");
            ArrayList<String> shardList = new ArrayList<String>();
            for (String shard : shards) {
                shardList.add(shard);
            }
            collectionShards.put(collection, shardList);
        }
        if (collectionShards.size() > 0) {
            return collectionShards;
        }
        return null;
    }

    public static class TimerStream
    extends TupleStream {
        private long begin;
        private TupleStream tupleStream;

        public TimerStream(TupleStream tupleStream) {
            this.tupleStream = tupleStream;
        }

        public StreamComparator getStreamSort() {
            return this.tupleStream.getStreamSort();
        }

        public void close() throws IOException {
            this.tupleStream.close();
        }

        public void open() throws IOException {
            this.begin = System.nanoTime();
            this.tupleStream.open();
        }

        public void setStreamContext(StreamContext context) {
            this.tupleStream.setStreamContext(context);
        }

        public List<TupleStream> children() {
            return this.tupleStream.children();
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("timer").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator").withExpression("--non-expressible--");
        }

        public Tuple read() throws IOException {
            Tuple tuple = this.tupleStream.read();
            if (tuple.EOF) {
                long totalTime = (System.nanoTime() - this.begin) / 1000000L;
                tuple.put("RESPONSE_TIME", (Object)totalTime);
            }
            return tuple;
        }
    }

    public static class DaemonResponseStream
    extends TupleStream {
        private String message;
        private boolean sendEOF = false;

        public DaemonResponseStream(String message) {
            this.message = message;
        }

        public StreamComparator getStreamSort() {
            return null;
        }

        public void close() {
        }

        public void open() {
        }

        public void setStreamContext(StreamContext context) {
        }

        public List<TupleStream> children() {
            return null;
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("daemon-response").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator").withExpression("--non-expressible--");
        }

        public Tuple read() {
            if (this.sendEOF) {
                return Tuple.EOF();
            }
            this.sendEOF = true;
            return new Tuple("DaemonOp", (Object)this.message);
        }
    }

    public static class DaemonCollectionStream
    extends TupleStream {
        private Iterator<DaemonStream> it;

        public DaemonCollectionStream(Collection<DaemonStream> col) {
            this.it = col.iterator();
        }

        public StreamComparator getStreamSort() {
            return null;
        }

        public void close() {
        }

        public void open() {
        }

        public void setStreamContext(StreamContext context) {
        }

        public List<TupleStream> children() {
            return null;
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("daemon-collection").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator").withExpression("--non-expressible--");
        }

        public Tuple read() {
            if (this.it.hasNext()) {
                return this.it.next().getInfo();
            }
            return Tuple.EOF();
        }
    }

    public static class DummyErrorStream
    extends TupleStream {
        private Exception e;

        public DummyErrorStream(Exception e) {
            this.e = e;
        }

        public StreamComparator getStreamSort() {
            return null;
        }

        public void close() {
        }

        public void open() {
        }

        public void setStreamContext(StreamContext context) {
        }

        public List<TupleStream> children() {
            return null;
        }

        public Explanation toExplanation(StreamFactory factory) throws IOException {
            return new StreamExplanation(this.getStreamNodeId().toString()).withFunctionName("error").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator").withExpression("--non-expressible--");
        }

        public Tuple read() {
            String msg = this.e.getMessage();
            for (Throwable t = this.e.getCause(); t != null; t = t.getCause()) {
                msg = t.getMessage();
            }
            return Tuple.EXCEPTION((String)msg, (boolean)true);
        }
    }

    public static class ExpressibleHolder
    extends PackagePluginHolder<Class<? extends Expressible>> {
        private Class<? extends Expressible> clazz;

        public ExpressibleHolder(PluginInfo info, SolrCore core, SolrConfig.SolrPluginInfo pluginMeta) {
            super(info, core, pluginMeta);
        }

        @Override
        public Class<? extends Expressible> get() {
            return this.clazz;
        }

        @Override
        protected Object initNewInstance(SolrPackageLoader.SolrPackage.Version newest, SolrCore core) {
            this.clazz = newest.getLoader().findClass(this.pluginInfo.className, Expressible.class);
            return this.clazz;
        }
    }
}

