/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.profile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.SortedSet;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.profile.SimpleProfiler;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.JsonBuilder;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Profiler {
    public Profile profile(Iterable<List<Comparable>> var1, List<Column> var2, Collection<ImmutableBitSet> var3);

    public static class Profile {
        public final RowCount rowCount;
        public final List<FunctionalDependency> functionalDependencyList;
        public final List<Distribution> distributionList;
        public final List<Unique> uniqueList;
        private final Map<ImmutableBitSet, Distribution> distributionMap;
        private final List<Distribution> singletonDistributionList;

        Profile(List<Column> columns, RowCount rowCount, Iterable<FunctionalDependency> functionalDependencyList, Iterable<Distribution> distributionList, Iterable<Unique> uniqueList) {
            this.rowCount = rowCount;
            this.functionalDependencyList = ImmutableList.copyOf(functionalDependencyList);
            this.distributionList = ImmutableList.copyOf(distributionList);
            this.uniqueList = ImmutableList.copyOf(uniqueList);
            ImmutableMap.Builder m = ImmutableMap.builder();
            for (Distribution distribution : distributionList) {
                m.put((Object)distribution.columnOrdinals(), (Object)distribution);
            }
            this.distributionMap = m.build();
            ImmutableList.Builder b = ImmutableList.builder();
            for (int i = 0; i < columns.size(); ++i) {
                int key = i;
                b.add((Object)Objects.requireNonNull(this.distributionMap.get(ImmutableBitSet.of(i)), () -> "distributionMap.get(ImmutableBitSet.of(i)) for " + key));
            }
            this.singletonDistributionList = b.build();
        }

        public List<Statistic> statistics() {
            return ImmutableList.builder().add((Object)this.rowCount).addAll(this.functionalDependencyList).addAll(this.distributionList).addAll(this.uniqueList).build();
        }

        public double cardinality(ImmutableBitSet columnOrdinals) {
            ImmutableBitSet originalOrdinals = columnOrdinals;
            while (true) {
                Distribution distribution;
                if ((distribution = this.distributionMap.get(columnOrdinals)) != null) {
                    if (columnOrdinals == originalOrdinals) {
                        return distribution.cardinality;
                    }
                    ArrayList<Double> cardinalityList = new ArrayList<Double>();
                    cardinalityList.add(distribution.cardinality);
                    for (int ordinal : originalOrdinals.except(columnOrdinals)) {
                        Distribution d = this.singletonDistributionList.get(ordinal);
                        cardinalityList.add(d.cardinality);
                    }
                    return Lattice.getRowCount((double)this.rowCount.rowCount, cardinalityList);
                }
                List<Integer> list = columnOrdinals.asList();
                columnOrdinals = columnOrdinals.clear(Util.last(list));
            }
        }
    }

    public static class Distribution
    implements Statistic {
        static final MathContext ROUND5 = new MathContext(5, RoundingMode.HALF_EVEN);
        static final MathContext ROUND3 = new MathContext(3, RoundingMode.HALF_EVEN);
        final NavigableSet<Column> columns;
        final @Nullable NavigableSet<Comparable> values;
        final double cardinality;
        final int nullCount;
        final double expectedCardinality;
        final boolean minimal;

        public Distribution(SortedSet<Column> columns, @Nullable SortedSet<Comparable> values, double cardinality, int nullCount, double expectedCardinality, boolean minimal) {
            this.columns = ImmutableSortedSet.copyOf(columns);
            this.values = values == null ? null : ImmutableSortedSet.copyOf(values);
            this.cardinality = cardinality;
            this.nullCount = nullCount;
            this.expectedCardinality = expectedCardinality;
            this.minimal = minimal;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object toMap(JsonBuilder jsonBuilder) {
            Map<String, @Nullable Object> map = jsonBuilder.map();
            map.put("type", "distribution");
            map.put("columns", FunctionalDependency.getObjects(jsonBuilder, this.columns));
            if (this.values != null) {
                List<@Nullable Object> list = jsonBuilder.list();
                for (Comparable comparable : this.values) {
                    void var5_5;
                    if (comparable instanceof Date) {
                        String string = comparable.toString();
                    }
                    list.add(var5_5);
                }
                map.put("values", list);
            }
            map.put("cardinality", new BigDecimal(this.cardinality, ROUND5));
            if (this.nullCount > 0) {
                map.put("nullCount", this.nullCount);
            }
            map.put("expectedCardinality", new BigDecimal(this.expectedCardinality, ROUND5));
            map.put("surprise", new BigDecimal(this.surprise(), ROUND3));
            return map;
        }

        ImmutableBitSet columnOrdinals() {
            return Column.toOrdinals(this.columns);
        }

        double surprise() {
            return SimpleProfiler.surprise(this.expectedCardinality, this.cardinality);
        }
    }

    public static class FunctionalDependency
    implements Statistic {
        final NavigableSet<Column> columns;
        final Column dependentColumn;

        FunctionalDependency(SortedSet<Column> columns, Column dependentColumn) {
            this.columns = ImmutableSortedSet.copyOf(columns);
            this.dependentColumn = dependentColumn;
        }

        @Override
        public Object toMap(JsonBuilder jsonBuilder) {
            Map<String, @Nullable Object> map = jsonBuilder.map();
            map.put("type", "fd");
            map.put("columns", FunctionalDependency.getObjects(jsonBuilder, this.columns));
            map.put("dependentColumn", this.dependentColumn.name);
            return map;
        }

        private static List<@Nullable Object> getObjects(JsonBuilder jsonBuilder, NavigableSet<Column> columns) {
            List<@Nullable Object> list = jsonBuilder.list();
            for (Column column : columns) {
                list.add(column.name);
            }
            return list;
        }
    }

    public static class Unique
    implements Statistic {
        final NavigableSet<Column> columns;

        public Unique(SortedSet<Column> columns) {
            this.columns = ImmutableSortedSet.copyOf(columns);
        }

        @Override
        public Object toMap(JsonBuilder jsonBuilder) {
            Map<String, @Nullable Object> map = jsonBuilder.map();
            map.put("type", "unique");
            map.put("columns", FunctionalDependency.getObjects(jsonBuilder, this.columns));
            return map;
        }
    }

    public static class RowCount
    implements Statistic {
        final int rowCount;

        public RowCount(int rowCount) {
            this.rowCount = rowCount;
        }

        @Override
        public Object toMap(JsonBuilder jsonBuilder) {
            Map<String, @Nullable Object> map = jsonBuilder.map();
            map.put("type", "rowCount");
            map.put("rowCount", this.rowCount);
            return map;
        }
    }

    public static interface Statistic {
        public Object toMap(JsonBuilder var1);
    }

    public static class Column
    implements Comparable<Column> {
        public final int ordinal;
        public final String name;

        public Column(int ordinal, String name) {
            this.ordinal = ordinal;
            this.name = name;
        }

        static ImmutableBitSet toOrdinals(Iterable<Column> columns) {
            ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
            for (Column column : columns) {
                builder.set(column.ordinal);
            }
            return builder.build();
        }

        public int hashCode() {
            return this.ordinal;
        }

        public boolean equals(@Nullable Object o) {
            return this == o || o instanceof Column && this.ordinal == ((Column)o).ordinal;
        }

        @Override
        public int compareTo(Column column) {
            return Integer.compare(this.ordinal, column.ordinal);
        }

        public String toString() {
            return this.name;
        }
    }
}

