/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.locks.Lock;
import kafka.coordinator.group.ListenerAdapter;
import kafka.server.ActionQueue;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.runtime.PartitionWriter;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001B\b\u0011\u0001]A\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u001d\u0019\u0007A1A\u0005\n\u0011Daa\u001c\u0001!\u0002\u0013)\u0007b\u00029\u0001\u0005\u0004%I!\u001d\u0005\u0007k\u0002\u0001\u000b\u0011\u0002:\t\u000bq\u0004A\u0011I?\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c!9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0002bBA&\u0001\u0011\u0005\u0013Q\n\u0005\b\u0003_\u0002A\u0011BA9\u0005i\u0019un\u001c:eS:\fGo\u001c:QCJ$\u0018\u000e^5p]^\u0013\u0018\u000e^3s\u0015\t\t\"#A\u0003he>,\bO\u0003\u0002\u0014)\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005)\u0012!B6bM.\f7\u0001A\u000b\u00031A\u001a2\u0001A\r\"!\tQr$D\u0001\u001c\u0015\taR$\u0001\u0003mC:<'\"\u0001\u0010\u0002\t)\fg/Y\u0005\u0003Am\u0011aa\u00142kK\u000e$\bc\u0001\u0012-]5\t1E\u0003\u0002%K\u00059!/\u001e8uS6,'BA\t'\u0015\t\u0019rE\u0003\u0002\u0016Q)\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0013\ti3EA\bQCJ$\u0018\u000e^5p]^\u0013\u0018\u000e^3s!\ty\u0003\u0007\u0004\u0001\u0005\u000bE\u0002!\u0019\u0001\u001a\u0003\u0003Q\u000b\"aM\u001d\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\u000f9{G\u000f[5oOB\u0011AGO\u0005\u0003wU\u00121!\u00118z\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"AP!\u000e\u0003}R!\u0001\u0011\u000b\u0002\rM,'O^3s\u0013\t\u0011uH\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u0015M,'/[1mSj,'\u000fE\u0002F\u0011:r!A\t$\n\u0005\u001d\u001b\u0013a\u0004)beRLG/[8o/JLG/\u001a:\n\u0005%S%AC*fe&\fG.\u001b>fe*\u0011qiI\u0001\u0010G>l\u0007O]3tg&|g\u000eV=qKB\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0005E;\u0013AB2p[6|g.\u0003\u0002T\u001d\ny1i\\7qe\u0016\u001c8/[8o)f\u0004X-\u0001\u0003uS6,\u0007C\u0001,Z\u001b\u00059&B\u0001-Q\u0003\u0015)H/\u001b7t\u0013\tQvK\u0001\u0003US6,\u0017A\u0002\u001fj]&$h\bF\u0003^?\u0002\f'\rE\u0002_\u00019j\u0011\u0001\u0005\u0005\u0006y\u0015\u0001\r!\u0010\u0005\u0006\u0007\u0016\u0001\r\u0001\u0012\u0005\u0006\u0017\u0016\u0001\r\u0001\u0014\u0005\u0006)\u0016\u0001\r!V\u0001\u001ai\"\u0014X-\u00193M_\u000e\fGNQ;gM\u0016\u00148+\u001e9qY&,'/F\u0001f!\rQb\r[\u0005\u0003On\u00111\u0002\u00165sK\u0006$Gj\\2bYB\u0011\u0011\u000e\u001c\b\u0003-*L!a[,\u0002\u001d\t+hMZ3s'V\u0004\b\u000f\\5fe&\u0011QN\u001c\u0002\u0017\u000fJ|w/\u00192mK\n+hMZ3s'V\u0004\b\u000f\\5fe*\u00111nV\u0001\u001bi\"\u0014X-\u00193M_\u000e\fGNQ;gM\u0016\u00148+\u001e9qY&,'\u000fI\u0001\u0012I&\u0014Xm\u0019;BGRLwN\\)vKV,W#\u0001:\u0013\u0007M4\u0018P\u0002\u0003u\u0013\u0001\u0011(\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0014A\u00053je\u0016\u001cG/Q2uS>t\u0017+^3vK\u0002\u0002\"\u0001N<\n\u0005a,$AB!osJ+g\r\u0005\u0002?u&\u00111p\u0010\u0002\f\u0003\u000e$\u0018n\u001c8Rk\u0016,X-\u0001\tsK\u001eL7\u000f^3s\u0019&\u001cH/\u001a8feR)a0a\u0001\u0002\u0010A\u0011Ag`\u0005\u0004\u0003\u0003)$\u0001B+oSRDq!!\u0002\u000b\u0001\u0004\t9!\u0001\u0002uaB!\u0011\u0011BA\u0006\u001b\u0005\u0001\u0016bAA\u0007!\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA\t\u0015\u0001\u0007\u00111C\u0001\tY&\u001cH/\u001a8feB\u0019Q)!\u0006\n\u0007\u0005]!J\u0001\u0005MSN$XM\\3s\u0003I!WM]3hSN$XM\u001d'jgR,g.\u001a:\u0015\u000by\fi\"a\b\t\u000f\u0005\u00151\u00021\u0001\u0002\b!9\u0011\u0011C\u0006A\u0002\u0005M\u0011AB1qa\u0016tG\r\u0006\u0006\u0002&\u0005-\u0012QFA\u0019\u0003w\u00012\u0001NA\u0014\u0013\r\tI#\u000e\u0002\u0005\u0019>tw\rC\u0004\u0002\u00061\u0001\r!a\u0002\t\u000f\u0005=B\u00021\u0001\u0002&\u0005Q\u0001O]8ek\u000e,'/\u00133\t\u000f\u0005MB\u00021\u0001\u00026\u0005i\u0001O]8ek\u000e,'/\u00129pG\"\u00042\u0001NA\u001c\u0013\r\tI$\u000e\u0002\u0006'\"|'\u000f\u001e\u0005\b\u0003{a\u0001\u0019AA \u0003\u001d\u0011XmY8sIN\u0004R!!\u0011\u0002H9j!!a\u0011\u000b\u0007\u0005\u0015S$\u0001\u0003vi&d\u0017\u0002BA%\u0003\u0007\u0012A\u0001T5ti\u0006Q\u0012\r\u001d9f]\u0012,e\u000e\u001a+sC:\u001c\u0018m\u0019;j_:l\u0015M]6feRa\u0011QEA(\u0003#\n\u0019&!\u0016\u0002`!9\u0011QA\u0007A\u0002\u0005\u001d\u0001bBA\u0018\u001b\u0001\u0007\u0011Q\u0005\u0005\b\u0003gi\u0001\u0019AA\u001b\u0011\u001d\t9&\u0004a\u0001\u00033\n\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0011\u0007Q\nY&C\u0002\u0002^U\u00121!\u00138u\u0011\u001d\t\t'\u0004a\u0001\u0003G\naA]3tk2$\b\u0003BA3\u0003Wj!!a\u001a\u000b\u0007\u0005%\u0004+\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\ti'a\u001a\u0003#Q\u0013\u0018M\\:bGRLwN\u001c*fgVdG/\u0001\bj]R,'O\\1m\u0003B\u0004XM\u001c3\u0015\r\u0005\u0015\u00121OA;\u0011\u001d\t)A\u0004a\u0001\u0003\u000fAq!a\u001e\u000f\u0001\u0004\tI(A\u0007nK6|'/\u001f*fG>\u0014Hm\u001d\t\u0004\u001b\u0006m\u0014bAA?\u001d\niQ*Z7pef\u0014VmY8sIN\u0004")
public class CoordinatorPartitionWriter<T>
implements PartitionWriter<T> {
    private final ReplicaManager replicaManager;
    private final PartitionWriter.Serializer<T> serializer;
    private final CompressionType compressionType;
    private final Time time;
    private final ThreadLocal<BufferSupplier.GrowableBufferSupplier> threadLocalBufferSupplier;
    private final ActionQueue directActionQueue;

    private ThreadLocal<BufferSupplier.GrowableBufferSupplier> threadLocalBufferSupplier() {
        return this.threadLocalBufferSupplier;
    }

    private ActionQueue directActionQueue() {
        return this.directActionQueue;
    }

    public void registerListener(TopicPartition tp, PartitionWriter.Listener listener) {
        this.replicaManager.maybeAddListener(tp, new ListenerAdapter(listener));
    }

    public void deregisterListener(TopicPartition tp, PartitionWriter.Listener listener) {
        this.replicaManager.removeListener(tp, new ListenerAdapter(listener));
    }

    /*
     * WARNING - void declaration
     */
    public long append(TopicPartition tp, long producerId, short producerEpoch, List<T> records) {
        if (records.isEmpty()) {
            throw new IllegalStateException("records must be non-empty.");
        }
        Option<LogConfig> option = this.replicaManager.getLogConfig(tp);
        if (option instanceof Some) {
            long l;
            LogConfig logConfig = (LogConfig)((Some)option).value();
            byte magic = logConfig.recordVersion().value;
            int maxBatchSize = logConfig.maxMessageSize();
            long currentTimeMs = this.time.milliseconds();
            BufferSupplier.GrowableBufferSupplier bufferSupplier = this.threadLocalBufferSupplier().get();
            ByteBuffer buffer = bufferSupplier.get(package$.MODULE$.min(16384, maxBatchSize));
            try {
                void builder_partitionLeaderEpoch;
                void builder_isTransactional;
                void builder_baseSequence;
                void builder_logAppendTime;
                void builder_baseOffset;
                void builder_timestampType;
                int n = -1;
                boolean bl = producerId != -1L;
                boolean bl2 = false;
                long l2 = this.time.milliseconds();
                long l3 = 0L;
                TimestampType timestampType = TimestampType.CREATE_TIME;
                CompressionType builder_compressionType = this.compressionType;
                Object var16_18 = null;
                timestampType = null;
                MemoryRecordsBuilder recordsBuilder = MemoryRecords.builder((ByteBuffer)buffer, (byte)magic, (CompressionType)builder_compressionType, (TimestampType)builder_timestampType, (long)builder_baseOffset, (long)builder_logAppendTime, (long)producerId, (short)producerEpoch, (int)builder_baseSequence, (boolean)builder_isTransactional, (boolean)false, (int)builder_partitionLeaderEpoch);
                records.forEach(record -> {
                    byte[] valueBytes;
                    byte[] keyBytes = $this.serializer.serializeKey(record);
                    if (recordsBuilder.hasRoomFor(currentTimeMs, keyBytes, valueBytes = $this.serializer.serializeValue(record), Record.EMPTY_HEADERS)) {
                        recordsBuilder.append(currentTimeMs, keyBytes, valueBytes, Record.EMPTY_HEADERS);
                        return;
                    }
                    throw new RecordTooLargeException(new StringBuilder(99).append("Message batch size is ").append(recordsBuilder.estimatedSizeInBytes()).append(" bytes ").append("in append to partition ").append(tp).append(" which exceeds the maximum configured size of ").append(maxBatchSize).append(".").toString());
                });
                l = this.internalAppend(tp, recordsBuilder.build());
            }
            finally {
                bufferSupplier.release(buffer);
            }
            return l;
        }
        if (None$.MODULE$.equals(option)) {
            throw Errors.NOT_LEADER_OR_FOLLOWER.exception();
        }
        throw new MatchError(option);
    }

    public long appendEndTransactionMarker(TopicPartition tp, long producerId, short producerEpoch, int coordinatorEpoch, TransactionResult result) {
        ControlRecordType controlRecordType;
        if (TransactionResult.COMMIT.equals(result)) {
            controlRecordType = ControlRecordType.COMMIT;
        } else if (TransactionResult.ABORT.equals(result)) {
            controlRecordType = ControlRecordType.ABORT;
        } else {
            throw new MatchError((Object)result);
        }
        ControlRecordType controlRecordType2 = controlRecordType;
        return this.internalAppend(tp, MemoryRecords.withEndTransactionMarker((long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(controlRecordType2, coordinatorEpoch)));
    }

    private long internalAppend(TopicPartition tp, MemoryRecords memoryRecords) {
        ObjectRef appendResults = ObjectRef.create((Object)((Map)Map$.MODULE$.empty()));
        Map x$5 = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)memoryRecords)}));
        Function1 & Serializable x$6 = (Function1 & Serializable)results -> {
            appendResults.elem = results;
            return BoxedUnit.UNIT;
        };
        ActionQueue x$7 = this.directActionQueue();
        Option<Lock> x$8 = this.replicaManager.appendRecords$default$7();
        Function1<Map<TopicPartition, RecordValidationStats>, BoxedUnit> x$9 = this.replicaManager.appendRecords$default$8();
        RequestLocal x$10 = this.replicaManager.appendRecords$default$9();
        String x$11 = this.replicaManager.appendRecords$default$10();
        this.replicaManager.appendRecords(0L, (short)1, true, AppendOrigin.COORDINATOR, (Map<TopicPartition, MemoryRecords>)x$5, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, x$10, x$11, x$7);
        ProduceResponse.PartitionResponse partitionResult = (ProduceResponse.PartitionResponse)((Map)appendResults.elem).getOrElse((Object)tp, (Function0 & Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(38).append("Append status ").append((Map)appendResults$1.elem).append(" should have partition ").append(tp).append(".").toString());
        });
        Errors errors = partitionResult.error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            throw partitionResult.error.exception();
        }
        return partitionResult.lastOffset + 1L;
    }

    public CoordinatorPartitionWriter(ReplicaManager replicaManager, PartitionWriter.Serializer<T> serializer, CompressionType compressionType, Time time) {
        this.replicaManager = replicaManager;
        this.serializer = serializer;
        this.compressionType = compressionType;
        this.time = time;
        this.threadLocalBufferSupplier = ThreadLocal.withInitial(() -> new BufferSupplier.GrowableBufferSupplier());
        this.directActionQueue = new ActionQueue(null){

            public void add(Function0<BoxedUnit> action) {
                action.apply$mcV$sp();
            }

            public void tryCompleteActions() {
            }
        };
    }
}

