/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.web;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.web.Log4jWebInitializerImpl;
import org.apache.logging.log4j.web.Log4jWebLifeCycle;
import org.apache.logging.log4j.web.Log4jWebSupport;

public final class WebLoggerContextUtils {
    private static final Lock WEB_SUPPORT_LOOKUP = new ReentrantLock();
    private static final String SERVLET_CONTEXT = "__SERVLET_CONTEXT__";

    private WebLoggerContextUtils() {
    }

    public static LoggerContext getWebLoggerContext(ServletContext servletContext) {
        return (LoggerContext)servletContext.getAttribute(Log4jWebSupport.CONTEXT_ATTRIBUTE);
    }

    public static LoggerContext getRequiredWebLoggerContext(ServletContext servletContext) {
        LoggerContext loggerContext = WebLoggerContextUtils.getWebLoggerContext(servletContext);
        if (loggerContext == null) {
            throw new IllegalStateException("No LoggerContext found in ServletContext attribute " + Log4jWebSupport.CONTEXT_ATTRIBUTE);
        }
        return loggerContext;
    }

    public static Log4jWebLifeCycle getWebLifeCycle(ServletContext servletContext) {
        WEB_SUPPORT_LOOKUP.lock();
        try {
            Log4jWebLifeCycle webLifeCycle = (Log4jWebLifeCycle)servletContext.getAttribute(Log4jWebSupport.SUPPORT_ATTRIBUTE);
            if (webLifeCycle == null) {
                webLifeCycle = Log4jWebInitializerImpl.initialize(servletContext);
            }
            Log4jWebLifeCycle log4jWebLifeCycle = webLifeCycle;
            return log4jWebLifeCycle;
        }
        finally {
            WEB_SUPPORT_LOOKUP.unlock();
        }
    }

    public static Runnable wrapExecutionContext(ServletContext servletContext, Runnable runnable) {
        return () -> {
            Log4jWebLifeCycle webSupport = WebLoggerContextUtils.getWebLifeCycle(servletContext);
            webSupport.setLoggerContext();
            try {
                runnable.run();
            }
            finally {
                webSupport.clearLoggerContext();
            }
        };
    }

    public static Map.Entry<String, Object> createExternalEntry(ServletContext servletContext) {
        return new AbstractMap.SimpleEntry<String, ServletContext>(SERVLET_CONTEXT, servletContext);
    }

    public static void setServletContext(LoggerContext lc, ServletContext servletContext) {
        if (lc != null) {
            lc.putObject(SERVLET_CONTEXT, (Object)servletContext);
        }
    }

    public static ServletContext getServletContext() {
        Object obj;
        org.apache.logging.log4j.spi.LoggerContext lc = (org.apache.logging.log4j.spi.LoggerContext)ContextAnchor.THREAD_CONTEXT.get();
        if (lc == null) {
            lc = LogManager.getContext((boolean)false);
        }
        Object object = obj = lc != null ? lc.getObject(SERVLET_CONTEXT) : null;
        if (obj instanceof ServletContext) {
            return (ServletContext)obj;
        }
        return null;
    }
}

