/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import com.carrotsearch.hppc.IntArrayDeque;
import com.carrotsearch.hppc.IntArrayList;
import java.util.ArrayList;
import java.util.List;

public class GraphUtils {
    public static List<IntArrayList> findCoherentSubgraphs(int vertexCount, IArcPredicate arcPredicate, boolean pruneOneNodeSubrgaphs) {
        boolean[] nodesChecked = new boolean[vertexCount];
        ArrayList<IntArrayList> clusterGroups = new ArrayList<IntArrayList>();
        IntArrayDeque nodeQueue = new IntArrayDeque();
        for (int i = 0; i < vertexCount; ++i) {
            if (nodesChecked[i]) continue;
            nodeQueue.clear();
            nodeQueue.addLast(i);
            nodesChecked[i] = true;
            IntArrayList clusterGroup = new IntArrayList();
            while (!nodeQueue.isEmpty()) {
                int node = nodeQueue.removeFirst();
                clusterGroup.add(node);
                for (int j = i + 1; j < vertexCount; ++j) {
                    if (nodesChecked[j] || !arcPredicate.isArcPresent(node, j)) continue;
                    nodeQueue.addLast(j);
                    nodesChecked[j] = true;
                }
            }
            if (clusterGroup.size() <= 1 && pruneOneNodeSubrgaphs) continue;
            clusterGroups.add(clusterGroup);
        }
        return clusterGroups;
    }

    public static interface IArcPredicate {
        public boolean isArcPresent(int var1, int var2);
    }
}

