/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.node;

import com.googlecode.d2j.DexLabel;
import com.googlecode.d2j.visitors.DexDebugVisitor;
import java.util.ArrayList;
import java.util.List;

public class DexDebugNode
extends DexDebugVisitor {
    public List<DexDebugOpNode> debugNodes = new ArrayList<DexDebugOpNode>();
    public List<String> parameterNames;
    public String fineName;

    protected void addDebug(DexDebugOpNode dexDebugNode) {
        this.debugNodes.add(dexDebugNode);
    }

    @Override
    public void visitSetFile(String file) {
        this.fineName = file;
    }

    @Override
    public void visitRestartLocal(int reg, DexLabel label) {
        this.addDebug(new DexDebugOpNode.RestartLocal(label, reg));
    }

    @Override
    public void visitParameterName(int parameterIndex, String name) {
        if (this.parameterNames == null) {
            this.parameterNames = new ArrayList<String>();
        }
        while (this.parameterNames.size() <= parameterIndex) {
            this.parameterNames.add(null);
        }
        this.parameterNames.set(parameterIndex, name);
    }

    @Override
    public void visitLineNumber(int line, DexLabel label) {
        this.addDebug(new DexDebugOpNode.LineNumber(label, line));
    }

    @Override
    public void visitStartLocal(int reg, DexLabel label, String name, String type, String signature) {
        this.addDebug(new DexDebugOpNode.StartLocalNode(label, reg, name, type, signature));
    }

    @Override
    public void visitEndLocal(int reg, DexLabel label) {
        this.addDebug(new DexDebugOpNode.EndLocal(label, reg));
    }

    public void accept(DexDebugVisitor v) {
        if (this.parameterNames != null) {
            for (int i = 0; i < this.parameterNames.size(); ++i) {
                String name = this.parameterNames.get(i);
                if (name == null) continue;
                v.visitParameterName(i, name);
            }
        }
        if (this.debugNodes != null) {
            for (DexDebugOpNode n : this.debugNodes) {
                n.accept(v);
            }
        }
        if (this.fineName != null) {
            v.visitSetFile(this.fineName);
        }
    }

    @Override
    public void visitPrologue(DexLabel dexLabel) {
        this.addDebug(new DexDebugOpNode.Prologue(dexLabel));
    }

    @Override
    public void visitEpiogue(DexLabel dexLabel) {
        this.addDebug(new DexDebugOpNode.Epiogue(dexLabel));
    }

    public static abstract class DexDebugOpNode {
        public DexLabel label;

        protected DexDebugOpNode(DexLabel label) {
            this.label = label;
        }

        public abstract void accept(DexDebugVisitor var1);

        public static class LineNumber
        extends DexDebugOpNode {
            public int line;

            public LineNumber(DexLabel label, int line) {
                super(label);
                this.line = line;
            }

            @Override
            public void accept(DexDebugVisitor cv) {
                cv.visitLineNumber(this.line, this.label);
            }
        }

        public static class RestartLocal
        extends DexDebugOpNode {
            public int reg;

            public RestartLocal(DexLabel label, int reg) {
                super(label);
                this.reg = reg;
            }

            @Override
            public void accept(DexDebugVisitor cv) {
                cv.visitRestartLocal(this.reg, this.label);
            }
        }

        public static class Prologue
        extends DexDebugOpNode {
            public Prologue(DexLabel label) {
                super(label);
            }

            @Override
            public void accept(DexDebugVisitor cv) {
                cv.visitPrologue(this.label);
            }
        }

        public static class Epiogue
        extends DexDebugOpNode {
            public Epiogue(DexLabel label) {
                super(label);
            }

            @Override
            public void accept(DexDebugVisitor cv) {
                cv.visitEpiogue(this.label);
            }
        }

        public static class EndLocal
        extends DexDebugOpNode {
            public int reg;

            public EndLocal(DexLabel label, int reg) {
                super(label);
                this.reg = reg;
            }

            @Override
            public void accept(DexDebugVisitor cv) {
                cv.visitEndLocal(this.reg, this.label);
            }
        }

        public static class StartLocalNode
        extends DexDebugOpNode {
            public int reg;
            public String name;
            public String type;
            public String signature;

            public StartLocalNode(DexLabel label, int reg, String name, String type, String signature) {
                super(label);
                this.reg = reg;
                this.name = name;
                this.type = type;
                this.signature = signature;
            }

            @Override
            public void accept(DexDebugVisitor cv) {
                cv.visitStartLocal(this.reg, this.label, this.name, this.type, this.signature);
            }
        }
    }
}

