/*
 * Decompiled with CFR 0.152.
 */
package com.pff;

import com.pff.DescriptorIndexNode;
import com.pff.PSTDescriptorItem;
import com.pff.PSTException;
import com.pff.PSTFile;
import com.pff.PSTMessage;
import com.pff.PSTObject;
import com.pff.PSTTableBC;
import com.pff.PSTTableBCItem;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class PSTDistList
extends PSTMessage {
    private final byte[] oneOffEntryIdUid = new byte[]{-127, 43, 31, -92, -66, -93, 16, 25, -99, 110, 0, -35, 1, 15, 84, 2};
    private final byte[] wrappedEntryIdUid = new byte[]{-64, -111, -83, -45, 81, -99, -49, 17, -92, -87, 0, -86, 0, 71, -6, -92};

    PSTDistList(PSTFile theFile, DescriptorIndexNode descriptorIndexNode) throws PSTException, IOException {
        super(theFile, descriptorIndexNode);
    }

    PSTDistList(PSTFile theFile, DescriptorIndexNode folderIndexNode, PSTTableBC table, HashMap<Integer, PSTDescriptorItem> localDescriptorItems) {
        super(theFile, folderIndexNode, table, localDescriptorItems);
    }

    private int findNextNullChar(byte[] data, int start) {
        while (start < data.length && (data[start] != 0 || data[start + 1] != 0)) {
            start += 2;
        }
        return start;
    }

    private OneOffEntry parseOneOffEntry(byte[] data, int pos) throws IOException {
        int version = (int)PSTObject.convertLittleEndianBytesToLong(data, pos, pos + 2);
        int additionalFlags = (int)PSTObject.convertLittleEndianBytesToLong(data, pos += 2, pos + 2);
        pos += 2;
        int pad = additionalFlags & 0x8000;
        int mae = additionalFlags & 0xC00;
        int format = additionalFlags & 0x1E00;
        int m = additionalFlags & 0x100;
        int u = additionalFlags & 0x80;
        int r = additionalFlags & 0x60;
        int l = additionalFlags & 0x10;
        int pad2 = additionalFlags & 0xF;
        int stringEnd = this.findNextNullChar(data, pos);
        byte[] displayNameBytes = new byte[stringEnd - pos];
        System.arraycopy(data, pos, displayNameBytes, 0, displayNameBytes.length);
        String displayName = new String(displayNameBytes, "UTF-16LE");
        pos = stringEnd + 2;
        stringEnd = this.findNextNullChar(data, pos);
        byte[] addressTypeBytes = new byte[stringEnd - pos];
        System.arraycopy(data, pos, addressTypeBytes, 0, addressTypeBytes.length);
        String addressType = new String(addressTypeBytes, "UTF-16LE");
        pos = stringEnd + 2;
        stringEnd = this.findNextNullChar(data, pos);
        byte[] emailAddressBytes = new byte[stringEnd - pos];
        System.arraycopy(data, pos, emailAddressBytes, 0, emailAddressBytes.length);
        String emailAddress = new String(emailAddressBytes, "UTF-16LE");
        pos = stringEnd + 2;
        OneOffEntry out = new OneOffEntry();
        out.displayName = displayName;
        out.addressType = addressType;
        out.emailAddress = emailAddress;
        out.pos = pos;
        return out;
    }

    public Object[] getDistributionListMembers() throws PSTException, IOException {
        PSTTableBCItem item = (PSTTableBCItem)this.items.get(this.pstFile.getNameToIdMapItem(32853, 2));
        Object[] out = new Object[]{};
        if (item != null) {
            int pos = 0;
            int count = (int)PSTObject.convertLittleEndianBytesToLong(item.data, pos, pos + 4);
            out = new Object[count];
            pos += 4;
            pos = (int)PSTObject.convertLittleEndianBytesToLong(item.data, pos, pos + 4);
            for (int x = 0; x < count; ++x) {
                int flags = (int)PSTObject.convertLittleEndianBytesToLong(item.data, pos, pos + 4);
                byte[] guid = new byte[16];
                System.arraycopy(item.data, pos += 4, guid, 0, guid.length);
                pos += 16;
                if (Arrays.equals(guid, this.wrappedEntryIdUid)) {
                    int entryType = item.data[pos] & 0xF;
                    int entryAddressType = item.data[pos] & 7;
                    boolean isOneOffEntryId = (item.data[pos] & 0x80) > 0;
                    int wrappedflags = (int)PSTObject.convertLittleEndianBytesToLong(item.data, ++pos, pos + 4);
                    byte[] guid2 = new byte[16];
                    System.arraycopy(item.data, pos += 4, guid, 0, guid.length);
                    int descriptorIndex = (int)PSTObject.convertLittleEndianBytesToLong(item.data, pos += 16, pos + 3);
                    byte empty = item.data[pos += 3];
                    ++pos;
                    out[x] = PSTObject.detectAndLoadPSTObject(this.pstFile, descriptorIndex);
                    continue;
                }
                if (!Arrays.equals(guid, this.oneOffEntryIdUid)) continue;
                OneOffEntry entry = this.parseOneOffEntry(item.data, pos);
                pos = entry.pos;
                out[x] = entry;
            }
        }
        return out;
    }

    public class OneOffEntry {
        private String displayName = "";
        private String addressType = "";
        private String emailAddress = "";
        private int pos = 0;

        public String getDisplayName() {
            return this.displayName;
        }

        public String getAddressType() {
            return this.addressType;
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        public String toString() {
            return String.format("Display Name: %s\nAddress Type: %s\nEmail Address: %s\n", this.displayName, this.addressType, this.emailAddress);
        }
    }
}

