/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.startup;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.openide.util.NbBundle;

abstract class ImportPanel
extends JPanel {
    private static final String KEY_FOLDER = "settings_folder";
    private final JProgressBar progress;
    private final JTextPane text2;
    private final JButton importB;
    private final JButton skipB;
    private final JRadioButton latest;
    private final JRadioButton recent;
    private final JRadioButton custom;
    private File selected;
    private File userdirsRoot;

    ImportPanel(final File latestRelease, final File recentlyUsed, File userdirsRoot, final String firstSupported) {
        super(new GridBagLayout());
        final Color disabledText = UIManager.getLookAndFeel().getID().equals("GTK") ? UIManager.getColor("Label.disabledShadow") : UIManager.getColor("Label.disabledForeground");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(25, 15, 10, 15);
        c.anchor = 18;
        c.fill = 2;
        c.gridwidth = 0;
        JTextPane text1 = new JTextPane();
        text1.setContentType("text/html");
        text1.setFont(UIManager.getFont("Label.font"));
        text1.setOpaque(false);
        text1.setEditable(false);
        text1.setFocusable(false);
        text1.setRequestFocusEnabled(false);
        ImportPanel.setHtmlText(text1, NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_Msg1"));
        this.add((Component)text1, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 25, 0, 15);
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = 0;
        this.latest = new JRadioButton(){

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                super.fireItemStateChanged(event);
                if (event.getStateChange() == 1) {
                    ImportPanel.this.selected = latestRelease;
                }
            }
        };
        this.latest.setText(ImportPanel.getHtmlText(this.latest, "<nobr>" + latestRelease.getName() + " <span style=\"color:" + ImportPanel.getColorText(disabledText) + ";\">" + NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_OptionLatestRelease") + "</span></nobr>"));
        this.latest.putClientProperty(KEY_FOLDER, latestRelease);
        this.latest.setSelected(true);
        this.latest.setToolTipText(latestRelease.getAbsolutePath());
        this.add((Component)this.latest, c);
        if (recentlyUsed != null && !recentlyUsed.equals(latestRelease)) {
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.insets = new Insets(0, 25, 0, 15);
            c.anchor = 17;
            c.fill = 0;
            c.gridwidth = 0;
            this.recent = new JRadioButton(){

                @Override
                protected void fireItemStateChanged(ItemEvent event) {
                    super.fireItemStateChanged(event);
                    if (event.getStateChange() == 1) {
                        ImportPanel.this.selected = recentlyUsed;
                    }
                }
            };
            this.recent.setText(ImportPanel.getHtmlText(this.recent, "<nobr>" + recentlyUsed.getName() + " <span style=\"color:" + ImportPanel.getColorText(disabledText) + ";\">" + NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_OptionRecentlyUsed") + "</span></nobr>"));
            this.recent.setToolTipText(recentlyUsed.getAbsolutePath());
            this.recent.putClientProperty(KEY_FOLDER, recentlyUsed);
            this.add((Component)this.recent, c);
        } else {
            this.recent = null;
        }
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.insets = new Insets(0, 25, 0, 15);
        c.anchor = 17;
        c.fill = 0;
        this.custom = new JRadioButton(){

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                super.fireItemStateChanged(event);
                if (event.getStateChange() == 1) {
                    ImportPanel.this.selected = null;
                    this.setText(ImportPanel.getHtmlText(ImportPanel.this.custom, "<nobr>" + NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_OptionSelectCustom") + " <span style=\"color:" + ImportPanel.getColorText(disabledText) + ";\">" + NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_OptionSelectCustom2", (Object)firstSupported) + "</span></nobr>"));
                } else if (event.getStateChange() == 2) {
                    this.setText(ImportPanel.getHtmlText(ImportPanel.this.custom, "<nobr>" + NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_OptionSelectCustom") + "</nobr>"));
                }
            }
        };
        this.custom.setText(ImportPanel.getHtmlText(this.custom, "<nobr>" + NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_OptionSelectCustom") + "</nobr>"));
        this.custom.setToolTipText(NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_OptionSelectCustomTooltip"));
        this.custom.putClientProperty(KEY_FOLDER, null);
        this.add((Component)this.custom, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.insets = new Insets(30, 15, 10, 15);
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 0;
        this.progress = new JProgressBar();
        this.progress.setString(NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_ProgressText"));
        this.progress.setStringPainted(true);
        this.progress.setVisible(false);
        this.add((Component)this.progress, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        c.insets = new Insets(30, 15, 10, 15);
        c.anchor = 18;
        c.fill = 2;
        c.gridwidth = 0;
        this.text2 = new JTextPane();
        this.text2.setContentType("text/html");
        this.text2.setFont(UIManager.getFont("Label.font"));
        this.text2.setOpaque(false);
        this.text2.setEditable(false);
        this.text2.setFocusable(false);
        this.text2.setRequestFocusEnabled(false);
        ImportPanel.setHtmlText(this.text2, NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_Msg2"));
        this.add((Component)this.text2, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 6;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 18;
        c.fill = 1;
        c.gridwidth = 0;
        JPanel f = new JPanel(null);
        f.setOpaque(false);
        this.add((Component)f, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 7;
        c.weightx = 1.0;
        c.insets = new Insets(25, 15, 10, 5);
        c.anchor = 13;
        c.fill = 0;
        this.importB = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                ImportPanel.this.importImpl();
            }
        };
        this.importB.setText(NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_ImportButton"));
        this.importB.setDefaultCapable(true);
        this.add((Component)this.importB, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 7;
        c.insets = new Insets(25, 0, 10, 10);
        c.anchor = 13;
        c.fill = 0;
        this.skipB = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                ImportPanel.this.skipImpl();
            }
        };
        this.skipB.setText(NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_SkipButton"));
        this.skipB.setDefaultCapable(false);
        this.add((Component)this.skipB, c);
        ButtonGroup userdirs = new ButtonGroup();
        userdirs.add(this.latest);
        if (this.recent != null) {
            userdirs.add(this.recent);
        }
        userdirs.add(this.custom);
        ImportPanel.makeSameSize(this.importB, this.skipB);
        this.selected = latestRelease;
        this.userdirsRoot = userdirsRoot;
    }

    abstract boolean isSupportedImport(File var1);

    abstract void contentsChanged();

    abstract void beforeImport();

    abstract void doImport(File var1) throws Exception;

    abstract void afterImport();

    abstract void close();

    JButton getDefaultButton() {
        return this.importB;
    }

    private void importImpl() {
        File source;
        if (this.selected == null) {
            source = this.customImpl();
            if (source == null) {
                return;
            }
        } else {
            source = this.selected;
        }
        this.beforeImport();
        new SwingWorker<String, Void>(){
            {
                if (ImportPanel.this.latest.getClientProperty(ImportPanel.KEY_FOLDER) != ImportPanel.this.selected) {
                    ImportPanel.this.latest.setEnabled(false);
                }
                if (ImportPanel.this.recent != null && ImportPanel.this.recent.getClientProperty(ImportPanel.KEY_FOLDER) != ImportPanel.this.selected) {
                    ImportPanel.this.recent.setEnabled(false);
                }
                if (ImportPanel.this.custom.getClientProperty(ImportPanel.KEY_FOLDER) != ImportPanel.this.selected) {
                    ImportPanel.this.custom.setEnabled(false);
                }
                ImportPanel.this.importB.setEnabled(false);
                ImportPanel.this.skipB.setEnabled(false);
                ImportPanel.this.text2.setVisible(false);
                if (!"Aqua".equals(UIManager.getLookAndFeel().getID())) {
                    ImportPanel.this.progress.setIndeterminate(true);
                }
                ImportPanel.this.progress.setVisible(true);
            }

            @Override
            protected String doInBackground() throws Exception {
                try {
                    ImportPanel.this.doImport(source);
                    return null;
                }
                catch (Exception e) {
                    return e.getLocalizedMessage();
                }
            }

            @Override
            public void done() {
                String result;
                ImportPanel.this.afterImport();
                try {
                    result = (String)this.get();
                }
                catch (InterruptedException | ExecutionException ex) {
                    result = ex.getLocalizedMessage();
                }
                if (!"Aqua".equals(UIManager.getLookAndFeel().getID())) {
                    ImportPanel.this.progress.setIndeterminate(false);
                }
                if (result != null) {
                    ImportPanel.this.progress.setVisible(false);
                    ImportPanel.this.setHint("<nobr><b>" + NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_ImportFailed") + "</b><br>" + result + "</nobr>");
                    ImportPanel.this.text2.setVisible(true);
                    ImportPanel.this.importB.setEnabled(true);
                    ImportPanel.this.skipB.setEnabled(true);
                    ImportPanel.this.latest.setEnabled(true);
                    if (ImportPanel.this.recent != null) {
                        ImportPanel.this.recent.setEnabled(true);
                    }
                    ImportPanel.this.custom.setEnabled(true);
                } else {
                    ImportPanel.this.close();
                }
            }
        }.execute();
    }

    private void skipImpl() {
        this.close();
    }

    private File customImpl() {
        final JFileChooser ch = new JFileChooser(this.userdirsRoot){

            @Override
            public void approveSelection() {
                if (NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_ImportButton").equals(this.getApproveButtonText())) {
                    super.approveSelection();
                } else {
                    File f = this.getSelectedFile();
                    if (f == null) {
                        f = this.getCurrentDirectory();
                    }
                    this.setCurrentDirectory(f);
                }
            }
        };
        ch.setDialogType(2);
        ch.setDialogTitle(NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_CustomDirCaption"));
        ch.setApproveButtonText(NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_OpenButton"));
        ch.setApproveButtonToolTipText(NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_OpenButtonTooltip"));
        ch.setMultiSelectionEnabled(false);
        ch.setFileSelectionMode(1);
        ch.setAcceptAllFileFilterUsed(false);
        ch.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_SettingsFilter");
            }
        });
        ch.setSelectedFile(null);
        ch.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("SelectedFileChangedProperty".equals(evt.getPropertyName()) || "directoryChanged".equals(evt.getPropertyName())) {
                    File f = ch.getSelectedFile();
                    if (f == null) {
                        f = ch.getCurrentDirectory();
                    }
                    if (f != null && ImportPanel.this.isSupportedImport(f)) {
                        ch.setApproveButtonText(NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_ImportButton"));
                        ch.setApproveButtonToolTipText(NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_ImportButtonTooltip"));
                    } else {
                        ch.setApproveButtonText(NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_OpenButton"));
                        ch.setApproveButtonToolTipText(NbBundle.getMessage(ImportPanel.class, (String)"ImportPanel_OpenButtonTooltip"));
                    }
                }
            }
        });
        if (ch.showDialog(this.latest, null) == 0) {
            File userdir = ch.getSelectedFile();
            this.userdirsRoot = userdir == null ? null : userdir.getParentFile();
            return userdir;
        }
        return null;
    }

    private void setHint(String text) {
        ImportPanel.setHtmlText(this.text2, text);
        this.contentsChanged();
    }

    private static void makeSameSize(JButton button1, JButton button2) {
        Dimension dim1 = button1.getPreferredSize();
        Dimension dim2 = button2.getPreferredSize();
        int maxWidth = Math.max(dim1.width, dim2.width);
        int maxHeight = Math.max(dim1.height, dim2.height);
        button1.setPreferredSize(new Dimension(maxWidth, maxHeight));
        button2.setPreferredSize(new Dimension(maxWidth, maxHeight));
    }

    private static void setHtmlText(JTextPane pane, String text) {
        pane.setDocument(pane.getEditorKit().createDefaultDocument());
        pane.setText(ImportPanel.getHtmlText(pane, text));
        pane.setCaretPosition(0);
    }

    private static String getHtmlText(JComponent component, String text) {
        Font font = component.getFont();
        String rgb = ImportPanel.getColorText(component.getForeground());
        return "<html><body text=\"" + rgb + "\" style=\"font-size: " + font.getSize() + "pt; font-family: " + font.getName() + ";\">" + text + "</body></html>";
    }

    private static String getColorText(Color color) {
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }
}

